/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.Deserializer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeserializerMarshaller {
    private static final MarshallingInfo<StructuredPojo> OPENXJSONSERDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OpenXJsonSerDe").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HIVEJSONSERDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HiveJsonSerDe").isBinary(false).build();
    private static final DeserializerMarshaller INSTANCE = new DeserializerMarshaller();

    private DeserializerMarshaller() {
    }

    public static DeserializerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Deserializer deserializer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deserializer, (String)"deserializer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deserializer.openXJsonSerDe(), OPENXJSONSERDE_BINDING);
            protocolMarshaller.marshall((Object)deserializer.hiveJsonSerDe(), HIVEJSONSERDE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

