/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.CopyCommand;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CopyCommandMarshaller {
    private static final MarshallingInfo<String> DATATABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTableName").isBinary(false).build();
    private static final MarshallingInfo<String> DATATABLECOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTableColumns").isBinary(false).build();
    private static final MarshallingInfo<String> COPYOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CopyOptions").isBinary(false).build();
    private static final CopyCommandMarshaller INSTANCE = new CopyCommandMarshaller();

    private CopyCommandMarshaller() {
    }

    public static CopyCommandMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CopyCommand copyCommand, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)copyCommand, (String)"copyCommand");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)copyCommand.dataTableName(), DATATABLENAME_BINDING);
            protocolMarshaller.marshall((Object)copyCommand.dataTableColumns(), DATATABLECOLUMNS_BINDING);
            protocolMarshaller.marshall((Object)copyCommand.copyOptions(), COPYOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

