/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.ListOfNonEmptyStringsCopier;
import software.amazon.awssdk.services.firehose.transform.HiveJsonSerDeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HiveJsonSerDe
implements StructuredPojo,
ToCopyableBuilder<Builder, HiveJsonSerDe> {
    private final List<String> timestampFormats;

    private HiveJsonSerDe(BuilderImpl builder) {
        this.timestampFormats = builder.timestampFormats;
    }

    public List<String> timestampFormats() {
        return this.timestampFormats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampFormats());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HiveJsonSerDe)) {
            return false;
        }
        HiveJsonSerDe other = (HiveJsonSerDe)obj;
        return Objects.equals(this.timestampFormats(), other.timestampFormats());
    }

    public String toString() {
        return ToString.builder((String)"HiveJsonSerDe").add("TimestampFormats", this.timestampFormats()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimestampFormats": {
                return Optional.ofNullable(clazz.cast(this.timestampFormats()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HiveJsonSerDeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> timestampFormats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HiveJsonSerDe model) {
            this.timestampFormats(model.timestampFormats);
        }

        public final Collection<String> getTimestampFormats() {
            return this.timestampFormats;
        }

        @Override
        public final Builder timestampFormats(Collection<String> timestampFormats) {
            this.timestampFormats = ListOfNonEmptyStringsCopier.copy(timestampFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestampFormats(String ... timestampFormats) {
            this.timestampFormats(Arrays.asList(timestampFormats));
            return this;
        }

        public final void setTimestampFormats(Collection<String> timestampFormats) {
            this.timestampFormats = ListOfNonEmptyStringsCopier.copy(timestampFormats);
        }

        public HiveJsonSerDe build() {
            return new HiveJsonSerDe(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HiveJsonSerDe> {
        public Builder timestampFormats(Collection<String> var1);

        public Builder timestampFormats(String ... var1);
    }
}

