/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.ResourcePermission;
import software.amazon.awssdk.services.finspacedata.model.ResourcePermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PermissionGroupParams
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PermissionGroupParams> {
    private static final SdkField<String> PERMISSION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionGroupId").getter(PermissionGroupParams.getter(PermissionGroupParams::permissionGroupId)).setter(PermissionGroupParams.setter(Builder::permissionGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionGroupId").build()}).build();
    private static final SdkField<List<ResourcePermission>> DATASET_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("datasetPermissions").getter(PermissionGroupParams.getter(PermissionGroupParams::datasetPermissions)).setter(PermissionGroupParams.setter(Builder::datasetPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_GROUP_ID_FIELD, DATASET_PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PermissionGroupParams.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String permissionGroupId;
    private final List<ResourcePermission> datasetPermissions;

    private PermissionGroupParams(BuilderImpl builder) {
        this.permissionGroupId = builder.permissionGroupId;
        this.datasetPermissions = builder.datasetPermissions;
    }

    public final String permissionGroupId() {
        return this.permissionGroupId;
    }

    public final boolean hasDatasetPermissions() {
        return this.datasetPermissions != null && !(this.datasetPermissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> datasetPermissions() {
        return this.datasetPermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetPermissions() ? this.datasetPermissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionGroupParams)) {
            return false;
        }
        PermissionGroupParams other = (PermissionGroupParams)obj;
        return Objects.equals(this.permissionGroupId(), other.permissionGroupId()) && this.hasDatasetPermissions() == other.hasDatasetPermissions() && Objects.equals(this.datasetPermissions(), other.datasetPermissions());
    }

    public final String toString() {
        return ToString.builder((String)"PermissionGroupParams").add("PermissionGroupId", (Object)this.permissionGroupId()).add("DatasetPermissions", this.hasDatasetPermissions() ? this.datasetPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "permissionGroupId": {
                return Optional.ofNullable(clazz.cast(this.permissionGroupId()));
            }
            case "datasetPermissions": {
                return Optional.ofNullable(clazz.cast(this.datasetPermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("permissionGroupId", PERMISSION_GROUP_ID_FIELD);
        map.put("datasetPermissions", DATASET_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PermissionGroupParams, T> g) {
        return obj -> g.apply((PermissionGroupParams)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String permissionGroupId;
        private List<ResourcePermission> datasetPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionGroupParams model) {
            this.permissionGroupId(model.permissionGroupId);
            this.datasetPermissions(model.datasetPermissions);
        }

        public final String getPermissionGroupId() {
            return this.permissionGroupId;
        }

        public final void setPermissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
        }

        @Override
        public final Builder permissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
            return this;
        }

        public final List<ResourcePermission.Builder> getDatasetPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionsListCopier.copyToBuilder(this.datasetPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetPermissions(Collection<ResourcePermission.BuilderImpl> datasetPermissions) {
            this.datasetPermissions = ResourcePermissionsListCopier.copyFromBuilder(datasetPermissions);
        }

        @Override
        public final Builder datasetPermissions(Collection<ResourcePermission> datasetPermissions) {
            this.datasetPermissions = ResourcePermissionsListCopier.copy(datasetPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetPermissions(ResourcePermission ... datasetPermissions) {
            this.datasetPermissions(Arrays.asList(datasetPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetPermissions(Consumer<ResourcePermission.Builder> ... datasetPermissions) {
            this.datasetPermissions(Stream.of(datasetPermissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PermissionGroupParams build() {
            return new PermissionGroupParams(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PermissionGroupParams> {
        public Builder permissionGroupId(String var1);

        public Builder datasetPermissions(Collection<ResourcePermission> var1);

        public Builder datasetPermissions(ResourcePermission ... var1);

        public Builder datasetPermissions(Consumer<ResourcePermission.Builder> ... var1);
    }
}

