/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.ApiAccess;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.services.finspacedata.model.UserStatus;
import software.amazon.awssdk.services.finspacedata.model.UserType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUserResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, GetUserResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(GetUserResponse.getter(GetUserResponse::userId)).setter(GetUserResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetUserResponse.getter(GetUserResponse::statusAsString)).setter(GetUserResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firstName").getter(GetUserResponse.getter(GetUserResponse::firstName)).setter(GetUserResponse.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastName").getter(GetUserResponse.getter(GetUserResponse::lastName)).setter(GetUserResponse.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastName").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("emailAddress").getter(GetUserResponse.getter(GetUserResponse::emailAddress)).setter(GetUserResponse.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetUserResponse.getter(GetUserResponse::typeAsString)).setter(GetUserResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> API_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiAccess").getter(GetUserResponse.getter(GetUserResponse::apiAccessAsString)).setter(GetUserResponse.setter(Builder::apiAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccess").build()}).build();
    private static final SdkField<String> API_ACCESS_PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiAccessPrincipalArn").getter(GetUserResponse.getter(GetUserResponse::apiAccessPrincipalArn)).setter(GetUserResponse.setter(Builder::apiAccessPrincipalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccessPrincipalArn").build()}).build();
    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createTime").getter(GetUserResponse.getter(GetUserResponse::createTime)).setter(GetUserResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Long> LAST_ENABLED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastEnabledTime").getter(GetUserResponse.getter(GetUserResponse::lastEnabledTime)).setter(GetUserResponse.setter(Builder::lastEnabledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastEnabledTime").build()}).build();
    private static final SdkField<Long> LAST_DISABLED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastDisabledTime").getter(GetUserResponse.getter(GetUserResponse::lastDisabledTime)).setter(GetUserResponse.setter(Builder::lastDisabledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDisabledTime").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedTime").getter(GetUserResponse.getter(GetUserResponse::lastModifiedTime)).setter(GetUserResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final SdkField<Long> LAST_LOGIN_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastLoginTime").getter(GetUserResponse.getter(GetUserResponse::lastLoginTime)).setter(GetUserResponse.setter(Builder::lastLoginTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastLoginTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, STATUS_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, EMAIL_ADDRESS_FIELD, TYPE_FIELD, API_ACCESS_FIELD, API_ACCESS_PRINCIPAL_ARN_FIELD, CREATE_TIME_FIELD, LAST_ENABLED_TIME_FIELD, LAST_DISABLED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_LOGIN_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetUserResponse.memberNameToFieldInitializer();
    private final String userId;
    private final String status;
    private final String firstName;
    private final String lastName;
    private final String emailAddress;
    private final String type;
    private final String apiAccess;
    private final String apiAccessPrincipalArn;
    private final Long createTime;
    private final Long lastEnabledTime;
    private final Long lastDisabledTime;
    private final Long lastModifiedTime;
    private final Long lastLoginTime;

    private GetUserResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.status = builder.status;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.emailAddress = builder.emailAddress;
        this.type = builder.type;
        this.apiAccess = builder.apiAccess;
        this.apiAccessPrincipalArn = builder.apiAccessPrincipalArn;
        this.createTime = builder.createTime;
        this.lastEnabledTime = builder.lastEnabledTime;
        this.lastDisabledTime = builder.lastDisabledTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastLoginTime = builder.lastLoginTime;
    }

    public final String userId() {
        return this.userId;
    }

    public final UserStatus status() {
        return UserStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final UserType type() {
        return UserType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ApiAccess apiAccess() {
        return ApiAccess.fromValue(this.apiAccess);
    }

    public final String apiAccessAsString() {
        return this.apiAccess;
    }

    public final String apiAccessPrincipalArn() {
        return this.apiAccessPrincipalArn;
    }

    public final Long createTime() {
        return this.createTime;
    }

    public final Long lastEnabledTime() {
        return this.lastEnabledTime;
    }

    public final Long lastDisabledTime() {
        return this.lastDisabledTime;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Long lastLoginTime() {
        return this.lastLoginTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiAccessPrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEnabledTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDisabledTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastLoginTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserResponse)) {
            return false;
        }
        GetUserResponse other = (GetUserResponse)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.apiAccessAsString(), other.apiAccessAsString()) && Objects.equals(this.apiAccessPrincipalArn(), other.apiAccessPrincipalArn()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.lastEnabledTime(), other.lastEnabledTime()) && Objects.equals(this.lastDisabledTime(), other.lastDisabledTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastLoginTime(), other.lastLoginTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetUserResponse").add("UserId", (Object)this.userId()).add("Status", (Object)this.statusAsString()).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("ApiAccess", (Object)this.apiAccessAsString()).add("ApiAccessPrincipalArn", (Object)this.apiAccessPrincipalArn()).add("CreateTime", (Object)this.createTime()).add("LastEnabledTime", (Object)this.lastEnabledTime()).add("LastDisabledTime", (Object)this.lastDisabledTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastLoginTime", (Object)this.lastLoginTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "firstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "lastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "emailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "apiAccess": {
                return Optional.ofNullable(clazz.cast(this.apiAccessAsString()));
            }
            case "apiAccessPrincipalArn": {
                return Optional.ofNullable(clazz.cast(this.apiAccessPrincipalArn()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "lastEnabledTime": {
                return Optional.ofNullable(clazz.cast(this.lastEnabledTime()));
            }
            case "lastDisabledTime": {
                return Optional.ofNullable(clazz.cast(this.lastDisabledTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "lastLoginTime": {
                return Optional.ofNullable(clazz.cast(this.lastLoginTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", USER_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("firstName", FIRST_NAME_FIELD);
        map.put("lastName", LAST_NAME_FIELD);
        map.put("emailAddress", EMAIL_ADDRESS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("apiAccess", API_ACCESS_FIELD);
        map.put("apiAccessPrincipalArn", API_ACCESS_PRINCIPAL_ARN_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("lastEnabledTime", LAST_ENABLED_TIME_FIELD);
        map.put("lastDisabledTime", LAST_DISABLED_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("lastLoginTime", LAST_LOGIN_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUserResponse, T> g) {
        return obj -> g.apply((GetUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private String userId;
        private String status;
        private String firstName;
        private String lastName;
        private String emailAddress;
        private String type;
        private String apiAccess;
        private String apiAccessPrincipalArn;
        private Long createTime;
        private Long lastEnabledTime;
        private Long lastDisabledTime;
        private Long lastModifiedTime;
        private Long lastLoginTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserResponse model) {
            super(model);
            this.userId(model.userId);
            this.status(model.status);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.emailAddress(model.emailAddress);
            this.type(model.type);
            this.apiAccess(model.apiAccess);
            this.apiAccessPrincipalArn(model.apiAccessPrincipalArn);
            this.createTime(model.createTime);
            this.lastEnabledTime(model.lastEnabledTime);
            this.lastDisabledTime(model.lastDisabledTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastLoginTime(model.lastLoginTime);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getApiAccess() {
            return this.apiAccess;
        }

        public final void setApiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
        }

        @Override
        public final Builder apiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
            return this;
        }

        @Override
        public final Builder apiAccess(ApiAccess apiAccess) {
            this.apiAccess(apiAccess == null ? null : apiAccess.toString());
            return this;
        }

        public final String getApiAccessPrincipalArn() {
            return this.apiAccessPrincipalArn;
        }

        public final void setApiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
        }

        @Override
        public final Builder apiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
            return this;
        }

        public final Long getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Long getLastEnabledTime() {
            return this.lastEnabledTime;
        }

        public final void setLastEnabledTime(Long lastEnabledTime) {
            this.lastEnabledTime = lastEnabledTime;
        }

        @Override
        public final Builder lastEnabledTime(Long lastEnabledTime) {
            this.lastEnabledTime = lastEnabledTime;
            return this;
        }

        public final Long getLastDisabledTime() {
            return this.lastDisabledTime;
        }

        public final void setLastDisabledTime(Long lastDisabledTime) {
            this.lastDisabledTime = lastDisabledTime;
        }

        @Override
        public final Builder lastDisabledTime(Long lastDisabledTime) {
            this.lastDisabledTime = lastDisabledTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Long getLastLoginTime() {
            return this.lastLoginTime;
        }

        public final void setLastLoginTime(Long lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
        }

        @Override
        public final Builder lastLoginTime(Long lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
            return this;
        }

        @Override
        public GetUserResponse build() {
            return new GetUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUserResponse> {
        public Builder userId(String var1);

        public Builder status(String var1);

        public Builder status(UserStatus var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder emailAddress(String var1);

        public Builder type(String var1);

        public Builder type(UserType var1);

        public Builder apiAccess(String var1);

        public Builder apiAccess(ApiAccess var1);

        public Builder apiAccessPrincipalArn(String var1);

        public Builder createTime(Long var1);

        public Builder lastEnabledTime(Long var1);

        public Builder lastDisabledTime(Long var1);

        public Builder lastModifiedTime(Long var1);

        public Builder lastLoginTime(Long var1);
    }
}

