/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatasetKind {
    TABULAR("TABULAR"),
    NON_TABULAR("NON_TABULAR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatasetKind> VALUE_MAP;
    private final String value;

    private DatasetKind(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatasetKind fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatasetKind> knownValues() {
        EnumSet<DatasetKind> knownValues = EnumSet.allOf(DatasetKind.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatasetKind.class, DatasetKind::toString);
    }
}

