/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.finspacedata.model.ChangeType;
import software.amazon.awssdk.services.finspacedata.model.ChangesetErrorInfo;
import software.amazon.awssdk.services.finspacedata.model.FormatParamsCopier;
import software.amazon.awssdk.services.finspacedata.model.IngestionStatus;
import software.amazon.awssdk.services.finspacedata.model.SourceParamsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangesetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangesetSummary> {
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changesetId").getter(ChangesetSummary.getter(ChangesetSummary::changesetId)).setter(ChangesetSummary.setter(Builder::changesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()}).build();
    private static final SdkField<String> CHANGESET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changesetArn").getter(ChangesetSummary.getter(ChangesetSummary::changesetArn)).setter(ChangesetSummary.setter(Builder::changesetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetArn").build()}).build();
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(ChangesetSummary.getter(ChangesetSummary::datasetId)).setter(ChangesetSummary.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()}).build();
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changeType").getter(ChangesetSummary.getter(ChangesetSummary::changeTypeAsString)).setter(ChangesetSummary.setter(Builder::changeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()}).build();
    private static final SdkField<Map<String, String>> SOURCE_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sourceParams").getter(ChangesetSummary.getter(ChangesetSummary::sourceParams)).setter(ChangesetSummary.setter(Builder::sourceParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceParams").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> FORMAT_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("formatParams").getter(ChangesetSummary.getter(ChangesetSummary::formatParams)).setter(ChangesetSummary.setter(Builder::formatParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatParams").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createTime").getter(ChangesetSummary.getter(ChangesetSummary::createTime)).setter(ChangesetSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ChangesetSummary.getter(ChangesetSummary::statusAsString)).setter(ChangesetSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ChangesetErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorInfo").getter(ChangesetSummary.getter(ChangesetSummary::errorInfo)).setter(ChangesetSummary.setter(Builder::errorInfo)).constructor(ChangesetErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final SdkField<Long> ACTIVE_UNTIL_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("activeUntilTimestamp").getter(ChangesetSummary.getter(ChangesetSummary::activeUntilTimestamp)).setter(ChangesetSummary.setter(Builder::activeUntilTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeUntilTimestamp").build()}).build();
    private static final SdkField<Long> ACTIVE_FROM_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("activeFromTimestamp").getter(ChangesetSummary.getter(ChangesetSummary::activeFromTimestamp)).setter(ChangesetSummary.setter(Builder::activeFromTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeFromTimestamp").build()}).build();
    private static final SdkField<String> UPDATES_CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatesChangesetId").getter(ChangesetSummary.getter(ChangesetSummary::updatesChangesetId)).setter(ChangesetSummary.setter(Builder::updatesChangesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatesChangesetId").build()}).build();
    private static final SdkField<String> UPDATED_BY_CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedByChangesetId").getter(ChangesetSummary.getter(ChangesetSummary::updatedByChangesetId)).setter(ChangesetSummary.setter(Builder::updatedByChangesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedByChangesetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGESET_ID_FIELD, CHANGESET_ARN_FIELD, DATASET_ID_FIELD, CHANGE_TYPE_FIELD, SOURCE_PARAMS_FIELD, FORMAT_PARAMS_FIELD, CREATE_TIME_FIELD, STATUS_FIELD, ERROR_INFO_FIELD, ACTIVE_UNTIL_TIMESTAMP_FIELD, ACTIVE_FROM_TIMESTAMP_FIELD, UPDATES_CHANGESET_ID_FIELD, UPDATED_BY_CHANGESET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangesetSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String changesetId;
    private final String changesetArn;
    private final String datasetId;
    private final String changeType;
    private final Map<String, String> sourceParams;
    private final Map<String, String> formatParams;
    private final Long createTime;
    private final String status;
    private final ChangesetErrorInfo errorInfo;
    private final Long activeUntilTimestamp;
    private final Long activeFromTimestamp;
    private final String updatesChangesetId;
    private final String updatedByChangesetId;

    private ChangesetSummary(BuilderImpl builder) {
        this.changesetId = builder.changesetId;
        this.changesetArn = builder.changesetArn;
        this.datasetId = builder.datasetId;
        this.changeType = builder.changeType;
        this.sourceParams = builder.sourceParams;
        this.formatParams = builder.formatParams;
        this.createTime = builder.createTime;
        this.status = builder.status;
        this.errorInfo = builder.errorInfo;
        this.activeUntilTimestamp = builder.activeUntilTimestamp;
        this.activeFromTimestamp = builder.activeFromTimestamp;
        this.updatesChangesetId = builder.updatesChangesetId;
        this.updatedByChangesetId = builder.updatedByChangesetId;
    }

    public final String changesetId() {
        return this.changesetId;
    }

    public final String changesetArn() {
        return this.changesetArn;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final ChangeType changeType() {
        return ChangeType.fromValue(this.changeType);
    }

    public final String changeTypeAsString() {
        return this.changeType;
    }

    public final boolean hasSourceParams() {
        return this.sourceParams != null && !(this.sourceParams instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sourceParams() {
        return this.sourceParams;
    }

    public final boolean hasFormatParams() {
        return this.formatParams != null && !(this.formatParams instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> formatParams() {
        return this.formatParams;
    }

    public final Long createTime() {
        return this.createTime;
    }

    public final IngestionStatus status() {
        return IngestionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ChangesetErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public final Long activeUntilTimestamp() {
        return this.activeUntilTimestamp;
    }

    public final Long activeFromTimestamp() {
        return this.activeFromTimestamp;
    }

    public final String updatesChangesetId() {
        return this.updatesChangesetId;
    }

    public final String updatedByChangesetId() {
        return this.updatedByChangesetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changesetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceParams() ? this.sourceParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormatParams() ? this.formatParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeUntilTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeFromTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatesChangesetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedByChangesetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangesetSummary)) {
            return false;
        }
        ChangesetSummary other = (ChangesetSummary)obj;
        return Objects.equals(this.changesetId(), other.changesetId()) && Objects.equals(this.changesetArn(), other.changesetArn()) && Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.changeTypeAsString(), other.changeTypeAsString()) && this.hasSourceParams() == other.hasSourceParams() && Objects.equals(this.sourceParams(), other.sourceParams()) && this.hasFormatParams() == other.hasFormatParams() && Objects.equals(this.formatParams(), other.formatParams()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.activeUntilTimestamp(), other.activeUntilTimestamp()) && Objects.equals(this.activeFromTimestamp(), other.activeFromTimestamp()) && Objects.equals(this.updatesChangesetId(), other.updatesChangesetId()) && Objects.equals(this.updatedByChangesetId(), other.updatedByChangesetId());
    }

    public final String toString() {
        return ToString.builder((String)"ChangesetSummary").add("ChangesetId", (Object)this.changesetId()).add("ChangesetArn", (Object)this.changesetArn()).add("DatasetId", (Object)this.datasetId()).add("ChangeType", (Object)this.changeTypeAsString()).add("SourceParams", this.hasSourceParams() ? this.sourceParams() : null).add("FormatParams", this.hasFormatParams() ? this.formatParams() : null).add("CreateTime", (Object)this.createTime()).add("Status", (Object)this.statusAsString()).add("ErrorInfo", (Object)this.errorInfo()).add("ActiveUntilTimestamp", (Object)this.activeUntilTimestamp()).add("ActiveFromTimestamp", (Object)this.activeFromTimestamp()).add("UpdatesChangesetId", (Object)this.updatesChangesetId()).add("UpdatedByChangesetId", (Object)this.updatedByChangesetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "changesetId": {
                return Optional.ofNullable(clazz.cast(this.changesetId()));
            }
            case "changesetArn": {
                return Optional.ofNullable(clazz.cast(this.changesetArn()));
            }
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "changeType": {
                return Optional.ofNullable(clazz.cast(this.changeTypeAsString()));
            }
            case "sourceParams": {
                return Optional.ofNullable(clazz.cast(this.sourceParams()));
            }
            case "formatParams": {
                return Optional.ofNullable(clazz.cast(this.formatParams()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "activeUntilTimestamp": {
                return Optional.ofNullable(clazz.cast(this.activeUntilTimestamp()));
            }
            case "activeFromTimestamp": {
                return Optional.ofNullable(clazz.cast(this.activeFromTimestamp()));
            }
            case "updatesChangesetId": {
                return Optional.ofNullable(clazz.cast(this.updatesChangesetId()));
            }
            case "updatedByChangesetId": {
                return Optional.ofNullable(clazz.cast(this.updatedByChangesetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("changesetId", CHANGESET_ID_FIELD);
        map.put("changesetArn", CHANGESET_ARN_FIELD);
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("changeType", CHANGE_TYPE_FIELD);
        map.put("sourceParams", SOURCE_PARAMS_FIELD);
        map.put("formatParams", FORMAT_PARAMS_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        map.put("activeUntilTimestamp", ACTIVE_UNTIL_TIMESTAMP_FIELD);
        map.put("activeFromTimestamp", ACTIVE_FROM_TIMESTAMP_FIELD);
        map.put("updatesChangesetId", UPDATES_CHANGESET_ID_FIELD);
        map.put("updatedByChangesetId", UPDATED_BY_CHANGESET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangesetSummary, T> g) {
        return obj -> g.apply((ChangesetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String changesetId;
        private String changesetArn;
        private String datasetId;
        private String changeType;
        private Map<String, String> sourceParams = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> formatParams = DefaultSdkAutoConstructMap.getInstance();
        private Long createTime;
        private String status;
        private ChangesetErrorInfo errorInfo;
        private Long activeUntilTimestamp;
        private Long activeFromTimestamp;
        private String updatesChangesetId;
        private String updatedByChangesetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangesetSummary model) {
            this.changesetId(model.changesetId);
            this.changesetArn(model.changesetArn);
            this.datasetId(model.datasetId);
            this.changeType(model.changeType);
            this.sourceParams(model.sourceParams);
            this.formatParams(model.formatParams);
            this.createTime(model.createTime);
            this.status(model.status);
            this.errorInfo(model.errorInfo);
            this.activeUntilTimestamp(model.activeUntilTimestamp);
            this.activeFromTimestamp(model.activeFromTimestamp);
            this.updatesChangesetId(model.updatesChangesetId);
            this.updatedByChangesetId(model.updatedByChangesetId);
        }

        public final String getChangesetId() {
            return this.changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final String getChangesetArn() {
            return this.changesetArn;
        }

        public final void setChangesetArn(String changesetArn) {
            this.changesetArn = changesetArn;
        }

        @Override
        public final Builder changesetArn(String changesetArn) {
            this.changesetArn = changesetArn;
            return this;
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getChangeType() {
            return this.changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public final Map<String, String> getSourceParams() {
            if (this.sourceParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sourceParams;
        }

        public final void setSourceParams(Map<String, String> sourceParams) {
            this.sourceParams = SourceParamsCopier.copy(sourceParams);
        }

        @Override
        public final Builder sourceParams(Map<String, String> sourceParams) {
            this.sourceParams = SourceParamsCopier.copy(sourceParams);
            return this;
        }

        public final Map<String, String> getFormatParams() {
            if (this.formatParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.formatParams;
        }

        public final void setFormatParams(Map<String, String> formatParams) {
            this.formatParams = FormatParamsCopier.copy(formatParams);
        }

        @Override
        public final Builder formatParams(Map<String, String> formatParams) {
            this.formatParams = FormatParamsCopier.copy(formatParams);
            return this;
        }

        public final Long getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngestionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ChangesetErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ChangesetErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(ChangesetErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final Long getActiveUntilTimestamp() {
            return this.activeUntilTimestamp;
        }

        public final void setActiveUntilTimestamp(Long activeUntilTimestamp) {
            this.activeUntilTimestamp = activeUntilTimestamp;
        }

        @Override
        public final Builder activeUntilTimestamp(Long activeUntilTimestamp) {
            this.activeUntilTimestamp = activeUntilTimestamp;
            return this;
        }

        public final Long getActiveFromTimestamp() {
            return this.activeFromTimestamp;
        }

        public final void setActiveFromTimestamp(Long activeFromTimestamp) {
            this.activeFromTimestamp = activeFromTimestamp;
        }

        @Override
        public final Builder activeFromTimestamp(Long activeFromTimestamp) {
            this.activeFromTimestamp = activeFromTimestamp;
            return this;
        }

        public final String getUpdatesChangesetId() {
            return this.updatesChangesetId;
        }

        public final void setUpdatesChangesetId(String updatesChangesetId) {
            this.updatesChangesetId = updatesChangesetId;
        }

        @Override
        public final Builder updatesChangesetId(String updatesChangesetId) {
            this.updatesChangesetId = updatesChangesetId;
            return this;
        }

        public final String getUpdatedByChangesetId() {
            return this.updatedByChangesetId;
        }

        public final void setUpdatedByChangesetId(String updatedByChangesetId) {
            this.updatedByChangesetId = updatedByChangesetId;
        }

        @Override
        public final Builder updatedByChangesetId(String updatedByChangesetId) {
            this.updatedByChangesetId = updatedByChangesetId;
            return this;
        }

        public ChangesetSummary build() {
            return new ChangesetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangesetSummary> {
        public Builder changesetId(String var1);

        public Builder changesetArn(String var1);

        public Builder datasetId(String var1);

        public Builder changeType(String var1);

        public Builder changeType(ChangeType var1);

        public Builder sourceParams(Map<String, String> var1);

        public Builder formatParams(Map<String, String> var1);

        public Builder createTime(Long var1);

        public Builder status(String var1);

        public Builder status(IngestionStatus var1);

        public Builder errorInfo(ChangesetErrorInfo var1);

        default public Builder errorInfo(Consumer<ChangesetErrorInfo.Builder> errorInfo) {
            return this.errorInfo((ChangesetErrorInfo)((ChangesetErrorInfo.Builder)ChangesetErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder activeUntilTimestamp(Long var1);

        public Builder activeFromTimestamp(Long var1);

        public Builder updatesChangesetId(String var1);

        public Builder updatedByChangesetId(String var1);
    }
}

