/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.DataViewListCopier;
import software.amazon.awssdk.services.finspacedata.model.DataViewSummary;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataViewsResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, ListDataViewsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataViewsResponse.getter(ListDataViewsResponse::nextToken)).setter(ListDataViewsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<DataViewSummary>> DATA_VIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataViews").getter(ListDataViewsResponse.getter(ListDataViewsResponse::dataViews)).setter(ListDataViewsResponse.setter(Builder::dataViews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataViews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataViewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DATA_VIEWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataViewsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<DataViewSummary> dataViews;

    private ListDataViewsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.dataViews = builder.dataViews;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDataViews() {
        return this.dataViews != null && !(this.dataViews instanceof SdkAutoConstructList);
    }

    public final List<DataViewSummary> dataViews() {
        return this.dataViews;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataViews() ? this.dataViews() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataViewsResponse)) {
            return false;
        }
        ListDataViewsResponse other = (ListDataViewsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDataViews() == other.hasDataViews() && Objects.equals(this.dataViews(), other.dataViews());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataViewsResponse").add("NextToken", (Object)this.nextToken()).add("DataViews", this.hasDataViews() ? this.dataViews() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "dataViews": {
                return Optional.ofNullable(clazz.cast(this.dataViews()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("dataViews", DATA_VIEWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataViewsResponse, T> g) {
        return obj -> g.apply((ListDataViewsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DataViewSummary> dataViews = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataViewsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.dataViews(model.dataViews);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DataViewSummary.Builder> getDataViews() {
            List<DataViewSummary.Builder> result = DataViewListCopier.copyToBuilder(this.dataViews);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataViews(Collection<DataViewSummary.BuilderImpl> dataViews) {
            this.dataViews = DataViewListCopier.copyFromBuilder(dataViews);
        }

        @Override
        public final Builder dataViews(Collection<DataViewSummary> dataViews) {
            this.dataViews = DataViewListCopier.copy(dataViews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataViews(DataViewSummary ... dataViews) {
            this.dataViews(Arrays.asList(dataViews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataViews(Consumer<DataViewSummary.Builder> ... dataViews) {
            this.dataViews(Stream.of(dataViews).map(c -> (DataViewSummary)((DataViewSummary.Builder)DataViewSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDataViewsResponse build() {
            return new ListDataViewsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataViewsResponse> {
        public Builder nextToken(String var1);

        public Builder dataViews(Collection<DataViewSummary> var1);

        public Builder dataViews(DataViewSummary ... var1);

        public Builder dataViews(Consumer<DataViewSummary.Builder> ... var1);
    }
}

