/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.ApiAccess;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataRequest;
import software.amazon.awssdk.services.finspacedata.model.UserType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUserRequest
extends FinspaceDataRequest
implements ToCopyableBuilder<Builder, CreateUserRequest> {
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("emailAddress").getter(CreateUserRequest.getter(CreateUserRequest::emailAddress)).setter(CreateUserRequest.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateUserRequest.getter(CreateUserRequest::typeAsString)).setter(CreateUserRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firstName").getter(CreateUserRequest.getter(CreateUserRequest::firstName)).setter(CreateUserRequest.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastName").getter(CreateUserRequest.getter(CreateUserRequest::lastName)).setter(CreateUserRequest.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastName").build()}).build();
    private static final SdkField<String> API_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiAccess").getter(CreateUserRequest.getter(CreateUserRequest::apiAccessAsString)).setter(CreateUserRequest.setter(Builder::apiAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccess").build()}).build();
    private static final SdkField<String> API_ACCESS_PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiAccessPrincipalArn").getter(CreateUserRequest.getter(CreateUserRequest::apiAccessPrincipalArn)).setter(CreateUserRequest.setter(Builder::apiAccessPrincipalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccessPrincipalArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateUserRequest.getter(CreateUserRequest::clientToken)).setter(CreateUserRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_FIELD, TYPE_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, API_ACCESS_FIELD, API_ACCESS_PRINCIPAL_ARN_FIELD, CLIENT_TOKEN_FIELD));
    private final String emailAddress;
    private final String type;
    private final String firstName;
    private final String lastName;
    private final String apiAccess;
    private final String apiAccessPrincipalArn;
    private final String clientToken;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.emailAddress = builder.emailAddress;
        this.type = builder.type;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.apiAccess = builder.apiAccess;
        this.apiAccessPrincipalArn = builder.apiAccessPrincipalArn;
        this.clientToken = builder.clientToken;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final UserType type() {
        return UserType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final ApiAccess apiAccess() {
        return ApiAccess.fromValue(this.apiAccess);
    }

    public final String apiAccessAsString() {
        return this.apiAccess;
    }

    public final String apiAccessPrincipalArn() {
        return this.apiAccessPrincipalArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiAccessPrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)((Object)obj);
        return Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.apiAccessAsString(), other.apiAccessAsString()) && Objects.equals(this.apiAccessPrincipalArn(), other.apiAccessPrincipalArn()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUserRequest").add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("ApiAccess", (Object)this.apiAccessAsString()).add("ApiAccessPrincipalArn", (Object)this.apiAccessPrincipalArn()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "emailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "firstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "lastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "apiAccess": {
                return Optional.ofNullable(clazz.cast(this.apiAccessAsString()));
            }
            case "apiAccessPrincipalArn": {
                return Optional.ofNullable(clazz.cast(this.apiAccessPrincipalArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataRequest.BuilderImpl
    implements Builder {
        private String emailAddress;
        private String type;
        private String firstName;
        private String lastName;
        private String apiAccess;
        private String apiAccessPrincipalArn;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            this.emailAddress(model.emailAddress);
            this.type(model.type);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.apiAccess(model.apiAccess);
            this.apiAccessPrincipalArn(model.apiAccessPrincipalArn);
            this.clientToken(model.clientToken);
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getApiAccess() {
            return this.apiAccess;
        }

        public final void setApiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
        }

        @Override
        public final Builder apiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
            return this;
        }

        @Override
        public final Builder apiAccess(ApiAccess apiAccess) {
            this.apiAccess(apiAccess == null ? null : apiAccess.toString());
            return this;
        }

        public final String getApiAccessPrincipalArn() {
            return this.apiAccessPrincipalArn;
        }

        public final void setApiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
        }

        @Override
        public final Builder apiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUserRequest> {
        public Builder emailAddress(String var1);

        public Builder type(String var1);

        public Builder type(UserType var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder apiAccess(String var1);

        public Builder apiAccess(ApiAccess var1);

        public Builder apiAccessPrincipalArn(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

