/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.DataViewDestinationTypeParams;
import software.amazon.awssdk.services.finspacedata.model.DataViewErrorInfo;
import software.amazon.awssdk.services.finspacedata.model.DataViewStatus;
import software.amazon.awssdk.services.finspacedata.model.PartitionColumnListCopier;
import software.amazon.awssdk.services.finspacedata.model.SortColumnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataViewSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataViewSummary> {
    private static final SdkField<String> DATA_VIEW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataViewId").getter(DataViewSummary.getter(DataViewSummary::dataViewId)).setter(DataViewSummary.setter(Builder::dataViewId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataViewId").build()}).build();
    private static final SdkField<String> DATA_VIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataViewArn").getter(DataViewSummary.getter(DataViewSummary::dataViewArn)).setter(DataViewSummary.setter(Builder::dataViewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataViewArn").build()}).build();
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(DataViewSummary.getter(DataViewSummary::datasetId)).setter(DataViewSummary.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()}).build();
    private static final SdkField<Long> AS_OF_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("asOfTimestamp").getter(DataViewSummary.getter(DataViewSummary::asOfTimestamp)).setter(DataViewSummary.setter(Builder::asOfTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asOfTimestamp").build()}).build();
    private static final SdkField<List<String>> PARTITION_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("partitionColumns").getter(DataViewSummary.getter(DataViewSummary::partitionColumns)).setter(DataViewSummary.setter(Builder::partitionColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SORT_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sortColumns").getter(DataViewSummary.getter(DataViewSummary::sortColumns)).setter(DataViewSummary.setter(Builder::sortColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DataViewSummary.getter(DataViewSummary::statusAsString)).setter(DataViewSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<DataViewErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorInfo").getter(DataViewSummary.getter(DataViewSummary::errorInfo)).setter(DataViewSummary.setter(Builder::errorInfo)).constructor(DataViewErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final SdkField<DataViewDestinationTypeParams> DESTINATION_TYPE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationTypeProperties").getter(DataViewSummary.getter(DataViewSummary::destinationTypeProperties)).setter(DataViewSummary.setter(Builder::destinationTypeProperties)).constructor(DataViewDestinationTypeParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationTypeProperties").build()}).build();
    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoUpdate").getter(DataViewSummary.getter(DataViewSummary::autoUpdate)).setter(DataViewSummary.setter(Builder::autoUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoUpdate").build()}).build();
    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createTime").getter(DataViewSummary.getter(DataViewSummary::createTime)).setter(DataViewSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedTime").getter(DataViewSummary.getter(DataViewSummary::lastModifiedTime)).setter(DataViewSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_VIEW_ID_FIELD, DATA_VIEW_ARN_FIELD, DATASET_ID_FIELD, AS_OF_TIMESTAMP_FIELD, PARTITION_COLUMNS_FIELD, SORT_COLUMNS_FIELD, STATUS_FIELD, ERROR_INFO_FIELD, DESTINATION_TYPE_PROPERTIES_FIELD, AUTO_UPDATE_FIELD, CREATE_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataViewId;
    private final String dataViewArn;
    private final String datasetId;
    private final Long asOfTimestamp;
    private final List<String> partitionColumns;
    private final List<String> sortColumns;
    private final String status;
    private final DataViewErrorInfo errorInfo;
    private final DataViewDestinationTypeParams destinationTypeProperties;
    private final Boolean autoUpdate;
    private final Long createTime;
    private final Long lastModifiedTime;

    private DataViewSummary(BuilderImpl builder) {
        this.dataViewId = builder.dataViewId;
        this.dataViewArn = builder.dataViewArn;
        this.datasetId = builder.datasetId;
        this.asOfTimestamp = builder.asOfTimestamp;
        this.partitionColumns = builder.partitionColumns;
        this.sortColumns = builder.sortColumns;
        this.status = builder.status;
        this.errorInfo = builder.errorInfo;
        this.destinationTypeProperties = builder.destinationTypeProperties;
        this.autoUpdate = builder.autoUpdate;
        this.createTime = builder.createTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String dataViewId() {
        return this.dataViewId;
    }

    public final String dataViewArn() {
        return this.dataViewArn;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final Long asOfTimestamp() {
        return this.asOfTimestamp;
    }

    public final boolean hasPartitionColumns() {
        return this.partitionColumns != null && !(this.partitionColumns instanceof SdkAutoConstructList);
    }

    public final List<String> partitionColumns() {
        return this.partitionColumns;
    }

    public final boolean hasSortColumns() {
        return this.sortColumns != null && !(this.sortColumns instanceof SdkAutoConstructList);
    }

    public final List<String> sortColumns() {
        return this.sortColumns;
    }

    public final DataViewStatus status() {
        return DataViewStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final DataViewErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public final DataViewDestinationTypeParams destinationTypeProperties() {
        return this.destinationTypeProperties;
    }

    public final Boolean autoUpdate() {
        return this.autoUpdate;
    }

    public final Long createTime() {
        return this.createTime;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataViewId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.asOfTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionColumns() ? this.partitionColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortColumns() ? this.sortColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataViewSummary)) {
            return false;
        }
        DataViewSummary other = (DataViewSummary)obj;
        return Objects.equals(this.dataViewId(), other.dataViewId()) && Objects.equals(this.dataViewArn(), other.dataViewArn()) && Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.asOfTimestamp(), other.asOfTimestamp()) && this.hasPartitionColumns() == other.hasPartitionColumns() && Objects.equals(this.partitionColumns(), other.partitionColumns()) && this.hasSortColumns() == other.hasSortColumns() && Objects.equals(this.sortColumns(), other.sortColumns()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.destinationTypeProperties(), other.destinationTypeProperties()) && Objects.equals(this.autoUpdate(), other.autoUpdate()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"DataViewSummary").add("DataViewId", (Object)this.dataViewId()).add("DataViewArn", (Object)this.dataViewArn()).add("DatasetId", (Object)this.datasetId()).add("AsOfTimestamp", (Object)this.asOfTimestamp()).add("PartitionColumns", this.hasPartitionColumns() ? this.partitionColumns() : null).add("SortColumns", this.hasSortColumns() ? this.sortColumns() : null).add("Status", (Object)this.statusAsString()).add("ErrorInfo", (Object)this.errorInfo()).add("DestinationTypeProperties", (Object)this.destinationTypeProperties()).add("AutoUpdate", (Object)this.autoUpdate()).add("CreateTime", (Object)this.createTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataViewId": {
                return Optional.ofNullable(clazz.cast(this.dataViewId()));
            }
            case "dataViewArn": {
                return Optional.ofNullable(clazz.cast(this.dataViewArn()));
            }
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "asOfTimestamp": {
                return Optional.ofNullable(clazz.cast(this.asOfTimestamp()));
            }
            case "partitionColumns": {
                return Optional.ofNullable(clazz.cast(this.partitionColumns()));
            }
            case "sortColumns": {
                return Optional.ofNullable(clazz.cast(this.sortColumns()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "destinationTypeProperties": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeProperties()));
            }
            case "autoUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdate()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataViewSummary, T> g) {
        return obj -> g.apply((DataViewSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataViewId;
        private String dataViewArn;
        private String datasetId;
        private Long asOfTimestamp;
        private List<String> partitionColumns = DefaultSdkAutoConstructList.getInstance();
        private List<String> sortColumns = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private DataViewErrorInfo errorInfo;
        private DataViewDestinationTypeParams destinationTypeProperties;
        private Boolean autoUpdate;
        private Long createTime;
        private Long lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DataViewSummary model) {
            this.dataViewId(model.dataViewId);
            this.dataViewArn(model.dataViewArn);
            this.datasetId(model.datasetId);
            this.asOfTimestamp(model.asOfTimestamp);
            this.partitionColumns(model.partitionColumns);
            this.sortColumns(model.sortColumns);
            this.status(model.status);
            this.errorInfo(model.errorInfo);
            this.destinationTypeProperties(model.destinationTypeProperties);
            this.autoUpdate(model.autoUpdate);
            this.createTime(model.createTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getDataViewId() {
            return this.dataViewId;
        }

        public final void setDataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
        }

        @Override
        public final Builder dataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
            return this;
        }

        public final String getDataViewArn() {
            return this.dataViewArn;
        }

        public final void setDataViewArn(String dataViewArn) {
            this.dataViewArn = dataViewArn;
        }

        @Override
        public final Builder dataViewArn(String dataViewArn) {
            this.dataViewArn = dataViewArn;
            return this;
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final Long getAsOfTimestamp() {
            return this.asOfTimestamp;
        }

        public final void setAsOfTimestamp(Long asOfTimestamp) {
            this.asOfTimestamp = asOfTimestamp;
        }

        @Override
        public final Builder asOfTimestamp(Long asOfTimestamp) {
            this.asOfTimestamp = asOfTimestamp;
            return this;
        }

        public final Collection<String> getPartitionColumns() {
            if (this.partitionColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionColumns;
        }

        public final void setPartitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = PartitionColumnListCopier.copy(partitionColumns);
        }

        @Override
        public final Builder partitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = PartitionColumnListCopier.copy(partitionColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionColumns(String ... partitionColumns) {
            this.partitionColumns(Arrays.asList(partitionColumns));
            return this;
        }

        public final Collection<String> getSortColumns() {
            if (this.sortColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sortColumns;
        }

        public final void setSortColumns(Collection<String> sortColumns) {
            this.sortColumns = SortColumnListCopier.copy(sortColumns);
        }

        @Override
        public final Builder sortColumns(Collection<String> sortColumns) {
            this.sortColumns = SortColumnListCopier.copy(sortColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortColumns(String ... sortColumns) {
            this.sortColumns(Arrays.asList(sortColumns));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataViewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DataViewErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(DataViewErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(DataViewErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final DataViewDestinationTypeParams.Builder getDestinationTypeProperties() {
            return this.destinationTypeProperties != null ? this.destinationTypeProperties.toBuilder() : null;
        }

        public final void setDestinationTypeProperties(DataViewDestinationTypeParams.BuilderImpl destinationTypeProperties) {
            this.destinationTypeProperties = destinationTypeProperties != null ? destinationTypeProperties.build() : null;
        }

        @Override
        public final Builder destinationTypeProperties(DataViewDestinationTypeParams destinationTypeProperties) {
            this.destinationTypeProperties = destinationTypeProperties;
            return this;
        }

        public final Boolean getAutoUpdate() {
            return this.autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final Long getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public DataViewSummary build() {
            return new DataViewSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataViewSummary> {
        public Builder dataViewId(String var1);

        public Builder dataViewArn(String var1);

        public Builder datasetId(String var1);

        public Builder asOfTimestamp(Long var1);

        public Builder partitionColumns(Collection<String> var1);

        public Builder partitionColumns(String ... var1);

        public Builder sortColumns(Collection<String> var1);

        public Builder sortColumns(String ... var1);

        public Builder status(String var1);

        public Builder status(DataViewStatus var1);

        public Builder errorInfo(DataViewErrorInfo var1);

        default public Builder errorInfo(Consumer<DataViewErrorInfo.Builder> errorInfo) {
            return this.errorInfo((DataViewErrorInfo)((DataViewErrorInfo.Builder)DataViewErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder destinationTypeProperties(DataViewDestinationTypeParams var1);

        default public Builder destinationTypeProperties(Consumer<DataViewDestinationTypeParams.Builder> destinationTypeProperties) {
            return this.destinationTypeProperties((DataViewDestinationTypeParams)((DataViewDestinationTypeParams.Builder)DataViewDestinationTypeParams.builder().applyMutation(destinationTypeProperties)).build());
        }

        public Builder autoUpdate(Boolean var1);

        public Builder createTime(Long var1);

        public Builder lastModifiedTime(Long var1);
    }
}

