/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataViewResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, CreateDataViewResponse> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(CreateDataViewResponse.getter(CreateDataViewResponse::datasetId)).setter(CreateDataViewResponse.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()}).build();
    private static final SdkField<String> DATA_VIEW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataViewId").getter(CreateDataViewResponse.getter(CreateDataViewResponse::dataViewId)).setter(CreateDataViewResponse.setter(Builder::dataViewId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataViewId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD, DATA_VIEW_ID_FIELD));
    private final String datasetId;
    private final String dataViewId;

    private CreateDataViewResponse(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.dataViewId = builder.dataViewId;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final String dataViewId() {
        return this.dataViewId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataViewId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataViewResponse)) {
            return false;
        }
        CreateDataViewResponse other = (CreateDataViewResponse)((Object)obj);
        return Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.dataViewId(), other.dataViewId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataViewResponse").add("DatasetId", (Object)this.datasetId()).add("DataViewId", (Object)this.dataViewId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "dataViewId": {
                return Optional.ofNullable(clazz.cast(this.dataViewId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataViewResponse, T> g) {
        return obj -> g.apply((CreateDataViewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private String datasetId;
        private String dataViewId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataViewResponse model) {
            super(model);
            this.datasetId(model.datasetId);
            this.dataViewId(model.dataViewId);
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDataViewId() {
            return this.dataViewId;
        }

        public final void setDataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
        }

        @Override
        public final Builder dataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
            return this;
        }

        @Override
        public CreateDataViewResponse build() {
            return new CreateDataViewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataViewResponse> {
        public Builder datasetId(String var1);

        public Builder dataViewId(String var1);
    }
}

