/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportFileFormat {
    PARQUET("PARQUET"),
    DELIMITED_TEXT("DELIMITED_TEXT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportFileFormat> VALUE_MAP;
    private final String value;

    private ExportFileFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportFileFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportFileFormat> knownValues() {
        EnumSet<ExportFileFormat> knownValues = EnumSet.allOf(ExportFileFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportFileFormat.class, ExportFileFormat::toString);
    }
}

