/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.services.finspacedata.model.PermissionGroupByUser;
import software.amazon.awssdk.services.finspacedata.model.PermissionGroupByUserListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPermissionGroupsByUserResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, ListPermissionGroupsByUserResponse> {
    private static final SdkField<List<PermissionGroupByUser>> PERMISSION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("permissionGroups").getter(ListPermissionGroupsByUserResponse.getter(ListPermissionGroupsByUserResponse::permissionGroups)).setter(ListPermissionGroupsByUserResponse.setter(Builder::permissionGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PermissionGroupByUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPermissionGroupsByUserResponse.getter(ListPermissionGroupsByUserResponse::nextToken)).setter(ListPermissionGroupsByUserResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PermissionGroupByUser> permissionGroups;
    private final String nextToken;

    private ListPermissionGroupsByUserResponse(BuilderImpl builder) {
        super(builder);
        this.permissionGroups = builder.permissionGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPermissionGroups() {
        return this.permissionGroups != null && !(this.permissionGroups instanceof SdkAutoConstructList);
    }

    public final List<PermissionGroupByUser> permissionGroups() {
        return this.permissionGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissionGroups() ? this.permissionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionGroupsByUserResponse)) {
            return false;
        }
        ListPermissionGroupsByUserResponse other = (ListPermissionGroupsByUserResponse)((Object)obj);
        return this.hasPermissionGroups() == other.hasPermissionGroups() && Objects.equals(this.permissionGroups(), other.permissionGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPermissionGroupsByUserResponse").add("PermissionGroups", this.hasPermissionGroups() ? this.permissionGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "permissionGroups": {
                return Optional.ofNullable(clazz.cast(this.permissionGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionGroupsByUserResponse, T> g) {
        return obj -> g.apply((ListPermissionGroupsByUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private List<PermissionGroupByUser> permissionGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionGroupsByUserResponse model) {
            super(model);
            this.permissionGroups(model.permissionGroups);
            this.nextToken(model.nextToken);
        }

        public final List<PermissionGroupByUser.Builder> getPermissionGroups() {
            List<PermissionGroupByUser.Builder> result = PermissionGroupByUserListCopier.copyToBuilder(this.permissionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissionGroups(Collection<PermissionGroupByUser.BuilderImpl> permissionGroups) {
            this.permissionGroups = PermissionGroupByUserListCopier.copyFromBuilder(permissionGroups);
        }

        @Override
        public final Builder permissionGroups(Collection<PermissionGroupByUser> permissionGroups) {
            this.permissionGroups = PermissionGroupByUserListCopier.copy(permissionGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionGroups(PermissionGroupByUser ... permissionGroups) {
            this.permissionGroups(Arrays.asList(permissionGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionGroups(Consumer<PermissionGroupByUser.Builder> ... permissionGroups) {
            this.permissionGroups(Stream.of(permissionGroups).map(c -> (PermissionGroupByUser)((PermissionGroupByUser.Builder)PermissionGroupByUser.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPermissionGroupsByUserResponse build() {
            return new ListPermissionGroupsByUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPermissionGroupsByUserResponse> {
        public Builder permissionGroups(Collection<PermissionGroupByUser> var1);

        public Builder permissionGroups(PermissionGroupByUser ... var1);

        public Builder permissionGroups(Consumer<PermissionGroupByUser.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

