/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The request for an UpdateDataset operation
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDatasetRequest extends FinspaceDataRequest implements
        ToCopyableBuilder<UpdateDatasetRequest.Builder, UpdateDatasetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateDatasetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(UpdateDatasetRequest::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetId").build()).build();

    private static final SdkField<String> DATASET_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetTitle").getter(getter(UpdateDatasetRequest::datasetTitle)).setter(setter(Builder::datasetTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetTitle").build()).build();

    private static final SdkField<String> KIND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kind")
            .getter(getter(UpdateDatasetRequest::kindAsString)).setter(setter(Builder::kind))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()).build();

    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetDescription").getter(getter(UpdateDatasetRequest::datasetDescription))
            .setter(setter(Builder::datasetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetDescription").build())
            .build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(UpdateDatasetRequest::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<SchemaUnion> SCHEMA_DEFINITION_FIELD = SdkField.<SchemaUnion> builder(MarshallingType.SDK_POJO)
            .memberName("schemaDefinition").getter(getter(UpdateDatasetRequest::schemaDefinition))
            .setter(setter(Builder::schemaDefinition)).constructor(SchemaUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DATASET_ID_FIELD, DATASET_TITLE_FIELD, KIND_FIELD, DATASET_DESCRIPTION_FIELD, ALIAS_FIELD, SCHEMA_DEFINITION_FIELD));

    private final String clientToken;

    private final String datasetId;

    private final String datasetTitle;

    private final String kind;

    private final String datasetDescription;

    private final String alias;

    private final SchemaUnion schemaDefinition;

    private UpdateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.datasetId = builder.datasetId;
        this.datasetTitle = builder.datasetTitle;
        this.kind = builder.kind;
        this.datasetDescription = builder.datasetDescription;
        this.alias = builder.alias;
        this.schemaDefinition = builder.schemaDefinition;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier for the Dataset to update.
     * </p>
     * 
     * @return The unique identifier for the Dataset to update.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * A display title for the Dataset.
     * </p>
     * 
     * @return A display title for the Dataset.
     */
    public final String datasetTitle() {
        return datasetTitle;
    }

    /**
     * <p>
     * The format in which the Dataset data is structured.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TABULAR</code> – Data is structured in a tabular format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link DatasetKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The format in which the Dataset data is structured.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TABULAR</code> – Data is structured in a tabular format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     *         </p>
     *         </li>
     * @see DatasetKind
     */
    public final DatasetKind kind() {
        return DatasetKind.fromValue(kind);
    }

    /**
     * <p>
     * The format in which the Dataset data is structured.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TABULAR</code> – Data is structured in a tabular format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link DatasetKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The format in which the Dataset data is structured.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TABULAR</code> – Data is structured in a tabular format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     *         </p>
     *         </li>
     * @see DatasetKind
     */
    public final String kindAsString() {
        return kind;
    }

    /**
     * <p>
     * A description for the Dataset.
     * </p>
     * 
     * @return A description for the Dataset.
     */
    public final String datasetDescription() {
        return datasetDescription;
    }

    /**
     * <p>
     * The unique resource identifier for a Dataset.
     * </p>
     * 
     * @return The unique resource identifier for a Dataset.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * Definition for a schema on a tabular Dataset.
     * </p>
     * 
     * @return Definition for a schema on a tabular Dataset.
     */
    public final SchemaUnion schemaDefinition() {
        return schemaDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTitle());
        hashCode = 31 * hashCode + Objects.hashCode(kindAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(schemaDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetRequest)) {
            return false;
        }
        UpdateDatasetRequest other = (UpdateDatasetRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(datasetId(), other.datasetId())
                && Objects.equals(datasetTitle(), other.datasetTitle()) && Objects.equals(kindAsString(), other.kindAsString())
                && Objects.equals(datasetDescription(), other.datasetDescription()) && Objects.equals(alias(), other.alias())
                && Objects.equals(schemaDefinition(), other.schemaDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDatasetRequest").add("ClientToken", clientToken()).add("DatasetId", datasetId())
                .add("DatasetTitle", datasetTitle()).add("Kind", kindAsString()).add("DatasetDescription", datasetDescription())
                .add("Alias", alias()).add("SchemaDefinition", schemaDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "datasetTitle":
            return Optional.ofNullable(clazz.cast(datasetTitle()));
        case "kind":
            return Optional.ofNullable(clazz.cast(kindAsString()));
        case "datasetDescription":
            return Optional.ofNullable(clazz.cast(datasetDescription()));
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "schemaDefinition":
            return Optional.ofNullable(clazz.cast(schemaDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetRequest, T> g) {
        return obj -> g.apply((UpdateDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDatasetRequest> {
        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier for the Dataset to update.
         * </p>
         * 
         * @param datasetId
         *        The unique identifier for the Dataset to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * A display title for the Dataset.
         * </p>
         * 
         * @param datasetTitle
         *        A display title for the Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetTitle(String datasetTitle);

        /**
         * <p>
         * The format in which the Dataset data is structured.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TABULAR</code> – Data is structured in a tabular format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The format in which the Dataset data is structured.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TABULAR</code> – Data is structured in a tabular format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         *        </p>
         *        </li>
         * @see DatasetKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetKind
         */
        Builder kind(String kind);

        /**
         * <p>
         * The format in which the Dataset data is structured.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TABULAR</code> – Data is structured in a tabular format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The format in which the Dataset data is structured.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TABULAR</code> – Data is structured in a tabular format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         *        </p>
         *        </li>
         * @see DatasetKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetKind
         */
        Builder kind(DatasetKind kind);

        /**
         * <p>
         * A description for the Dataset.
         * </p>
         * 
         * @param datasetDescription
         *        A description for the Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetDescription(String datasetDescription);

        /**
         * <p>
         * The unique resource identifier for a Dataset.
         * </p>
         * 
         * @param alias
         *        The unique resource identifier for a Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * Definition for a schema on a tabular Dataset.
         * </p>
         * 
         * @param schemaDefinition
         *        Definition for a schema on a tabular Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaDefinition(SchemaUnion schemaDefinition);

        /**
         * <p>
         * Definition for a schema on a tabular Dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaUnion.Builder} avoiding the need to
         * create one manually via {@link SchemaUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaUnion.Builder#build()} is called immediately and its result
         * is passed to {@link #schemaDefinition(SchemaUnion)}.
         * 
         * @param schemaDefinition
         *        a consumer that will call methods on {@link SchemaUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaDefinition(SchemaUnion)
         */
        default Builder schemaDefinition(Consumer<SchemaUnion.Builder> schemaDefinition) {
            return schemaDefinition(SchemaUnion.builder().applyMutation(schemaDefinition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceDataRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String datasetId;

        private String datasetTitle;

        private String kind;

        private String datasetDescription;

        private String alias;

        private SchemaUnion schemaDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetRequest model) {
            super(model);
            clientToken(model.clientToken);
            datasetId(model.datasetId);
            datasetTitle(model.datasetTitle);
            kind(model.kind);
            datasetDescription(model.datasetDescription);
            alias(model.alias);
            schemaDefinition(model.schemaDefinition);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDatasetTitle() {
            return datasetTitle;
        }

        public final void setDatasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
        }

        @Override
        public final Builder datasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
            return this;
        }

        public final String getKind() {
            return kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public final Builder kind(DatasetKind kind) {
            this.kind(kind == null ? null : kind.toString());
            return this;
        }

        public final String getDatasetDescription() {
            return datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final SchemaUnion.Builder getSchemaDefinition() {
            return schemaDefinition != null ? schemaDefinition.toBuilder() : null;
        }

        public final void setSchemaDefinition(SchemaUnion.BuilderImpl schemaDefinition) {
            this.schemaDefinition = schemaDefinition != null ? schemaDefinition.build() : null;
        }

        @Override
        public final Builder schemaDefinition(SchemaUnion schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetRequest build() {
            return new UpdateDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
