/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Permission group parameters for Dataset permissions.
 * </p>
 * <p>
 * Here is an example of how you could specify the <code>PermissionGroupParams</code>:
 * </p>
 * <p>
 * <code> { "permissionGroupId": "0r6fCRtSTUk4XPfXQe3M0g", "datasetPermissions": [ {"permission": "ViewDatasetDetails"}, {"permission": "AddDatasetData"}, {"permission": "EditDatasetMetadata"}, {"permission": "DeleteDataset"} ] } </code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionGroupParams implements SdkPojo, Serializable,
        ToCopyableBuilder<PermissionGroupParams.Builder, PermissionGroupParams> {
    private static final SdkField<String> PERMISSION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permissionGroupId").getter(getter(PermissionGroupParams::permissionGroupId))
            .setter(setter(Builder::permissionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionGroupId").build()).build();

    private static final SdkField<List<ResourcePermission>> DATASET_PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("datasetPermissions")
            .getter(getter(PermissionGroupParams::datasetPermissions))
            .setter(setter(Builder::datasetPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_GROUP_ID_FIELD,
            DATASET_PERMISSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String permissionGroupId;

    private final List<ResourcePermission> datasetPermissions;

    private PermissionGroupParams(BuilderImpl builder) {
        this.permissionGroupId = builder.permissionGroupId;
        this.datasetPermissions = builder.datasetPermissions;
    }

    /**
     * <p>
     * The unique identifier for the <code>PermissionGroup</code>.
     * </p>
     * 
     * @return The unique identifier for the <code>PermissionGroup</code>.
     */
    public final String permissionGroupId() {
        return permissionGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatasetPermissions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatasetPermissions() {
        return datasetPermissions != null && !(datasetPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of resource permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasetPermissions} method.
     * </p>
     * 
     * @return List of resource permissions.
     */
    public final List<ResourcePermission> datasetPermissions() {
        return datasetPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(permissionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasetPermissions() ? datasetPermissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionGroupParams)) {
            return false;
        }
        PermissionGroupParams other = (PermissionGroupParams) obj;
        return Objects.equals(permissionGroupId(), other.permissionGroupId())
                && hasDatasetPermissions() == other.hasDatasetPermissions()
                && Objects.equals(datasetPermissions(), other.datasetPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PermissionGroupParams").add("PermissionGroupId", permissionGroupId())
                .add("DatasetPermissions", hasDatasetPermissions() ? datasetPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permissionGroupId":
            return Optional.ofNullable(clazz.cast(permissionGroupId()));
        case "datasetPermissions":
            return Optional.ofNullable(clazz.cast(datasetPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PermissionGroupParams, T> g) {
        return obj -> g.apply((PermissionGroupParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionGroupParams> {
        /**
         * <p>
         * The unique identifier for the <code>PermissionGroup</code>.
         * </p>
         * 
         * @param permissionGroupId
         *        The unique identifier for the <code>PermissionGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionGroupId(String permissionGroupId);

        /**
         * <p>
         * List of resource permissions.
         * </p>
         * 
         * @param datasetPermissions
         *        List of resource permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetPermissions(Collection<ResourcePermission> datasetPermissions);

        /**
         * <p>
         * List of resource permissions.
         * </p>
         * 
         * @param datasetPermissions
         *        List of resource permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetPermissions(ResourcePermission... datasetPermissions);

        /**
         * <p>
         * List of resource permissions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspacedata.model.ResourcePermission.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.finspacedata.model.ResourcePermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspacedata.model.ResourcePermission.Builder#build()} is called
         * immediately and its result is passed to {@link #datasetPermissions(List<ResourcePermission>)}.
         * 
         * @param datasetPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspacedata.model.ResourcePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetPermissions(java.util.Collection<ResourcePermission>)
         */
        Builder datasetPermissions(Consumer<ResourcePermission.Builder>... datasetPermissions);
    }

    static final class BuilderImpl implements Builder {
        private String permissionGroupId;

        private List<ResourcePermission> datasetPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionGroupParams model) {
            permissionGroupId(model.permissionGroupId);
            datasetPermissions(model.datasetPermissions);
        }

        public final String getPermissionGroupId() {
            return permissionGroupId;
        }

        public final void setPermissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
        }

        @Override
        public final Builder permissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
            return this;
        }

        public final List<ResourcePermission.Builder> getDatasetPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionsListCopier.copyToBuilder(this.datasetPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetPermissions(Collection<ResourcePermission.BuilderImpl> datasetPermissions) {
            this.datasetPermissions = ResourcePermissionsListCopier.copyFromBuilder(datasetPermissions);
        }

        @Override
        public final Builder datasetPermissions(Collection<ResourcePermission> datasetPermissions) {
            this.datasetPermissions = ResourcePermissionsListCopier.copy(datasetPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetPermissions(ResourcePermission... datasetPermissions) {
            datasetPermissions(Arrays.asList(datasetPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetPermissions(Consumer<ResourcePermission.Builder>... datasetPermissions) {
            datasetPermissions(Stream.of(datasetPermissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PermissionGroupParams build() {
            return new PermissionGroupParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
