/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response to ListChangesetsResponse. This returns a list of dataset changesets that match the query criteria.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChangesetsResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<ListChangesetsResponse.Builder, ListChangesetsResponse> {
    private static final SdkField<List<ChangesetSummary>> CHANGESETS_FIELD = SdkField
            .<List<ChangesetSummary>> builder(MarshallingType.LIST)
            .memberName("changesets")
            .getter(getter(ListChangesetsResponse::changesets))
            .setter(setter(Builder::changesets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangesetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangesetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListChangesetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGESETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ChangesetSummary> changesets;

    private final String nextToken;

    private ListChangesetsResponse(BuilderImpl builder) {
        super(builder);
        this.changesets = builder.changesets;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Changesets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChangesets() {
        return changesets != null && !(changesets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Changesets found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChangesets} method.
     * </p>
     * 
     * @return List of Changesets found.
     */
    public final List<ChangesetSummary> changesets() {
        return changesets;
    }

    /**
     * <p>
     * A token that indicates where a results page should begin.
     * </p>
     * 
     * @return A token that indicates where a results page should begin.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChangesets() ? changesets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangesetsResponse)) {
            return false;
        }
        ListChangesetsResponse other = (ListChangesetsResponse) obj;
        return hasChangesets() == other.hasChangesets() && Objects.equals(changesets(), other.changesets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChangesetsResponse").add("Changesets", hasChangesets() ? changesets() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "changesets":
            return Optional.ofNullable(clazz.cast(changesets()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChangesetsResponse, T> g) {
        return obj -> g.apply((ListChangesetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListChangesetsResponse> {
        /**
         * <p>
         * List of Changesets found.
         * </p>
         * 
         * @param changesets
         *        List of Changesets found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesets(Collection<ChangesetSummary> changesets);

        /**
         * <p>
         * List of Changesets found.
         * </p>
         * 
         * @param changesets
         *        List of Changesets found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesets(ChangesetSummary... changesets);

        /**
         * <p>
         * List of Changesets found.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspacedata.model.ChangesetSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.finspacedata.model.ChangesetSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspacedata.model.ChangesetSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #changesets(List<ChangesetSummary>)}.
         * 
         * @param changesets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspacedata.model.ChangesetSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changesets(java.util.Collection<ChangesetSummary>)
         */
        Builder changesets(Consumer<ChangesetSummary.Builder>... changesets);

        /**
         * <p>
         * A token that indicates where a results page should begin.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where a results page should begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private List<ChangesetSummary> changesets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChangesetsResponse model) {
            super(model);
            changesets(model.changesets);
            nextToken(model.nextToken);
        }

        public final List<ChangesetSummary.Builder> getChangesets() {
            List<ChangesetSummary.Builder> result = ChangesetListCopier.copyToBuilder(this.changesets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangesets(Collection<ChangesetSummary.BuilderImpl> changesets) {
            this.changesets = ChangesetListCopier.copyFromBuilder(changesets);
        }

        @Override
        public final Builder changesets(Collection<ChangesetSummary> changesets) {
            this.changesets = ChangesetListCopier.copy(changesets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changesets(ChangesetSummary... changesets) {
            changesets(Arrays.asList(changesets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changesets(Consumer<ChangesetSummary.Builder>... changesets) {
            changesets(Stream.of(changesets).map(c -> ChangesetSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChangesetsResponse build() {
            return new ListChangesetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
