/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.ChangesetListCopier;
import software.amazon.awssdk.services.finspacedata.model.ChangesetSummary;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChangesetsResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, ListChangesetsResponse> {
    private static final SdkField<List<ChangesetSummary>> CHANGESETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("changesets").getter(ListChangesetsResponse.getter(ListChangesetsResponse::changesets)).setter(ListChangesetsResponse.setter(Builder::changesets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangesetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListChangesetsResponse.getter(ListChangesetsResponse::nextToken)).setter(ListChangesetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGESETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ChangesetSummary> changesets;
    private final String nextToken;

    private ListChangesetsResponse(BuilderImpl builder) {
        super(builder);
        this.changesets = builder.changesets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasChangesets() {
        return this.changesets != null && !(this.changesets instanceof SdkAutoConstructList);
    }

    public final List<ChangesetSummary> changesets() {
        return this.changesets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangesets() ? this.changesets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangesetsResponse)) {
            return false;
        }
        ListChangesetsResponse other = (ListChangesetsResponse)((Object)obj);
        return this.hasChangesets() == other.hasChangesets() && Objects.equals(this.changesets(), other.changesets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChangesetsResponse").add("Changesets", this.hasChangesets() ? this.changesets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "changesets": {
                return Optional.ofNullable(clazz.cast(this.changesets()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChangesetsResponse, T> g) {
        return obj -> g.apply((ListChangesetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private List<ChangesetSummary> changesets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChangesetsResponse model) {
            super(model);
            this.changesets(model.changesets);
            this.nextToken(model.nextToken);
        }

        public final List<ChangesetSummary.Builder> getChangesets() {
            List<ChangesetSummary.Builder> result = ChangesetListCopier.copyToBuilder(this.changesets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangesets(Collection<ChangesetSummary.BuilderImpl> changesets) {
            this.changesets = ChangesetListCopier.copyFromBuilder(changesets);
        }

        @Override
        @Transient
        public final Builder changesets(Collection<ChangesetSummary> changesets) {
            this.changesets = ChangesetListCopier.copy(changesets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder changesets(ChangesetSummary ... changesets) {
            this.changesets(Arrays.asList(changesets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder changesets(Consumer<ChangesetSummary.Builder> ... changesets) {
            this.changesets(Stream.of(changesets).map(c -> (ChangesetSummary)((ChangesetSummary.Builder)ChangesetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChangesetsResponse build() {
            return new ListChangesetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChangesetsResponse> {
        public Builder changesets(Collection<ChangesetSummary> var1);

        public Builder changesets(ChangesetSummary ... var1);

        public Builder changesets(Consumer<ChangesetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

