/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FormatType {
    CSV("CSV"),
    JSON("JSON"),
    PARQUET("PARQUET"),
    XML("XML"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FormatType> VALUE_MAP;
    private final String value;

    private FormatType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FormatType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FormatType> knownValues() {
        EnumSet<FormatType> knownValues = EnumSet.allOf(FormatType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FormatType.class, FormatType::toString);
    }
}

