/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.finspacedata.DefaultFinspaceDataClientBuilder;
import software.amazon.awssdk.services.finspacedata.FinspaceDataClientBuilder;
import software.amazon.awssdk.services.finspacedata.model.AccessDeniedException;
import software.amazon.awssdk.services.finspacedata.model.CreateChangesetRequest;
import software.amazon.awssdk.services.finspacedata.model.CreateChangesetResponse;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataException;
import software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest;
import software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsResponse;
import software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationRequest;
import software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationResponse;
import software.amazon.awssdk.services.finspacedata.model.InternalServerException;
import software.amazon.awssdk.services.finspacedata.model.ResourceNotFoundException;
import software.amazon.awssdk.services.finspacedata.model.ThrottlingException;
import software.amazon.awssdk.services.finspacedata.model.ValidationException;

@SdkPublicApi
@ThreadSafe
public interface FinspaceDataClient
extends SdkClient {
    public static final String SERVICE_NAME = "finspace-api";
    public static final String SERVICE_METADATA_ID = "finspace-api";

    public static FinspaceDataClient create() {
        return (FinspaceDataClient)FinspaceDataClient.builder().build();
    }

    public static FinspaceDataClientBuilder builder() {
        return new DefaultFinspaceDataClientBuilder();
    }

    default public CreateChangesetResponse createChangeset(CreateChangesetRequest createChangesetRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public CreateChangesetResponse createChangeset(Consumer<CreateChangesetRequest.Builder> createChangesetRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.createChangeset((CreateChangesetRequest)((Object)((CreateChangesetRequest.Builder)CreateChangesetRequest.builder().applyMutation(createChangesetRequest)).build()));
    }

    default public GetProgrammaticAccessCredentialsResponse getProgrammaticAccessCredentials(GetProgrammaticAccessCredentialsRequest getProgrammaticAccessCredentialsRequest) throws InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public GetProgrammaticAccessCredentialsResponse getProgrammaticAccessCredentials(Consumer<GetProgrammaticAccessCredentialsRequest.Builder> getProgrammaticAccessCredentialsRequest) throws InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.getProgrammaticAccessCredentials((GetProgrammaticAccessCredentialsRequest)((Object)((GetProgrammaticAccessCredentialsRequest.Builder)GetProgrammaticAccessCredentialsRequest.builder().applyMutation(getProgrammaticAccessCredentialsRequest)).build()));
    }

    default public GetWorkingLocationResponse getWorkingLocation(GetWorkingLocationRequest getWorkingLocationRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, FinspaceDataException {
        throw new UnsupportedOperationException();
    }

    default public GetWorkingLocationResponse getWorkingLocation(Consumer<GetWorkingLocationRequest.Builder> getWorkingLocationRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, FinspaceDataException {
        return this.getWorkingLocation((GetWorkingLocationRequest)((Object)((GetWorkingLocationRequest.Builder)GetWorkingLocationRequest.builder().applyMutation(getWorkingLocationRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"finspace-api");
    }
}

