/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspacedata.FinspaceDataAsyncClient;
import software.amazon.awssdk.services.finspacedata.model.ChangesetSummary;
import software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest;
import software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse;

public class ListChangesetsPublisher
implements SdkPublisher<ListChangesetsResponse> {
    private final FinspaceDataAsyncClient client;
    private final ListChangesetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChangesetsPublisher(FinspaceDataAsyncClient client, ListChangesetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChangesetsPublisher(FinspaceDataAsyncClient client, ListChangesetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChangesetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChangesetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChangesetSummary> changesets() {
        Function<ListChangesetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.changesets() != null) {
                return response.changesets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListChangesetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListChangesetsResponseFetcher
    implements AsyncPageFetcher<ListChangesetsResponse> {
        private ListChangesetsResponseFetcher() {
        }

        public boolean hasNextPage(ListChangesetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChangesetsResponse> nextPage(ListChangesetsResponse previousPage) {
            if (previousPage == null) {
                return ListChangesetsPublisher.this.client.listChangesets(ListChangesetsPublisher.this.firstRequest);
            }
            return ListChangesetsPublisher.this.client.listChangesets((ListChangesetsRequest)((Object)ListChangesetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

