/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.finspacedata.model.ChangeType;
import software.amazon.awssdk.services.finspacedata.model.ChangesetStatus;
import software.amazon.awssdk.services.finspacedata.model.ErrorInfo;
import software.amazon.awssdk.services.finspacedata.model.FormatType;
import software.amazon.awssdk.services.finspacedata.model.SourceType;
import software.amazon.awssdk.services.finspacedata.model._stringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangesetInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangesetInfo> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ChangesetInfo.getter(ChangesetInfo::id)).setter(ChangesetInfo.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> CHANGESET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changesetArn").getter(ChangesetInfo.getter(ChangesetInfo::changesetArn)).setter(ChangesetInfo.setter(Builder::changesetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetArn").build()}).build();
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(ChangesetInfo.getter(ChangesetInfo::datasetId)).setter(ChangesetInfo.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()}).build();
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changeType").getter(ChangesetInfo.getter(ChangesetInfo::changeTypeAsString)).setter(ChangesetInfo.setter(Builder::changeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(ChangesetInfo.getter(ChangesetInfo::sourceTypeAsString)).setter(ChangesetInfo.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final SdkField<Map<String, String>> SOURCE_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sourceParams").getter(ChangesetInfo.getter(ChangesetInfo::sourceParams)).setter(ChangesetInfo.setter(Builder::sourceParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceParams").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> FORMAT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formatType").getter(ChangesetInfo.getter(ChangesetInfo::formatTypeAsString)).setter(ChangesetInfo.setter(Builder::formatType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatType").build()}).build();
    private static final SdkField<Map<String, String>> FORMAT_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("formatParams").getter(ChangesetInfo.getter(ChangesetInfo::formatParams)).setter(ChangesetInfo.setter(Builder::formatParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatParams").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTimestamp").getter(ChangesetInfo.getter(ChangesetInfo::createTimestamp)).setter(ChangesetInfo.setter(Builder::createTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ChangesetInfo.getter(ChangesetInfo::statusAsString)).setter(ChangesetInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorInfo").getter(ChangesetInfo.getter(ChangesetInfo::errorInfo)).setter(ChangesetInfo.setter(Builder::errorInfo)).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final SdkField<Map<String, String>> CHANGESET_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("changesetLabels").getter(ChangesetInfo.getter(ChangesetInfo::changesetLabels)).setter(ChangesetInfo.setter(Builder::changesetLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetLabels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATES_CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatesChangesetId").getter(ChangesetInfo.getter(ChangesetInfo::updatesChangesetId)).setter(ChangesetInfo.setter(Builder::updatesChangesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatesChangesetId").build()}).build();
    private static final SdkField<String> UPDATED_BY_CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedByChangesetId").getter(ChangesetInfo.getter(ChangesetInfo::updatedByChangesetId)).setter(ChangesetInfo.setter(Builder::updatedByChangesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedByChangesetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CHANGESET_ARN_FIELD, DATASET_ID_FIELD, CHANGE_TYPE_FIELD, SOURCE_TYPE_FIELD, SOURCE_PARAMS_FIELD, FORMAT_TYPE_FIELD, FORMAT_PARAMS_FIELD, CREATE_TIMESTAMP_FIELD, STATUS_FIELD, ERROR_INFO_FIELD, CHANGESET_LABELS_FIELD, UPDATES_CHANGESET_ID_FIELD, UPDATED_BY_CHANGESET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String changesetArn;
    private final String datasetId;
    private final String changeType;
    private final String sourceType;
    private final Map<String, String> sourceParams;
    private final String formatType;
    private final Map<String, String> formatParams;
    private final Instant createTimestamp;
    private final String status;
    private final ErrorInfo errorInfo;
    private final Map<String, String> changesetLabels;
    private final String updatesChangesetId;
    private final String updatedByChangesetId;

    private ChangesetInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.changesetArn = builder.changesetArn;
        this.datasetId = builder.datasetId;
        this.changeType = builder.changeType;
        this.sourceType = builder.sourceType;
        this.sourceParams = builder.sourceParams;
        this.formatType = builder.formatType;
        this.formatParams = builder.formatParams;
        this.createTimestamp = builder.createTimestamp;
        this.status = builder.status;
        this.errorInfo = builder.errorInfo;
        this.changesetLabels = builder.changesetLabels;
        this.updatesChangesetId = builder.updatesChangesetId;
        this.updatedByChangesetId = builder.updatedByChangesetId;
    }

    public final String id() {
        return this.id;
    }

    public final String changesetArn() {
        return this.changesetArn;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final ChangeType changeType() {
        return ChangeType.fromValue(this.changeType);
    }

    public final String changeTypeAsString() {
        return this.changeType;
    }

    public final SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final boolean hasSourceParams() {
        return this.sourceParams != null && !(this.sourceParams instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sourceParams() {
        return this.sourceParams;
    }

    public final FormatType formatType() {
        return FormatType.fromValue(this.formatType);
    }

    public final String formatTypeAsString() {
        return this.formatType;
    }

    public final boolean hasFormatParams() {
        return this.formatParams != null && !(this.formatParams instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> formatParams() {
        return this.formatParams;
    }

    public final Instant createTimestamp() {
        return this.createTimestamp;
    }

    public final ChangesetStatus status() {
        return ChangesetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public final boolean hasChangesetLabels() {
        return this.changesetLabels != null && !(this.changesetLabels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> changesetLabels() {
        return this.changesetLabels;
    }

    public final String updatesChangesetId() {
        return this.updatesChangesetId;
    }

    public final String updatedByChangesetId() {
        return this.updatedByChangesetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.changesetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceParams() ? this.sourceParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.formatTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormatParams() ? this.formatParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangesetLabels() ? this.changesetLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatesChangesetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedByChangesetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangesetInfo)) {
            return false;
        }
        ChangesetInfo other = (ChangesetInfo)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.changesetArn(), other.changesetArn()) && Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.changeTypeAsString(), other.changeTypeAsString()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && this.hasSourceParams() == other.hasSourceParams() && Objects.equals(this.sourceParams(), other.sourceParams()) && Objects.equals(this.formatTypeAsString(), other.formatTypeAsString()) && this.hasFormatParams() == other.hasFormatParams() && Objects.equals(this.formatParams(), other.formatParams()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorInfo(), other.errorInfo()) && this.hasChangesetLabels() == other.hasChangesetLabels() && Objects.equals(this.changesetLabels(), other.changesetLabels()) && Objects.equals(this.updatesChangesetId(), other.updatesChangesetId()) && Objects.equals(this.updatedByChangesetId(), other.updatedByChangesetId());
    }

    public final String toString() {
        return ToString.builder((String)"ChangesetInfo").add("Id", (Object)this.id()).add("ChangesetArn", (Object)this.changesetArn()).add("DatasetId", (Object)this.datasetId()).add("ChangeType", (Object)this.changeTypeAsString()).add("SourceType", (Object)this.sourceTypeAsString()).add("SourceParams", this.hasSourceParams() ? this.sourceParams() : null).add("FormatType", (Object)this.formatTypeAsString()).add("FormatParams", this.hasFormatParams() ? this.formatParams() : null).add("CreateTimestamp", (Object)this.createTimestamp()).add("Status", (Object)this.statusAsString()).add("ErrorInfo", (Object)this.errorInfo()).add("ChangesetLabels", this.hasChangesetLabels() ? this.changesetLabels() : null).add("UpdatesChangesetId", (Object)this.updatesChangesetId()).add("UpdatedByChangesetId", (Object)this.updatedByChangesetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "changesetArn": {
                return Optional.ofNullable(clazz.cast(this.changesetArn()));
            }
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "changeType": {
                return Optional.ofNullable(clazz.cast(this.changeTypeAsString()));
            }
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "sourceParams": {
                return Optional.ofNullable(clazz.cast(this.sourceParams()));
            }
            case "formatType": {
                return Optional.ofNullable(clazz.cast(this.formatTypeAsString()));
            }
            case "formatParams": {
                return Optional.ofNullable(clazz.cast(this.formatParams()));
            }
            case "createTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createTimestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "changesetLabels": {
                return Optional.ofNullable(clazz.cast(this.changesetLabels()));
            }
            case "updatesChangesetId": {
                return Optional.ofNullable(clazz.cast(this.updatesChangesetId()));
            }
            case "updatedByChangesetId": {
                return Optional.ofNullable(clazz.cast(this.updatedByChangesetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangesetInfo, T> g) {
        return obj -> g.apply((ChangesetInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String changesetArn;
        private String datasetId;
        private String changeType;
        private String sourceType;
        private Map<String, String> sourceParams = DefaultSdkAutoConstructMap.getInstance();
        private String formatType;
        private Map<String, String> formatParams = DefaultSdkAutoConstructMap.getInstance();
        private Instant createTimestamp;
        private String status;
        private ErrorInfo errorInfo;
        private Map<String, String> changesetLabels = DefaultSdkAutoConstructMap.getInstance();
        private String updatesChangesetId;
        private String updatedByChangesetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangesetInfo model) {
            this.id(model.id);
            this.changesetArn(model.changesetArn);
            this.datasetId(model.datasetId);
            this.changeType(model.changeType);
            this.sourceType(model.sourceType);
            this.sourceParams(model.sourceParams);
            this.formatType(model.formatType);
            this.formatParams(model.formatParams);
            this.createTimestamp(model.createTimestamp);
            this.status(model.status);
            this.errorInfo(model.errorInfo);
            this.changesetLabels(model.changesetLabels);
            this.updatesChangesetId(model.updatesChangesetId);
            this.updatedByChangesetId(model.updatedByChangesetId);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getChangesetArn() {
            return this.changesetArn;
        }

        @Override
        public final Builder changesetArn(String changesetArn) {
            this.changesetArn = changesetArn;
            return this;
        }

        public final void setChangesetArn(String changesetArn) {
            this.changesetArn = changesetArn;
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        public final String getChangeType() {
            return this.changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Map<String, String> getSourceParams() {
            if (this.sourceParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sourceParams;
        }

        @Override
        public final Builder sourceParams(Map<String, String> sourceParams) {
            this.sourceParams = _stringMapCopier.copy(sourceParams);
            return this;
        }

        public final void setSourceParams(Map<String, String> sourceParams) {
            this.sourceParams = _stringMapCopier.copy(sourceParams);
        }

        public final String getFormatType() {
            return this.formatType;
        }

        @Override
        public final Builder formatType(String formatType) {
            this.formatType = formatType;
            return this;
        }

        @Override
        public final Builder formatType(FormatType formatType) {
            this.formatType(formatType == null ? null : formatType.toString());
            return this;
        }

        public final void setFormatType(String formatType) {
            this.formatType = formatType;
        }

        public final Map<String, String> getFormatParams() {
            if (this.formatParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.formatParams;
        }

        @Override
        public final Builder formatParams(Map<String, String> formatParams) {
            this.formatParams = _stringMapCopier.copy(formatParams);
            return this;
        }

        public final void setFormatParams(Map<String, String> formatParams) {
            this.formatParams = _stringMapCopier.copy(formatParams);
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangesetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        public final Map<String, String> getChangesetLabels() {
            if (this.changesetLabels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.changesetLabels;
        }

        @Override
        public final Builder changesetLabels(Map<String, String> changesetLabels) {
            this.changesetLabels = _stringMapCopier.copy(changesetLabels);
            return this;
        }

        public final void setChangesetLabels(Map<String, String> changesetLabels) {
            this.changesetLabels = _stringMapCopier.copy(changesetLabels);
        }

        public final String getUpdatesChangesetId() {
            return this.updatesChangesetId;
        }

        @Override
        public final Builder updatesChangesetId(String updatesChangesetId) {
            this.updatesChangesetId = updatesChangesetId;
            return this;
        }

        public final void setUpdatesChangesetId(String updatesChangesetId) {
            this.updatesChangesetId = updatesChangesetId;
        }

        public final String getUpdatedByChangesetId() {
            return this.updatedByChangesetId;
        }

        @Override
        public final Builder updatedByChangesetId(String updatedByChangesetId) {
            this.updatedByChangesetId = updatedByChangesetId;
            return this;
        }

        public final void setUpdatedByChangesetId(String updatedByChangesetId) {
            this.updatedByChangesetId = updatedByChangesetId;
        }

        public ChangesetInfo build() {
            return new ChangesetInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangesetInfo> {
        public Builder id(String var1);

        public Builder changesetArn(String var1);

        public Builder datasetId(String var1);

        public Builder changeType(String var1);

        public Builder changeType(ChangeType var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder sourceParams(Map<String, String> var1);

        public Builder formatType(String var1);

        public Builder formatType(FormatType var1);

        public Builder formatParams(Map<String, String> var1);

        public Builder createTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(ChangesetStatus var1);

        public Builder errorInfo(ErrorInfo var1);

        default public Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return this.errorInfo((ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder changesetLabels(Map<String, String> var1);

        public Builder updatesChangesetId(String var1);

        public Builder updatedByChangesetId(String var1);
    }
}

