/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.AvailabilityZoneIdsCopier;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.services.finspace.model.KxAzMode;
import software.amazon.awssdk.services.finspace.model.KxNAS1Configuration;
import software.amazon.awssdk.services.finspace.model.KxVolumeStatus;
import software.amazon.awssdk.services.finspace.model.KxVolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKxVolumeResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, CreateKxVolumeResponse> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateKxVolumeResponse.getter(CreateKxVolumeResponse::environmentId)).setter(CreateKxVolumeResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeName").getter(CreateKxVolumeResponse.getter(CreateKxVolumeResponse::volumeName)).setter(CreateKxVolumeResponse.setter(Builder::volumeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeName").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeType").getter(CreateKxVolumeResponse.getter(CreateKxVolumeResponse::volumeTypeAsString)).setter(CreateKxVolumeResponse.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()}).build();
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeArn").getter(CreateKxVolumeResponse.getter(CreateKxVolumeResponse::volumeArn)).setter(CreateKxVolumeResponse.setter(Builder::volumeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeArn").build()}).build();
    private static final SdkField<KxNAS1Configuration> NAS1_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nas1Configuration").getter(CreateKxVolumeResponse.getter(CreateKxVolumeResponse::nas1Configuration)).setter(CreateKxVolumeResponse.setter(Builder::nas1Configuration)).constructor(KxNAS1Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nas1Configuration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateKxVolumeResponse.getter(CreateKxVolumeResponse::statusAsString)).setter(CreateKxVolumeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(CreateKxVolumeResponse.getter(CreateKxVolumeResponse::statusReason)).setter(CreateKxVolumeResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> AZ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("azMode").getter(CreateKxVolumeResponse.getter(CreateKxVolumeResponse::azModeAsString)).setter(CreateKxVolumeResponse.setter(Builder::azMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateKxVolumeResponse.getter(CreateKxVolumeResponse::description)).setter(CreateKxVolumeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("availabilityZoneIds").getter(CreateKxVolumeResponse.getter(CreateKxVolumeResponse::availabilityZoneIds)).setter(CreateKxVolumeResponse.setter(Builder::availabilityZoneIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(CreateKxVolumeResponse.getter(CreateKxVolumeResponse::createdTimestamp)).setter(CreateKxVolumeResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, VOLUME_NAME_FIELD, VOLUME_TYPE_FIELD, VOLUME_ARN_FIELD, NAS1_CONFIGURATION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, AZ_MODE_FIELD, DESCRIPTION_FIELD, AVAILABILITY_ZONE_IDS_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateKxVolumeResponse.memberNameToFieldInitializer();
    private final String environmentId;
    private final String volumeName;
    private final String volumeType;
    private final String volumeArn;
    private final KxNAS1Configuration nas1Configuration;
    private final String status;
    private final String statusReason;
    private final String azMode;
    private final String description;
    private final List<String> availabilityZoneIds;
    private final Instant createdTimestamp;

    private CreateKxVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.volumeName = builder.volumeName;
        this.volumeType = builder.volumeType;
        this.volumeArn = builder.volumeArn;
        this.nas1Configuration = builder.nas1Configuration;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.azMode = builder.azMode;
        this.description = builder.description;
        this.availabilityZoneIds = builder.availabilityZoneIds;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String volumeName() {
        return this.volumeName;
    }

    public final KxVolumeType volumeType() {
        return KxVolumeType.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public final String volumeArn() {
        return this.volumeArn;
    }

    public final KxNAS1Configuration nas1Configuration() {
        return this.nas1Configuration;
    }

    public final KxVolumeStatus status() {
        return KxVolumeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final KxAzMode azMode() {
        return KxAzMode.fromValue(this.azMode);
    }

    public final String azModeAsString() {
        return this.azMode;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasAvailabilityZoneIds() {
        return this.availabilityZoneIds != null && !(this.availabilityZoneIds instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZoneIds() {
        return this.availabilityZoneIds;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nas1Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxVolumeResponse)) {
            return false;
        }
        CreateKxVolumeResponse other = (CreateKxVolumeResponse)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.volumeName(), other.volumeName()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(this.volumeArn(), other.volumeArn()) && Objects.equals(this.nas1Configuration(), other.nas1Configuration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.azModeAsString(), other.azModeAsString()) && Objects.equals(this.description(), other.description()) && this.hasAvailabilityZoneIds() == other.hasAvailabilityZoneIds() && Objects.equals(this.availabilityZoneIds(), other.availabilityZoneIds()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKxVolumeResponse").add("EnvironmentId", (Object)this.environmentId()).add("VolumeName", (Object)this.volumeName()).add("VolumeType", (Object)this.volumeTypeAsString()).add("VolumeArn", (Object)this.volumeArn()).add("Nas1Configuration", (Object)this.nas1Configuration()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("AzMode", (Object)this.azModeAsString()).add("Description", (Object)this.description()).add("AvailabilityZoneIds", this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "volumeName": {
                return Optional.ofNullable(clazz.cast(this.volumeName()));
            }
            case "volumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
            case "volumeArn": {
                return Optional.ofNullable(clazz.cast(this.volumeArn()));
            }
            case "nas1Configuration": {
                return Optional.ofNullable(clazz.cast(this.nas1Configuration()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "azMode": {
                return Optional.ofNullable(clazz.cast(this.azModeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "availabilityZoneIds": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneIds()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("volumeName", VOLUME_NAME_FIELD);
        map.put("volumeType", VOLUME_TYPE_FIELD);
        map.put("volumeArn", VOLUME_ARN_FIELD);
        map.put("nas1Configuration", NAS1_CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("azMode", AZ_MODE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("availabilityZoneIds", AVAILABILITY_ZONE_IDS_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKxVolumeResponse, T> g) {
        return obj -> g.apply((CreateKxVolumeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private String environmentId;
        private String volumeName;
        private String volumeType;
        private String volumeArn;
        private KxNAS1Configuration nas1Configuration;
        private String status;
        private String statusReason;
        private String azMode;
        private String description;
        private List<String> availabilityZoneIds = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxVolumeResponse model) {
            super(model);
            this.environmentId(model.environmentId);
            this.volumeName(model.volumeName);
            this.volumeType(model.volumeType);
            this.volumeArn(model.volumeArn);
            this.nas1Configuration(model.nas1Configuration);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.azMode(model.azMode);
            this.description(model.description);
            this.availabilityZoneIds(model.availabilityZoneIds);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getVolumeName() {
            return this.volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(KxVolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final String getVolumeArn() {
            return this.volumeArn;
        }

        public final void setVolumeArn(String volumeArn) {
            this.volumeArn = volumeArn;
        }

        @Override
        public final Builder volumeArn(String volumeArn) {
            this.volumeArn = volumeArn;
            return this;
        }

        public final KxNAS1Configuration.Builder getNas1Configuration() {
            return this.nas1Configuration != null ? this.nas1Configuration.toBuilder() : null;
        }

        public final void setNas1Configuration(KxNAS1Configuration.BuilderImpl nas1Configuration) {
            this.nas1Configuration = nas1Configuration != null ? nas1Configuration.build() : null;
        }

        @Override
        public final Builder nas1Configuration(KxNAS1Configuration nas1Configuration) {
            this.nas1Configuration = nas1Configuration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxVolumeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getAzMode() {
            return this.azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getAvailabilityZoneIds() {
            if (this.availabilityZoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZoneIds;
        }

        public final void setAvailabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
        }

        @Override
        public final Builder availabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIds(String ... availabilityZoneIds) {
            this.availabilityZoneIds(Arrays.asList(availabilityZoneIds));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public CreateKxVolumeResponse build() {
            return new CreateKxVolumeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKxVolumeResponse> {
        public Builder environmentId(String var1);

        public Builder volumeName(String var1);

        public Builder volumeType(String var1);

        public Builder volumeType(KxVolumeType var1);

        public Builder volumeArn(String var1);

        public Builder nas1Configuration(KxNAS1Configuration var1);

        default public Builder nas1Configuration(Consumer<KxNAS1Configuration.Builder> nas1Configuration) {
            return this.nas1Configuration((KxNAS1Configuration)((KxNAS1Configuration.Builder)KxNAS1Configuration.builder().applyMutation(nas1Configuration)).build());
        }

        public Builder status(String var1);

        public Builder status(KxVolumeStatus var1);

        public Builder statusReason(String var1);

        public Builder azMode(String var1);

        public Builder azMode(KxAzMode var1);

        public Builder description(String var1);

        public Builder availabilityZoneIds(Collection<String> var1);

        public Builder availabilityZoneIds(String ... var1);

        public Builder createdTimestamp(Instant var1);
    }
}

