/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.AttachedClusterListCopier;
import software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration;
import software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxDataviewActiveVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxDataviewActiveVersion> {
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changesetId").getter(KxDataviewActiveVersion.getter(KxDataviewActiveVersion::changesetId)).setter(KxDataviewActiveVersion.setter(Builder::changesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()}).build();
    private static final SdkField<List<KxDataviewSegmentConfiguration>> SEGMENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("segmentConfigurations").getter(KxDataviewActiveVersion.getter(KxDataviewActiveVersion::segmentConfigurations)).setter(KxDataviewActiveVersion.setter(Builder::segmentConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxDataviewSegmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ATTACHED_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attachedClusters").getter(KxDataviewActiveVersion.getter(KxDataviewActiveVersion::attachedClusters)).setter(KxDataviewActiveVersion.setter(Builder::attachedClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedClusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(KxDataviewActiveVersion.getter(KxDataviewActiveVersion::createdTimestamp)).setter(KxDataviewActiveVersion.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionId").getter(KxDataviewActiveVersion.getter(KxDataviewActiveVersion::versionId)).setter(KxDataviewActiveVersion.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGESET_ID_FIELD, SEGMENT_CONFIGURATIONS_FIELD, ATTACHED_CLUSTERS_FIELD, CREATED_TIMESTAMP_FIELD, VERSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KxDataviewActiveVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String changesetId;
    private final List<KxDataviewSegmentConfiguration> segmentConfigurations;
    private final List<String> attachedClusters;
    private final Instant createdTimestamp;
    private final String versionId;

    private KxDataviewActiveVersion(BuilderImpl builder) {
        this.changesetId = builder.changesetId;
        this.segmentConfigurations = builder.segmentConfigurations;
        this.attachedClusters = builder.attachedClusters;
        this.createdTimestamp = builder.createdTimestamp;
        this.versionId = builder.versionId;
    }

    public final String changesetId() {
        return this.changesetId;
    }

    public final boolean hasSegmentConfigurations() {
        return this.segmentConfigurations != null && !(this.segmentConfigurations instanceof SdkAutoConstructList);
    }

    public final List<KxDataviewSegmentConfiguration> segmentConfigurations() {
        return this.segmentConfigurations;
    }

    public final boolean hasAttachedClusters() {
        return this.attachedClusters != null && !(this.attachedClusters instanceof SdkAutoConstructList);
    }

    public final List<String> attachedClusters() {
        return this.attachedClusters;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final String versionId() {
        return this.versionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentConfigurations() ? this.segmentConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachedClusters() ? this.attachedClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDataviewActiveVersion)) {
            return false;
        }
        KxDataviewActiveVersion other = (KxDataviewActiveVersion)obj;
        return Objects.equals(this.changesetId(), other.changesetId()) && this.hasSegmentConfigurations() == other.hasSegmentConfigurations() && Objects.equals(this.segmentConfigurations(), other.segmentConfigurations()) && this.hasAttachedClusters() == other.hasAttachedClusters() && Objects.equals(this.attachedClusters(), other.attachedClusters()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.versionId(), other.versionId());
    }

    public final String toString() {
        return ToString.builder((String)"KxDataviewActiveVersion").add("ChangesetId", (Object)this.changesetId()).add("SegmentConfigurations", this.hasSegmentConfigurations() ? this.segmentConfigurations() : null).add("AttachedClusters", this.hasAttachedClusters() ? this.attachedClusters() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("VersionId", (Object)this.versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "changesetId": {
                return Optional.ofNullable(clazz.cast(this.changesetId()));
            }
            case "segmentConfigurations": {
                return Optional.ofNullable(clazz.cast(this.segmentConfigurations()));
            }
            case "attachedClusters": {
                return Optional.ofNullable(clazz.cast(this.attachedClusters()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "versionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("changesetId", CHANGESET_ID_FIELD);
        map.put("segmentConfigurations", SEGMENT_CONFIGURATIONS_FIELD);
        map.put("attachedClusters", ATTACHED_CLUSTERS_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("versionId", VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxDataviewActiveVersion, T> g) {
        return obj -> g.apply((KxDataviewActiveVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String changesetId;
        private List<KxDataviewSegmentConfiguration> segmentConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<String> attachedClusters = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(KxDataviewActiveVersion model) {
            this.changesetId(model.changesetId);
            this.segmentConfigurations(model.segmentConfigurations);
            this.attachedClusters(model.attachedClusters);
            this.createdTimestamp(model.createdTimestamp);
            this.versionId(model.versionId);
        }

        public final String getChangesetId() {
            return this.changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final List<KxDataviewSegmentConfiguration.Builder> getSegmentConfigurations() {
            List<KxDataviewSegmentConfiguration.Builder> result = KxDataviewSegmentConfigurationListCopier.copyToBuilder(this.segmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentConfigurations(Collection<KxDataviewSegmentConfiguration.BuilderImpl> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copyFromBuilder(segmentConfigurations);
        }

        @Override
        public final Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copy(segmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(KxDataviewSegmentConfiguration ... segmentConfigurations) {
            this.segmentConfigurations(Arrays.asList(segmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder> ... segmentConfigurations) {
            this.segmentConfigurations(Stream.of(segmentConfigurations).map(c -> (KxDataviewSegmentConfiguration)((KxDataviewSegmentConfiguration.Builder)KxDataviewSegmentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAttachedClusters() {
            if (this.attachedClusters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attachedClusters;
        }

        public final void setAttachedClusters(Collection<String> attachedClusters) {
            this.attachedClusters = AttachedClusterListCopier.copy(attachedClusters);
        }

        @Override
        public final Builder attachedClusters(Collection<String> attachedClusters) {
            this.attachedClusters = AttachedClusterListCopier.copy(attachedClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedClusters(String ... attachedClusters) {
            this.attachedClusters(Arrays.asList(attachedClusters));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public KxDataviewActiveVersion build() {
            return new KxDataviewActiveVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxDataviewActiveVersion> {
        public Builder changesetId(String var1);

        public Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> var1);

        public Builder segmentConfigurations(KxDataviewSegmentConfiguration ... var1);

        public Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder> ... var1);

        public Builder attachedClusters(Collection<String> var1);

        public Builder attachedClusters(String ... var1);

        public Builder createdTimestamp(Instant var1);

        public Builder versionId(String var1);
    }
}

