/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceAsyncClient;
import software.amazon.awssdk.services.finspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspace.model.ListKxDataviewsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxDataviewsResponse;

public class ListKxDataviewsPublisher
implements SdkPublisher<ListKxDataviewsResponse> {
    private final FinspaceAsyncClient client;
    private final ListKxDataviewsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKxDataviewsPublisher(FinspaceAsyncClient client, ListKxDataviewsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKxDataviewsPublisher(FinspaceAsyncClient client, ListKxDataviewsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKxDataviewsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKxDataviewsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListKxDataviewsResponseFetcher
    implements AsyncPageFetcher<ListKxDataviewsResponse> {
        private ListKxDataviewsResponseFetcher() {
        }

        public boolean hasNextPage(ListKxDataviewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKxDataviewsResponse> nextPage(ListKxDataviewsResponse previousPage) {
            if (previousPage == null) {
                return ListKxDataviewsPublisher.this.client.listKxDataviews(ListKxDataviewsPublisher.this.firstRequest);
            }
            return ListKxDataviewsPublisher.this.client.listKxDataviews((ListKxDataviewsRequest)((Object)ListKxDataviewsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

