/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.EnvironmentStatus;
import software.amazon.awssdk.services.finspace.model.FederationMode;
import software.amazon.awssdk.services.finspace.model.FederationParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Environment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Environment> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Environment.getter(Environment::name)).setter(Environment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(Environment.getter(Environment::environmentId)).setter(Environment.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(Environment.getter(Environment::awsAccountId)).setter(Environment.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Environment.getter(Environment::statusAsString)).setter(Environment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ENVIRONMENT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentUrl").getter(Environment.getter(Environment::environmentUrl)).setter(Environment.setter(Builder::environmentUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentUrl").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Environment.getter(Environment::description)).setter(Environment.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentArn").getter(Environment.getter(Environment::environmentArn)).setter(Environment.setter(Builder::environmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()}).build();
    private static final SdkField<String> SAGE_MAKER_STUDIO_DOMAIN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sageMakerStudioDomainUrl").getter(Environment.getter(Environment::sageMakerStudioDomainUrl)).setter(Environment.setter(Builder::sageMakerStudioDomainUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sageMakerStudioDomainUrl").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(Environment.getter(Environment::kmsKeyId)).setter(Environment.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> DEDICATED_SERVICE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dedicatedServiceAccountId").getter(Environment.getter(Environment::dedicatedServiceAccountId)).setter(Environment.setter(Builder::dedicatedServiceAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedicatedServiceAccountId").build()}).build();
    private static final SdkField<String> FEDERATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("federationMode").getter(Environment.getter(Environment::federationModeAsString)).setter(Environment.setter(Builder::federationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationMode").build()}).build();
    private static final SdkField<FederationParameters> FEDERATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("federationParameters").getter(Environment.getter(Environment::federationParameters)).setter(Environment.setter(Builder::federationParameters)).constructor(FederationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ENVIRONMENT_ID_FIELD, AWS_ACCOUNT_ID_FIELD, STATUS_FIELD, ENVIRONMENT_URL_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_ARN_FIELD, SAGE_MAKER_STUDIO_DOMAIN_URL_FIELD, KMS_KEY_ID_FIELD, DEDICATED_SERVICE_ACCOUNT_ID_FIELD, FEDERATION_MODE_FIELD, FEDERATION_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Environment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String environmentId;
    private final String awsAccountId;
    private final String status;
    private final String environmentUrl;
    private final String description;
    private final String environmentArn;
    private final String sageMakerStudioDomainUrl;
    private final String kmsKeyId;
    private final String dedicatedServiceAccountId;
    private final String federationMode;
    private final FederationParameters federationParameters;

    private Environment(BuilderImpl builder) {
        this.name = builder.name;
        this.environmentId = builder.environmentId;
        this.awsAccountId = builder.awsAccountId;
        this.status = builder.status;
        this.environmentUrl = builder.environmentUrl;
        this.description = builder.description;
        this.environmentArn = builder.environmentArn;
        this.sageMakerStudioDomainUrl = builder.sageMakerStudioDomainUrl;
        this.kmsKeyId = builder.kmsKeyId;
        this.dedicatedServiceAccountId = builder.dedicatedServiceAccountId;
        this.federationMode = builder.federationMode;
        this.federationParameters = builder.federationParameters;
    }

    public final String name() {
        return this.name;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String environmentUrl() {
        return this.environmentUrl;
    }

    public final String description() {
        return this.description;
    }

    public final String environmentArn() {
        return this.environmentArn;
    }

    public final String sageMakerStudioDomainUrl() {
        return this.sageMakerStudioDomainUrl;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String dedicatedServiceAccountId() {
        return this.dedicatedServiceAccountId;
    }

    public final FederationMode federationMode() {
        return FederationMode.fromValue(this.federationMode);
    }

    public final String federationModeAsString() {
        return this.federationMode;
    }

    public final FederationParameters federationParameters() {
        return this.federationParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerStudioDomainUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedServiceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.environmentUrl(), other.environmentUrl()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentArn(), other.environmentArn()) && Objects.equals(this.sageMakerStudioDomainUrl(), other.sageMakerStudioDomainUrl()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dedicatedServiceAccountId(), other.dedicatedServiceAccountId()) && Objects.equals(this.federationModeAsString(), other.federationModeAsString()) && Objects.equals(this.federationParameters(), other.federationParameters());
    }

    public final String toString() {
        return ToString.builder((String)"Environment").add("Name", (Object)this.name()).add("EnvironmentId", (Object)this.environmentId()).add("AwsAccountId", (Object)this.awsAccountId()).add("Status", (Object)this.statusAsString()).add("EnvironmentUrl", (Object)this.environmentUrl()).add("Description", (Object)this.description()).add("EnvironmentArn", (Object)this.environmentArn()).add("SageMakerStudioDomainUrl", (Object)this.sageMakerStudioDomainUrl()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DedicatedServiceAccountId", (Object)this.dedicatedServiceAccountId()).add("FederationMode", (Object)this.federationModeAsString()).add("FederationParameters", (Object)this.federationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "environmentUrl": {
                return Optional.ofNullable(clazz.cast(this.environmentUrl()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "environmentArn": {
                return Optional.ofNullable(clazz.cast(this.environmentArn()));
            }
            case "sageMakerStudioDomainUrl": {
                return Optional.ofNullable(clazz.cast(this.sageMakerStudioDomainUrl()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "dedicatedServiceAccountId": {
                return Optional.ofNullable(clazz.cast(this.dedicatedServiceAccountId()));
            }
            case "federationMode": {
                return Optional.ofNullable(clazz.cast(this.federationModeAsString()));
            }
            case "federationParameters": {
                return Optional.ofNullable(clazz.cast(this.federationParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("environmentUrl", ENVIRONMENT_URL_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("environmentArn", ENVIRONMENT_ARN_FIELD);
        map.put("sageMakerStudioDomainUrl", SAGE_MAKER_STUDIO_DOMAIN_URL_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("dedicatedServiceAccountId", DEDICATED_SERVICE_ACCOUNT_ID_FIELD);
        map.put("federationMode", FEDERATION_MODE_FIELD);
        map.put("federationParameters", FEDERATION_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String environmentId;
        private String awsAccountId;
        private String status;
        private String environmentUrl;
        private String description;
        private String environmentArn;
        private String sageMakerStudioDomainUrl;
        private String kmsKeyId;
        private String dedicatedServiceAccountId;
        private String federationMode;
        private FederationParameters federationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            this.name(model.name);
            this.environmentId(model.environmentId);
            this.awsAccountId(model.awsAccountId);
            this.status(model.status);
            this.environmentUrl(model.environmentUrl);
            this.description(model.description);
            this.environmentArn(model.environmentArn);
            this.sageMakerStudioDomainUrl(model.sageMakerStudioDomainUrl);
            this.kmsKeyId(model.kmsKeyId);
            this.dedicatedServiceAccountId(model.dedicatedServiceAccountId);
            this.federationMode(model.federationMode);
            this.federationParameters(model.federationParameters);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEnvironmentUrl() {
            return this.environmentUrl;
        }

        public final void setEnvironmentUrl(String environmentUrl) {
            this.environmentUrl = environmentUrl;
        }

        @Override
        public final Builder environmentUrl(String environmentUrl) {
            this.environmentUrl = environmentUrl;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentArn() {
            return this.environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getSageMakerStudioDomainUrl() {
            return this.sageMakerStudioDomainUrl;
        }

        public final void setSageMakerStudioDomainUrl(String sageMakerStudioDomainUrl) {
            this.sageMakerStudioDomainUrl = sageMakerStudioDomainUrl;
        }

        @Override
        public final Builder sageMakerStudioDomainUrl(String sageMakerStudioDomainUrl) {
            this.sageMakerStudioDomainUrl = sageMakerStudioDomainUrl;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDedicatedServiceAccountId() {
            return this.dedicatedServiceAccountId;
        }

        public final void setDedicatedServiceAccountId(String dedicatedServiceAccountId) {
            this.dedicatedServiceAccountId = dedicatedServiceAccountId;
        }

        @Override
        public final Builder dedicatedServiceAccountId(String dedicatedServiceAccountId) {
            this.dedicatedServiceAccountId = dedicatedServiceAccountId;
            return this;
        }

        public final String getFederationMode() {
            return this.federationMode;
        }

        public final void setFederationMode(String federationMode) {
            this.federationMode = federationMode;
        }

        @Override
        public final Builder federationMode(String federationMode) {
            this.federationMode = federationMode;
            return this;
        }

        @Override
        public final Builder federationMode(FederationMode federationMode) {
            this.federationMode(federationMode == null ? null : federationMode.toString());
            return this;
        }

        public final FederationParameters.Builder getFederationParameters() {
            return this.federationParameters != null ? this.federationParameters.toBuilder() : null;
        }

        public final void setFederationParameters(FederationParameters.BuilderImpl federationParameters) {
            this.federationParameters = federationParameters != null ? federationParameters.build() : null;
        }

        @Override
        public final Builder federationParameters(FederationParameters federationParameters) {
            this.federationParameters = federationParameters;
            return this;
        }

        public Environment build() {
            return new Environment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Environment> {
        public Builder name(String var1);

        public Builder environmentId(String var1);

        public Builder awsAccountId(String var1);

        public Builder status(String var1);

        public Builder status(EnvironmentStatus var1);

        public Builder environmentUrl(String var1);

        public Builder description(String var1);

        public Builder environmentArn(String var1);

        public Builder sageMakerStudioDomainUrl(String var1);

        public Builder kmsKeyId(String var1);

        public Builder dedicatedServiceAccountId(String var1);

        public Builder federationMode(String var1);

        public Builder federationMode(FederationMode var1);

        public Builder federationParameters(FederationParameters var1);

        default public Builder federationParameters(Consumer<FederationParameters.Builder> federationParameters) {
            return this.federationParameters((FederationParameters)((FederationParameters.Builder)FederationParameters.builder().applyMutation(federationParameters)).build());
        }
    }
}

