/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.services.finspace.model.KxScalingGroupStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKxScalingGroupResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, CreateKxScalingGroupResponse> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateKxScalingGroupResponse.getter(CreateKxScalingGroupResponse::environmentId)).setter(CreateKxScalingGroupResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scalingGroupName").getter(CreateKxScalingGroupResponse.getter(CreateKxScalingGroupResponse::scalingGroupName)).setter(CreateKxScalingGroupResponse.setter(Builder::scalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingGroupName").build()}).build();
    private static final SdkField<String> HOST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostType").getter(CreateKxScalingGroupResponse.getter(CreateKxScalingGroupResponse::hostType)).setter(CreateKxScalingGroupResponse.setter(Builder::hostType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(CreateKxScalingGroupResponse.getter(CreateKxScalingGroupResponse::availabilityZoneId)).setter(CreateKxScalingGroupResponse.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateKxScalingGroupResponse.getter(CreateKxScalingGroupResponse::statusAsString)).setter(CreateKxScalingGroupResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(CreateKxScalingGroupResponse.getter(CreateKxScalingGroupResponse::lastModifiedTimestamp)).setter(CreateKxScalingGroupResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(CreateKxScalingGroupResponse.getter(CreateKxScalingGroupResponse::createdTimestamp)).setter(CreateKxScalingGroupResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, SCALING_GROUP_NAME_FIELD, HOST_TYPE_FIELD, AVAILABILITY_ZONE_ID_FIELD, STATUS_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("environmentId", ENVIRONMENT_ID_FIELD);
            this.put("scalingGroupName", SCALING_GROUP_NAME_FIELD);
            this.put("hostType", HOST_TYPE_FIELD);
            this.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
            this.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        }
    });
    private final String environmentId;
    private final String scalingGroupName;
    private final String hostType;
    private final String availabilityZoneId;
    private final String status;
    private final Instant lastModifiedTimestamp;
    private final Instant createdTimestamp;

    private CreateKxScalingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.scalingGroupName = builder.scalingGroupName;
        this.hostType = builder.hostType;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.status = builder.status;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String scalingGroupName() {
        return this.scalingGroupName;
    }

    public final String hostType() {
        return this.hostType;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final KxScalingGroupStatus status() {
        return KxScalingGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostType());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxScalingGroupResponse)) {
            return false;
        }
        CreateKxScalingGroupResponse other = (CreateKxScalingGroupResponse)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.scalingGroupName(), other.scalingGroupName()) && Objects.equals(this.hostType(), other.hostType()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKxScalingGroupResponse").add("EnvironmentId", (Object)this.environmentId()).add("ScalingGroupName", (Object)this.scalingGroupName()).add("HostType", (Object)this.hostType()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("Status", (Object)this.statusAsString()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "scalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.scalingGroupName()));
            }
            case "hostType": {
                return Optional.ofNullable(clazz.cast(this.hostType()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateKxScalingGroupResponse, T> g) {
        return obj -> g.apply((CreateKxScalingGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private String environmentId;
        private String scalingGroupName;
        private String hostType;
        private String availabilityZoneId;
        private String status;
        private Instant lastModifiedTimestamp;
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxScalingGroupResponse model) {
            super(model);
            this.environmentId(model.environmentId);
            this.scalingGroupName(model.scalingGroupName);
            this.hostType(model.hostType);
            this.availabilityZoneId(model.availabilityZoneId);
            this.status(model.status);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getScalingGroupName() {
            return this.scalingGroupName;
        }

        public final void setScalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
        }

        @Override
        public final Builder scalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
            return this;
        }

        public final String getHostType() {
            return this.hostType;
        }

        public final void setHostType(String hostType) {
            this.hostType = hostType;
        }

        @Override
        public final Builder hostType(String hostType) {
            this.hostType = hostType;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxScalingGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public CreateKxScalingGroupResponse build() {
            return new CreateKxScalingGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKxScalingGroupResponse> {
        public Builder environmentId(String var1);

        public Builder scalingGroupName(String var1);

        public Builder hostType(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder status(String var1);

        public Builder status(KxScalingGroupStatus var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder createdTimestamp(Instant var1);
    }
}

