/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.IcmpTypeCode;
import software.amazon.awssdk.services.finspace.model.PortRange;
import software.amazon.awssdk.services.finspace.model.RuleAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkACLEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkACLEntry> {
    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ruleNumber").getter(NetworkACLEntry.getter(NetworkACLEntry::ruleNumber)).setter(NetworkACLEntry.setter(Builder::ruleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleNumber").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(NetworkACLEntry.getter(NetworkACLEntry::protocol)).setter(NetworkACLEntry.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleAction").getter(NetworkACLEntry.getter(NetworkACLEntry::ruleActionAsString)).setter(NetworkACLEntry.setter(Builder::ruleAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleAction").build()}).build();
    private static final SdkField<PortRange> PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("portRange").getter(NetworkACLEntry.getter(NetworkACLEntry::portRange)).setter(NetworkACLEntry.setter(Builder::portRange)).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRange").build()}).build();
    private static final SdkField<IcmpTypeCode> ICMP_TYPE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("icmpTypeCode").getter(NetworkACLEntry.getter(NetworkACLEntry::icmpTypeCode)).setter(NetworkACLEntry.setter(Builder::icmpTypeCode)).constructor(IcmpTypeCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("icmpTypeCode").build()}).build();
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cidrBlock").getter(NetworkACLEntry.getter(NetworkACLEntry::cidrBlock)).setter(NetworkACLEntry.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NUMBER_FIELD, PROTOCOL_FIELD, RULE_ACTION_FIELD, PORT_RANGE_FIELD, ICMP_TYPE_CODE_FIELD, CIDR_BLOCK_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer ruleNumber;
    private final String protocol;
    private final String ruleAction;
    private final PortRange portRange;
    private final IcmpTypeCode icmpTypeCode;
    private final String cidrBlock;

    private NetworkACLEntry(BuilderImpl builder) {
        this.ruleNumber = builder.ruleNumber;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.portRange = builder.portRange;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.cidrBlock = builder.cidrBlock;
    }

    public final Integer ruleNumber() {
        return this.ruleNumber;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final RuleAction ruleAction() {
        return RuleAction.fromValue(this.ruleAction);
    }

    public final String ruleActionAsString() {
        return this.ruleAction;
    }

    public final PortRange portRange() {
        return this.portRange;
    }

    public final IcmpTypeCode icmpTypeCode() {
        return this.icmpTypeCode;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.portRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.icmpTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkACLEntry)) {
            return false;
        }
        NetworkACLEntry other = (NetworkACLEntry)obj;
        return Objects.equals(this.ruleNumber(), other.ruleNumber()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.ruleActionAsString(), other.ruleActionAsString()) && Objects.equals(this.portRange(), other.portRange()) && Objects.equals(this.icmpTypeCode(), other.icmpTypeCode()) && Objects.equals(this.cidrBlock(), other.cidrBlock());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkACLEntry").add("RuleNumber", (Object)this.ruleNumber()).add("Protocol", (Object)this.protocol()).add("RuleAction", (Object)this.ruleActionAsString()).add("PortRange", (Object)this.portRange()).add("IcmpTypeCode", (Object)this.icmpTypeCode()).add("CidrBlock", (Object)this.cidrBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleNumber": {
                return Optional.ofNullable(clazz.cast(this.ruleNumber()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "ruleAction": {
                return Optional.ofNullable(clazz.cast(this.ruleActionAsString()));
            }
            case "portRange": {
                return Optional.ofNullable(clazz.cast(this.portRange()));
            }
            case "icmpTypeCode": {
                return Optional.ofNullable(clazz.cast(this.icmpTypeCode()));
            }
            case "cidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkACLEntry, T> g) {
        return obj -> g.apply((NetworkACLEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer ruleNumber;
        private String protocol;
        private String ruleAction;
        private PortRange portRange;
        private IcmpTypeCode icmpTypeCode;
        private String cidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkACLEntry model) {
            this.ruleNumber(model.ruleNumber);
            this.protocol(model.protocol);
            this.ruleAction(model.ruleAction);
            this.portRange(model.portRange);
            this.icmpTypeCode(model.icmpTypeCode);
            this.cidrBlock(model.cidrBlock);
        }

        public final Integer getRuleNumber() {
            return this.ruleNumber;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final PortRange.Builder getPortRange() {
            return this.portRange != null ? this.portRange.toBuilder() : null;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final IcmpTypeCode.Builder getIcmpTypeCode() {
            return this.icmpTypeCode != null ? this.icmpTypeCode.toBuilder() : null;
        }

        public final void setIcmpTypeCode(IcmpTypeCode.BuilderImpl icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode != null ? icmpTypeCode.build() : null;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public NetworkACLEntry build() {
            return new NetworkACLEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkACLEntry> {
        public Builder ruleNumber(Integer var1);

        public Builder protocol(String var1);

        public Builder ruleAction(String var1);

        public Builder ruleAction(RuleAction var1);

        public Builder portRange(PortRange var1);

        default public Builder portRange(Consumer<PortRange.Builder> portRange) {
            return this.portRange((PortRange)((PortRange.Builder)PortRange.builder().applyMutation(portRange)).build());
        }

        public Builder icmpTypeCode(IcmpTypeCode var1);

        default public Builder icmpTypeCode(Consumer<IcmpTypeCode.Builder> icmpTypeCode) {
            return this.icmpTypeCode((IcmpTypeCode)((IcmpTypeCode.Builder)IcmpTypeCode.builder().applyMutation(icmpTypeCode)).build());
        }

        public Builder cidrBlock(String var1);
    }
}

