/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceAsyncClient;
import software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxChangesetsResponse;

public class ListKxChangesetsPublisher
implements SdkPublisher<ListKxChangesetsResponse> {
    private final FinspaceAsyncClient client;
    private final ListKxChangesetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKxChangesetsPublisher(FinspaceAsyncClient client, ListKxChangesetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKxChangesetsPublisher(FinspaceAsyncClient client, ListKxChangesetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKxChangesetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKxChangesetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListKxChangesetsResponseFetcher
    implements AsyncPageFetcher<ListKxChangesetsResponse> {
        private ListKxChangesetsResponseFetcher() {
        }

        public boolean hasNextPage(ListKxChangesetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKxChangesetsResponse> nextPage(ListKxChangesetsResponse previousPage) {
            if (previousPage == null) {
                return ListKxChangesetsPublisher.this.client.listKxChangesets(ListKxChangesetsPublisher.this.firstRequest);
            }
            return ListKxChangesetsPublisher.this.client.listKxChangesets((ListKxChangesetsRequest)((Object)ListKxChangesetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

