/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that stores metadata for a kdb user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxUser implements SdkPojo, Serializable, ToCopyableBuilder<KxUser.Builder, KxUser> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userArn").getter(getter(KxUser::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userName").getter(getter(KxUser::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userName").build()).build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRole").getter(getter(KxUser::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()).build();

    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTimestamp").getter(getter(KxUser::createTimestamp)).setter(setter(Builder::createTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTimestamp").build()).build();

    private static final SdkField<Instant> UPDATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTimestamp").getter(getter(KxUser::updateTimestamp)).setter(setter(Builder::updateTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD,
            USER_NAME_FIELD, IAM_ROLE_FIELD, CREATE_TIMESTAMP_FIELD, UPDATE_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userArn;

    private final String userName;

    private final String iamRole;

    private final Instant createTimestamp;

    private final Instant updateTimestamp;

    private KxUser(BuilderImpl builder) {
        this.userArn = builder.userArn;
        this.userName = builder.userName;
        this.iamRole = builder.iamRole;
        this.createTimestamp = builder.createTimestamp;
        this.updateTimestamp = builder.updateTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs and how to use ARNs in
     * policies, see <a href="IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs and how to use
     *         ARNs in policies, see <a href="IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in
     *         the <i>IAM User Guide</i>.
     */
    public final String userArn() {
        return userArn;
    }

    /**
     * <p>
     * A unique identifier for the user.
     * </p>
     * 
     * @return A unique identifier for the user.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The IAM role ARN that is associated with the user.
     * </p>
     * 
     * @return The IAM role ARN that is associated with the user.
     */
    public final String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * The timestamp at which the kdb user was created.
     * </p>
     * 
     * @return The timestamp at which the kdb user was created.
     */
    public final Instant createTimestamp() {
        return createTimestamp;
    }

    /**
     * <p>
     * The timestamp at which the kdb user was updated.
     * </p>
     * 
     * @return The timestamp at which the kdb user was updated.
     */
    public final Instant updateTimestamp() {
        return updateTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updateTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxUser)) {
            return false;
        }
        KxUser other = (KxUser) obj;
        return Objects.equals(userArn(), other.userArn()) && Objects.equals(userName(), other.userName())
                && Objects.equals(iamRole(), other.iamRole()) && Objects.equals(createTimestamp(), other.createTimestamp())
                && Objects.equals(updateTimestamp(), other.updateTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxUser").add("UserArn", userArn()).add("UserName", userName()).add("IamRole", iamRole())
                .add("CreateTimestamp", createTimestamp()).add("UpdateTimestamp", updateTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "userName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "iamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "createTimestamp":
            return Optional.ofNullable(clazz.cast(createTimestamp()));
        case "updateTimestamp":
            return Optional.ofNullable(clazz.cast(updateTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KxUser, T> g) {
        return obj -> g.apply((KxUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxUser> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs and how to use ARNs
         * in policies, see <a href="IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs and how to
         *        use ARNs in policies, see <a href="IAM/latest/UserGuide/reference_identifiers.html">IAM
         *        Identifiers</a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * A unique identifier for the user.
         * </p>
         * 
         * @param userName
         *        A unique identifier for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The IAM role ARN that is associated with the user.
         * </p>
         * 
         * @param iamRole
         *        The IAM role ARN that is associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * The timestamp at which the kdb user was created.
         * </p>
         * 
         * @param createTimestamp
         *        The timestamp at which the kdb user was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimestamp(Instant createTimestamp);

        /**
         * <p>
         * The timestamp at which the kdb user was updated.
         * </p>
         * 
         * @param updateTimestamp
         *        The timestamp at which the kdb user was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTimestamp(Instant updateTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String userArn;

        private String userName;

        private String iamRole;

        private Instant createTimestamp;

        private Instant updateTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KxUser model) {
            userArn(model.userArn);
            userName(model.userName);
            iamRole(model.iamRole);
            createTimestamp(model.createTimestamp);
            updateTimestamp(model.updateTimestamp);
        }

        public final String getUserArn() {
            return userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getIamRole() {
            return iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final Instant getCreateTimestamp() {
            return createTimestamp;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final Instant getUpdateTimestamp() {
            return updateTimestamp;
        }

        public final void setUpdateTimestamp(Instant updateTimestamp) {
            this.updateTimestamp = updateTimestamp;
        }

        @Override
        public final Builder updateTimestamp(Instant updateTimestamp) {
            this.updateTimestamp = updateTimestamp;
            return this;
        }

        @Override
        public KxUser build() {
            return new KxUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
