/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentsResponse extends EvsResponse implements
        ToCopyableBuilder<ListEnvironmentsResponse.Builder, ListEnvironmentsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnvironmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<EnvironmentSummary>> ENVIRONMENT_SUMMARIES_FIELD = SdkField
            .<List<EnvironmentSummary>> builder(MarshallingType.LIST)
            .memberName("environmentSummaries")
            .getter(getter(ListEnvironmentsResponse::environmentSummaries))
            .setter(setter(Builder::environmentSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ENVIRONMENT_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<EnvironmentSummary> environmentSummaries;

    private ListEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.environmentSummaries = builder.environmentSummaries;
    }

    /**
     * <p>
     * A unique pagination token for next page results. Make the call again using this token to retrieve the next page.
     * </p>
     * 
     * @return A unique pagination token for next page results. Make the call again using this token to retrieve the
     *         next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentSummaries() {
        return environmentSummaries != null && !(environmentSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of environments with summarized environment details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentSummaries} method.
     * </p>
     * 
     * @return A list of environments with summarized environment details.
     */
    public final List<EnvironmentSummary> environmentSummaries() {
        return environmentSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentSummaries() ? environmentSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsResponse)) {
            return false;
        }
        ListEnvironmentsResponse other = (ListEnvironmentsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasEnvironmentSummaries() == other.hasEnvironmentSummaries()
                && Objects.equals(environmentSummaries(), other.environmentSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentsResponse").add("NextToken", nextToken())
                .add("EnvironmentSummaries", hasEnvironmentSummaries() ? environmentSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "environmentSummaries":
            return Optional.ofNullable(clazz.cast(environmentSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("environmentSummaries", ENVIRONMENT_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEnvironmentsResponse> {
        /**
         * <p>
         * A unique pagination token for next page results. Make the call again using this token to retrieve the next
         * page.
         * </p>
         * 
         * @param nextToken
         *        A unique pagination token for next page results. Make the call again using this token to retrieve the
         *        next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of environments with summarized environment details.
         * </p>
         * 
         * @param environmentSummaries
         *        A list of environments with summarized environment details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentSummaries(Collection<EnvironmentSummary> environmentSummaries);

        /**
         * <p>
         * A list of environments with summarized environment details.
         * </p>
         * 
         * @param environmentSummaries
         *        A list of environments with summarized environment details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentSummaries(EnvironmentSummary... environmentSummaries);

        /**
         * <p>
         * A list of environments with summarized environment details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.evs.model.EnvironmentSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.evs.model.EnvironmentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.evs.model.EnvironmentSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentSummaries(List<EnvironmentSummary>)}.
         * 
         * @param environmentSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.evs.model.EnvironmentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentSummaries(java.util.Collection<EnvironmentSummary>)
         */
        Builder environmentSummaries(Consumer<EnvironmentSummary.Builder>... environmentSummaries);
    }

    static final class BuilderImpl extends EvsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<EnvironmentSummary> environmentSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsResponse model) {
            super(model);
            nextToken(model.nextToken);
            environmentSummaries(model.environmentSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EnvironmentSummary.Builder> getEnvironmentSummaries() {
            List<EnvironmentSummary.Builder> result = EnvironmentSummaryListCopier.copyToBuilder(this.environmentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentSummaries(Collection<EnvironmentSummary.BuilderImpl> environmentSummaries) {
            this.environmentSummaries = EnvironmentSummaryListCopier.copyFromBuilder(environmentSummaries);
        }

        @Override
        public final Builder environmentSummaries(Collection<EnvironmentSummary> environmentSummaries) {
            this.environmentSummaries = EnvironmentSummaryListCopier.copy(environmentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentSummaries(EnvironmentSummary... environmentSummaries) {
            environmentSummaries(Arrays.asList(environmentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentSummaries(Consumer<EnvironmentSummary.Builder>... environmentSummaries) {
            environmentSummaries(Stream.of(environmentSummaries).map(c -> EnvironmentSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEnvironmentsResponse build() {
            return new ListEnvironmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
