/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentVlansResponse extends EvsResponse implements
        ToCopyableBuilder<ListEnvironmentVlansResponse.Builder, ListEnvironmentVlansResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnvironmentVlansResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Vlan>> ENVIRONMENT_VLANS_FIELD = SdkField
            .<List<Vlan>> builder(MarshallingType.LIST)
            .memberName("environmentVlans")
            .getter(getter(ListEnvironmentVlansResponse::environmentVlans))
            .setter(setter(Builder::environmentVlans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVlans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Vlan> builder(MarshallingType.SDK_POJO)
                                            .constructor(Vlan::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ENVIRONMENT_VLANS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<Vlan> environmentVlans;

    private ListEnvironmentVlansResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.environmentVlans = builder.environmentVlans;
    }

    /**
     * <p>
     * A unique pagination token for next page results. Make the call again using this token to retrieve the next page.
     * </p>
     * 
     * @return A unique pagination token for next page results. Make the call again using this token to retrieve the
     *         next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVlans property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVlans() {
        return environmentVlans != null && !(environmentVlans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VLANs that are associated with the specified environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVlans} method.
     * </p>
     * 
     * @return A list of VLANs that are associated with the specified environment.
     */
    public final List<Vlan> environmentVlans() {
        return environmentVlans;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVlans() ? environmentVlans() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentVlansResponse)) {
            return false;
        }
        ListEnvironmentVlansResponse other = (ListEnvironmentVlansResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasEnvironmentVlans() == other.hasEnvironmentVlans()
                && Objects.equals(environmentVlans(), other.environmentVlans());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentVlansResponse").add("NextToken", nextToken())
                .add("EnvironmentVlans", hasEnvironmentVlans() ? environmentVlans() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "environmentVlans":
            return Optional.ofNullable(clazz.cast(environmentVlans()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("environmentVlans", ENVIRONMENT_VLANS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentVlansResponse, T> g) {
        return obj -> g.apply((ListEnvironmentVlansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEnvironmentVlansResponse> {
        /**
         * <p>
         * A unique pagination token for next page results. Make the call again using this token to retrieve the next
         * page.
         * </p>
         * 
         * @param nextToken
         *        A unique pagination token for next page results. Make the call again using this token to retrieve the
         *        next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of VLANs that are associated with the specified environment.
         * </p>
         * 
         * @param environmentVlans
         *        A list of VLANs that are associated with the specified environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVlans(Collection<Vlan> environmentVlans);

        /**
         * <p>
         * A list of VLANs that are associated with the specified environment.
         * </p>
         * 
         * @param environmentVlans
         *        A list of VLANs that are associated with the specified environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVlans(Vlan... environmentVlans);

        /**
         * <p>
         * A list of VLANs that are associated with the specified environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.evs.model.Vlan.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.evs.model.Vlan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.evs.model.Vlan.Builder#build()}
         * is called immediately and its result is passed to {@link #environmentVlans(List<Vlan>)}.
         * 
         * @param environmentVlans
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.evs.model.Vlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentVlans(java.util.Collection<Vlan>)
         */
        Builder environmentVlans(Consumer<Vlan.Builder>... environmentVlans);
    }

    static final class BuilderImpl extends EvsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Vlan> environmentVlans = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentVlansResponse model) {
            super(model);
            nextToken(model.nextToken);
            environmentVlans(model.environmentVlans);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Vlan.Builder> getEnvironmentVlans() {
            List<Vlan.Builder> result = VlanListCopier.copyToBuilder(this.environmentVlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentVlans(Collection<Vlan.BuilderImpl> environmentVlans) {
            this.environmentVlans = VlanListCopier.copyFromBuilder(environmentVlans);
        }

        @Override
        public final Builder environmentVlans(Collection<Vlan> environmentVlans) {
            this.environmentVlans = VlanListCopier.copy(environmentVlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVlans(Vlan... environmentVlans) {
            environmentVlans(Arrays.asList(environmentVlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVlans(Consumer<Vlan.Builder>... environmentVlans) {
            environmentVlans(Stream.of(environmentVlans).map(c -> Vlan.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEnvironmentVlansResponse build() {
            return new ListEnvironmentVlansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
