/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of environments with summarized environment details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentSummary.Builder, EnvironmentSummary> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(EnvironmentSummary::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(EnvironmentSummary::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<String> VCF_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vcfVersion").getter(getter(EnvironmentSummary::vcfVersionAsString)).setter(setter(Builder::vcfVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcfVersion").build()).build();

    private static final SdkField<String> ENVIRONMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentStatus").getter(getter(EnvironmentSummary::environmentStatusAsString))
            .setter(setter(Builder::environmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentStatus").build()).build();

    private static final SdkField<String> ENVIRONMENT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentState").getter(getter(EnvironmentSummary::environmentStateAsString))
            .setter(setter(Builder::environmentState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentState").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(EnvironmentSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(EnvironmentSummary::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentArn").getter(getter(EnvironmentSummary::environmentArn))
            .setter(setter(Builder::environmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            ENVIRONMENT_NAME_FIELD, VCF_VERSION_FIELD, ENVIRONMENT_STATUS_FIELD, ENVIRONMENT_STATE_FIELD, CREATED_AT_FIELD,
            MODIFIED_AT_FIELD, ENVIRONMENT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String environmentId;

    private final String environmentName;

    private final String vcfVersion;

    private final String environmentStatus;

    private final String environmentState;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String environmentArn;

    private EnvironmentSummary(BuilderImpl builder) {
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.vcfVersion = builder.vcfVersion;
        this.environmentStatus = builder.environmentStatus;
        this.environmentState = builder.environmentState;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.environmentArn = builder.environmentArn;
    }

    /**
     * <p>
     * A unique ID for the environment.
     * </p>
     * 
     * @return A unique ID for the environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The VCF version of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vcfVersion} will
     * return {@link VcfVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vcfVersionAsString}.
     * </p>
     * 
     * @return The VCF version of the environment.
     * @see VcfVersion
     */
    public final VcfVersion vcfVersion() {
        return VcfVersion.fromValue(vcfVersion);
    }

    /**
     * <p>
     * The VCF version of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vcfVersion} will
     * return {@link VcfVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vcfVersionAsString}.
     * </p>
     * 
     * @return The VCF version of the environment.
     * @see VcfVersion
     */
    public final String vcfVersionAsString() {
        return vcfVersion;
    }

    /**
     * <p>
     * Reports impaired functionality that stems from issues internal to the environment, such as impaired reachability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environmentStatus}
     * will return {@link CheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #environmentStatusAsString}.
     * </p>
     * 
     * @return Reports impaired functionality that stems from issues internal to the environment, such as impaired
     *         reachability.
     * @see CheckResult
     */
    public final CheckResult environmentStatus() {
        return CheckResult.fromValue(environmentStatus);
    }

    /**
     * <p>
     * Reports impaired functionality that stems from issues internal to the environment, such as impaired reachability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environmentStatus}
     * will return {@link CheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #environmentStatusAsString}.
     * </p>
     * 
     * @return Reports impaired functionality that stems from issues internal to the environment, such as impaired
     *         reachability.
     * @see CheckResult
     */
    public final String environmentStatusAsString() {
        return environmentStatus;
    }

    /**
     * <p>
     * The state of an environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environmentState}
     * will return {@link EnvironmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #environmentStateAsString}.
     * </p>
     * 
     * @return The state of an environment.
     * @see EnvironmentState
     */
    public final EnvironmentState environmentState() {
        return EnvironmentState.fromValue(environmentState);
    }

    /**
     * <p>
     * The state of an environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environmentState}
     * will return {@link EnvironmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #environmentStateAsString}.
     * </p>
     * 
     * @return The state of an environment.
     * @see EnvironmentState
     */
    public final String environmentStateAsString() {
        return environmentState;
    }

    /**
     * <p>
     * The date and time that the environment was created.
     * </p>
     * 
     * @return The date and time that the environment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time that the environment was modified.
     * </p>
     * 
     * @return The date and time that the environment was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the environment.
     */
    public final String environmentArn() {
        return environmentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(vcfVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(environmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(environmentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(environmentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentSummary)) {
            return false;
        }
        EnvironmentSummary other = (EnvironmentSummary) obj;
        return Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(vcfVersionAsString(), other.vcfVersionAsString())
                && Objects.equals(environmentStatusAsString(), other.environmentStatusAsString())
                && Objects.equals(environmentStateAsString(), other.environmentStateAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(environmentArn(), other.environmentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentSummary").add("EnvironmentId", environmentId())
                .add("EnvironmentName", environmentName()).add("VcfVersion", vcfVersionAsString())
                .add("EnvironmentStatus", environmentStatusAsString()).add("EnvironmentState", environmentStateAsString())
                .add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt()).add("EnvironmentArn", environmentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "vcfVersion":
            return Optional.ofNullable(clazz.cast(vcfVersionAsString()));
        case "environmentStatus":
            return Optional.ofNullable(clazz.cast(environmentStatusAsString()));
        case "environmentState":
            return Optional.ofNullable(clazz.cast(environmentStateAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "environmentArn":
            return Optional.ofNullable(clazz.cast(environmentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("vcfVersion", VCF_VERSION_FIELD);
        map.put("environmentStatus", ENVIRONMENT_STATUS_FIELD);
        map.put("environmentState", ENVIRONMENT_STATE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("environmentArn", ENVIRONMENT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentSummary, T> g) {
        return obj -> g.apply((EnvironmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentSummary> {
        /**
         * <p>
         * A unique ID for the environment.
         * </p>
         * 
         * @param environmentId
         *        A unique ID for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param environmentName
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The VCF version of the environment.
         * </p>
         * 
         * @param vcfVersion
         *        The VCF version of the environment.
         * @see VcfVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VcfVersion
         */
        Builder vcfVersion(String vcfVersion);

        /**
         * <p>
         * The VCF version of the environment.
         * </p>
         * 
         * @param vcfVersion
         *        The VCF version of the environment.
         * @see VcfVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VcfVersion
         */
        Builder vcfVersion(VcfVersion vcfVersion);

        /**
         * <p>
         * Reports impaired functionality that stems from issues internal to the environment, such as impaired
         * reachability.
         * </p>
         * 
         * @param environmentStatus
         *        Reports impaired functionality that stems from issues internal to the environment, such as impaired
         *        reachability.
         * @see CheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckResult
         */
        Builder environmentStatus(String environmentStatus);

        /**
         * <p>
         * Reports impaired functionality that stems from issues internal to the environment, such as impaired
         * reachability.
         * </p>
         * 
         * @param environmentStatus
         *        Reports impaired functionality that stems from issues internal to the environment, such as impaired
         *        reachability.
         * @see CheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckResult
         */
        Builder environmentStatus(CheckResult environmentStatus);

        /**
         * <p>
         * The state of an environment.
         * </p>
         * 
         * @param environmentState
         *        The state of an environment.
         * @see EnvironmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentState
         */
        Builder environmentState(String environmentState);

        /**
         * <p>
         * The state of an environment.
         * </p>
         * 
         * @param environmentState
         *        The state of an environment.
         * @see EnvironmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentState
         */
        Builder environmentState(EnvironmentState environmentState);

        /**
         * <p>
         * The date and time that the environment was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the environment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time that the environment was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The date and time that the environment was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the environment.
         * </p>
         * 
         * @param environmentArn
         *        The Amazon Resource Name (ARN) that is associated with the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentArn(String environmentArn);
    }

    static final class BuilderImpl implements Builder {
        private String environmentId;

        private String environmentName;

        private String vcfVersion;

        private String environmentStatus;

        private String environmentState;

        private Instant createdAt;

        private Instant modifiedAt;

        private String environmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentSummary model) {
            environmentId(model.environmentId);
            environmentName(model.environmentName);
            vcfVersion(model.vcfVersion);
            environmentStatus(model.environmentStatus);
            environmentState(model.environmentState);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            environmentArn(model.environmentArn);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getVcfVersion() {
            return vcfVersion;
        }

        public final void setVcfVersion(String vcfVersion) {
            this.vcfVersion = vcfVersion;
        }

        @Override
        public final Builder vcfVersion(String vcfVersion) {
            this.vcfVersion = vcfVersion;
            return this;
        }

        @Override
        public final Builder vcfVersion(VcfVersion vcfVersion) {
            this.vcfVersion(vcfVersion == null ? null : vcfVersion.toString());
            return this;
        }

        public final String getEnvironmentStatus() {
            return environmentStatus;
        }

        public final void setEnvironmentStatus(String environmentStatus) {
            this.environmentStatus = environmentStatus;
        }

        @Override
        public final Builder environmentStatus(String environmentStatus) {
            this.environmentStatus = environmentStatus;
            return this;
        }

        @Override
        public final Builder environmentStatus(CheckResult environmentStatus) {
            this.environmentStatus(environmentStatus == null ? null : environmentStatus.toString());
            return this;
        }

        public final String getEnvironmentState() {
            return environmentState;
        }

        public final void setEnvironmentState(String environmentState) {
            this.environmentState = environmentState;
        }

        @Override
        public final Builder environmentState(String environmentState) {
            this.environmentState = environmentState;
            return this;
        }

        @Override
        public final Builder environmentState(EnvironmentState environmentState) {
            this.environmentState(environmentState == null ? null : environmentState.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getEnvironmentArn() {
            return environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        @Override
        public EnvironmentSummary build() {
            return new EnvironmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
