/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEnvironmentHostResponse extends EvsResponse implements
        ToCopyableBuilder<DeleteEnvironmentHostResponse.Builder, DeleteEnvironmentHostResponse> {
    private static final SdkField<EnvironmentSummary> ENVIRONMENT_SUMMARY_FIELD = SdkField
            .<EnvironmentSummary> builder(MarshallingType.SDK_POJO).memberName("environmentSummary")
            .getter(getter(DeleteEnvironmentHostResponse::environmentSummary)).setter(setter(Builder::environmentSummary))
            .constructor(EnvironmentSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentSummary").build())
            .build();

    private static final SdkField<Host> HOST_FIELD = SdkField.<Host> builder(MarshallingType.SDK_POJO).memberName("host")
            .getter(getter(DeleteEnvironmentHostResponse::host)).setter(setter(Builder::host)).constructor(Host::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_SUMMARY_FIELD,
            HOST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EnvironmentSummary environmentSummary;

    private final Host host;

    private DeleteEnvironmentHostResponse(BuilderImpl builder) {
        super(builder);
        this.environmentSummary = builder.environmentSummary;
        this.host = builder.host;
    }

    /**
     * <p>
     * A summary of the environment that the host was deleted from.
     * </p>
     * 
     * @return A summary of the environment that the host was deleted from.
     */
    public final EnvironmentSummary environmentSummary() {
        return environmentSummary;
    }

    /**
     * <p>
     * A description of the deleted host.
     * </p>
     * 
     * @return A description of the deleted host.
     */
    public final Host host() {
        return host;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentSummary());
        hashCode = 31 * hashCode + Objects.hashCode(host());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEnvironmentHostResponse)) {
            return false;
        }
        DeleteEnvironmentHostResponse other = (DeleteEnvironmentHostResponse) obj;
        return Objects.equals(environmentSummary(), other.environmentSummary()) && Objects.equals(host(), other.host());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteEnvironmentHostResponse").add("EnvironmentSummary", environmentSummary())
                .add("Host", host()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentSummary":
            return Optional.ofNullable(clazz.cast(environmentSummary()));
        case "host":
            return Optional.ofNullable(clazz.cast(host()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environmentSummary", ENVIRONMENT_SUMMARY_FIELD);
        map.put("host", HOST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteEnvironmentHostResponse, T> g) {
        return obj -> g.apply((DeleteEnvironmentHostResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteEnvironmentHostResponse> {
        /**
         * <p>
         * A summary of the environment that the host was deleted from.
         * </p>
         * 
         * @param environmentSummary
         *        A summary of the environment that the host was deleted from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentSummary(EnvironmentSummary environmentSummary);

        /**
         * <p>
         * A summary of the environment that the host was deleted from.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentSummary.Builder} avoiding the
         * need to create one manually via {@link EnvironmentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #environmentSummary(EnvironmentSummary)}.
         * 
         * @param environmentSummary
         *        a consumer that will call methods on {@link EnvironmentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentSummary(EnvironmentSummary)
         */
        default Builder environmentSummary(Consumer<EnvironmentSummary.Builder> environmentSummary) {
            return environmentSummary(EnvironmentSummary.builder().applyMutation(environmentSummary).build());
        }

        /**
         * <p>
         * A description of the deleted host.
         * </p>
         * 
         * @param host
         *        A description of the deleted host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(Host host);

        /**
         * <p>
         * A description of the deleted host.
         * </p>
         * This is a convenience method that creates an instance of the {@link Host.Builder} avoiding the need to create
         * one manually via {@link Host#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Host.Builder#build()} is called immediately and its result is
         * passed to {@link #host(Host)}.
         * 
         * @param host
         *        a consumer that will call methods on {@link Host.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #host(Host)
         */
        default Builder host(Consumer<Host.Builder> host) {
            return host(Host.builder().applyMutation(host).build());
        }
    }

    static final class BuilderImpl extends EvsResponse.BuilderImpl implements Builder {
        private EnvironmentSummary environmentSummary;

        private Host host;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEnvironmentHostResponse model) {
            super(model);
            environmentSummary(model.environmentSummary);
            host(model.host);
        }

        public final EnvironmentSummary.Builder getEnvironmentSummary() {
            return environmentSummary != null ? environmentSummary.toBuilder() : null;
        }

        public final void setEnvironmentSummary(EnvironmentSummary.BuilderImpl environmentSummary) {
            this.environmentSummary = environmentSummary != null ? environmentSummary.build() : null;
        }

        @Override
        public final Builder environmentSummary(EnvironmentSummary environmentSummary) {
            this.environmentSummary = environmentSummary;
            return this;
        }

        public final Host.Builder getHost() {
            return host != null ? host.toBuilder() : null;
        }

        public final void setHost(Host.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        @Override
        public final Builder host(Host host) {
            this.host = host;
            return this;
        }

        @Override
        public DeleteEnvironmentHostResponse build() {
            return new DeleteEnvironmentHostResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
