/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentRequest extends EvsRequest implements
        ToCopyableBuilder<CreateEnvironmentRequest.Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateEnvironmentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(CreateEnvironmentRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(CreateEnvironmentRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateEnvironmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ServiceAccessSecurityGroups> SERVICE_ACCESS_SECURITY_GROUPS_FIELD = SdkField
            .<ServiceAccessSecurityGroups> builder(MarshallingType.SDK_POJO)
            .memberName("serviceAccessSecurityGroups")
            .getter(getter(CreateEnvironmentRequest::serviceAccessSecurityGroups))
            .setter(setter(Builder::serviceAccessSecurityGroups))
            .constructor(ServiceAccessSecurityGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccessSecurityGroups")
                    .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpcId")
            .getter(getter(CreateEnvironmentRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final SdkField<String> SERVICE_ACCESS_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccessSubnetId").getter(getter(CreateEnvironmentRequest::serviceAccessSubnetId))
            .setter(setter(Builder::serviceAccessSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccessSubnetId").build())
            .build();

    private static final SdkField<String> VCF_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vcfVersion").getter(getter(CreateEnvironmentRequest::vcfVersionAsString))
            .setter(setter(Builder::vcfVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcfVersion").build()).build();

    private static final SdkField<Boolean> TERMS_ACCEPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("termsAccepted").getter(getter(CreateEnvironmentRequest::termsAccepted))
            .setter(setter(Builder::termsAccepted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termsAccepted").build()).build();

    private static final SdkField<List<LicenseInfo>> LICENSE_INFO_FIELD = SdkField
            .<List<LicenseInfo>> builder(MarshallingType.LIST)
            .memberName("licenseInfo")
            .getter(getter(CreateEnvironmentRequest::licenseInfo))
            .setter(setter(Builder::licenseInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InitialVlans> INITIAL_VLANS_FIELD = SdkField.<InitialVlans> builder(MarshallingType.SDK_POJO)
            .memberName("initialVlans").getter(getter(CreateEnvironmentRequest::initialVlans))
            .setter(setter(Builder::initialVlans)).constructor(InitialVlans::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialVlans").build()).build();

    private static final SdkField<List<HostInfoForCreate>> HOSTS_FIELD = SdkField
            .<List<HostInfoForCreate>> builder(MarshallingType.LIST)
            .memberName("hosts")
            .getter(getter(CreateEnvironmentRequest::hosts))
            .setter(setter(Builder::hosts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hosts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HostInfoForCreate> builder(MarshallingType.SDK_POJO)
                                            .constructor(HostInfoForCreate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConnectivityInfo> CONNECTIVITY_INFO_FIELD = SdkField
            .<ConnectivityInfo> builder(MarshallingType.SDK_POJO).memberName("connectivityInfo")
            .getter(getter(CreateEnvironmentRequest::connectivityInfo)).setter(setter(Builder::connectivityInfo))
            .constructor(ConnectivityInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivityInfo").build()).build();

    private static final SdkField<VcfHostnames> VCF_HOSTNAMES_FIELD = SdkField.<VcfHostnames> builder(MarshallingType.SDK_POJO)
            .memberName("vcfHostnames").getter(getter(CreateEnvironmentRequest::vcfHostnames))
            .setter(setter(Builder::vcfHostnames)).constructor(VcfHostnames::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcfHostnames").build()).build();

    private static final SdkField<String> SITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("siteId")
            .getter(getter(CreateEnvironmentRequest::siteId)).setter(setter(Builder::siteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("siteId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ENVIRONMENT_NAME_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, SERVICE_ACCESS_SECURITY_GROUPS_FIELD, VPC_ID_FIELD,
            SERVICE_ACCESS_SUBNET_ID_FIELD, VCF_VERSION_FIELD, TERMS_ACCEPTED_FIELD, LICENSE_INFO_FIELD, INITIAL_VLANS_FIELD,
            HOSTS_FIELD, CONNECTIVITY_INFO_FIELD, VCF_HOSTNAMES_FIELD, SITE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String environmentName;

    private final String kmsKeyId;

    private final Map<String, String> tags;

    private final ServiceAccessSecurityGroups serviceAccessSecurityGroups;

    private final String vpcId;

    private final String serviceAccessSubnetId;

    private final String vcfVersion;

    private final Boolean termsAccepted;

    private final List<LicenseInfo> licenseInfo;

    private final InitialVlans initialVlans;

    private final List<HostInfoForCreate> hosts;

    private final ConnectivityInfo connectivityInfo;

    private final VcfHostnames vcfHostnames;

    private final String siteId;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.environmentName = builder.environmentName;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.serviceAccessSecurityGroups = builder.serviceAccessSecurityGroups;
        this.vpcId = builder.vpcId;
        this.serviceAccessSubnetId = builder.serviceAccessSubnetId;
        this.vcfVersion = builder.vcfVersion;
        this.termsAccepted = builder.termsAccepted;
        this.licenseInfo = builder.licenseInfo;
        this.initialVlans = builder.initialVlans;
        this.hosts = builder.hosts;
        this.connectivityInfo = builder.connectivityInfo;
        this.vcfHostnames = builder.vcfHostnames;
        this.siteId = builder.siteId;
    }

    /**
     * <p>
     * <note>
     * <p>
     * This parameter is not used in Amazon EVS currently. If you supply input for this parameter, it will have no
     * effect.
     * </p>
     * </note>
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the environment creation
     * request. If you do not specify a client token, a randomly generated token is used for the request to ensure
     * idempotency.
     * </p>
     * </p>
     * 
     * @return <p>
     *         This parameter is not used in Amazon EVS currently. If you supply input for this parameter, it will have
     *         no effect.
     *         </p>
     *         </note>
     *         <p>
     *         A unique, case-sensitive identifier that you provide to ensure the idempotency of the environment
     *         creation request. If you do not specify a client token, a randomly generated token is used for the
     *         request to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name to give to your environment. The name can contain only alphanumeric characters (case-sensitive),
     * hyphens, and underscores. It must start with an alphanumeric character, and can't be longer than 100 characters.
     * The name must be unique within the Amazon Web Services Region and Amazon Web Services account that you're
     * creating the environment in.
     * </p>
     * 
     * @return The name to give to your environment. The name can contain only alphanumeric characters (case-sensitive),
     *         hyphens, and underscores. It must start with an alphanumeric character, and can't be longer than 100
     *         characters. The name must be unique within the Amazon Web Services Region and Amazon Web Services account
     *         that you're creating the environment in.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * A unique ID for the customer-managed KMS key that is used to encrypt the VCF credential pairs for SDDC Manager,
     * NSX Manager, and vCenter appliances. These credentials are stored in Amazon Web Services Secrets Manager.
     * </p>
     * 
     * @return A unique ID for the customer-managed KMS key that is used to encrypt the VCF credential pairs for SDDC
     *         Manager, NSX Manager, and vCenter appliances. These credentials are stored in Amazon Web Services Secrets
     *         Manager.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You
     * define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that assists with categorization and organization. Each tag consists of a key and an optional
     *         value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The security group that controls communication between the Amazon EVS control plane and VPC. The default security
     * group is used if a custom security group isn't specified.
     * </p>
     * <p>
     * The security group should allow access to the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * TCP/UDP access to the DNS servers
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTPS/SSH access to the host management VLAN subnet
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTPS/SSH access to the Management VM VLAN subnet
     * </p>
     * </li>
     * </ul>
     * <p>
     * You should avoid modifying the security group rules after deployment, as this can break the persistent connection
     * between the Amazon EVS control plane and VPC. This can cause future environment actions like adding or removing
     * hosts to fail.
     * </p>
     * 
     * @return The security group that controls communication between the Amazon EVS control plane and VPC. The default
     *         security group is used if a custom security group isn't specified.</p>
     *         <p>
     *         The security group should allow access to the following.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         TCP/UDP access to the DNS servers
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HTTPS/SSH access to the host management VLAN subnet
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HTTPS/SSH access to the Management VM VLAN subnet
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You should avoid modifying the security group rules after deployment, as this can break the persistent
     *         connection between the Amazon EVS control plane and VPC. This can cause future environment actions like
     *         adding or removing hosts to fail.
     */
    public final ServiceAccessSecurityGroups serviceAccessSecurityGroups() {
        return serviceAccessSecurityGroups;
    }

    /**
     * <p>
     * A unique ID for the VPC that the environment is deployed inside.
     * </p>
     * <p>
     * Amazon EVS requires that all VPC subnets exist in a single Availability Zone in a Region where the service is
     * available.
     * </p>
     * <p>
     * The VPC that you specify must have a valid DHCP option set with domain name, at least two DNS servers, and an NTP
     * server. These settings are used to configure your VCF appliances and hosts. The VPC cannot be used with any other
     * deployed Amazon EVS environment. Amazon EVS does not provide multi-VPC support for environments at this time.
     * </p>
     * <p>
     * Amazon EVS does not support the following Amazon Web Services networking options for NSX overlay connectivity:
     * cross-Region VPC peering, Amazon S3 gateway endpoints, or Amazon Web Services Direct Connect virtual private
     * gateway associations.
     * </p>
     * <note>
     * <p>
     * Ensure that you specify a VPC that is adequately sized to accommodate the {evws} subnets.
     * </p>
     * </note>
     * 
     * @return A unique ID for the VPC that the environment is deployed inside.</p>
     *         <p>
     *         Amazon EVS requires that all VPC subnets exist in a single Availability Zone in a Region where the
     *         service is available.
     *         </p>
     *         <p>
     *         The VPC that you specify must have a valid DHCP option set with domain name, at least two DNS servers,
     *         and an NTP server. These settings are used to configure your VCF appliances and hosts. The VPC cannot be
     *         used with any other deployed Amazon EVS environment. Amazon EVS does not provide multi-VPC support for
     *         environments at this time.
     *         </p>
     *         <p>
     *         Amazon EVS does not support the following Amazon Web Services networking options for NSX overlay
     *         connectivity: cross-Region VPC peering, Amazon S3 gateway endpoints, or Amazon Web Services Direct
     *         Connect virtual private gateway associations.
     *         </p>
     *         <note>
     *         <p>
     *         Ensure that you specify a VPC that is adequately sized to accommodate the {evws} subnets.
     *         </p>
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The subnet that is used to establish connectivity between the Amazon EVS control plane and VPC. Amazon EVS uses
     * this subnet to validate mandatory DNS records for your VCF appliances and hosts and create the environment.
     * </p>
     * 
     * @return The subnet that is used to establish connectivity between the Amazon EVS control plane and VPC. Amazon
     *         EVS uses this subnet to validate mandatory DNS records for your VCF appliances and hosts and create the
     *         environment.
     */
    public final String serviceAccessSubnetId() {
        return serviceAccessSubnetId;
    }

    /**
     * <p>
     * The VCF version to use for the environment. Amazon EVS only supports VCF version 5.2.1 at this time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vcfVersion} will
     * return {@link VcfVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vcfVersionAsString}.
     * </p>
     * 
     * @return The VCF version to use for the environment. Amazon EVS only supports VCF version 5.2.1 at this time.
     * @see VcfVersion
     */
    public final VcfVersion vcfVersion() {
        return VcfVersion.fromValue(vcfVersion);
    }

    /**
     * <p>
     * The VCF version to use for the environment. Amazon EVS only supports VCF version 5.2.1 at this time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vcfVersion} will
     * return {@link VcfVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vcfVersionAsString}.
     * </p>
     * 
     * @return The VCF version to use for the environment. Amazon EVS only supports VCF version 5.2.1 at this time.
     * @see VcfVersion
     */
    public final String vcfVersionAsString() {
        return vcfVersion;
    }

    /**
     * <p>
     * Customer confirmation that the customer has purchased and will continue to maintain the required number of VCF
     * software licenses to cover all physical processor cores in the Amazon EVS environment. Information about your VCF
     * software in Amazon EVS will be shared with Broadcom to verify license compliance. Amazon EVS does not validate
     * license keys. To validate license keys, visit the Broadcom support portal.
     * </p>
     * 
     * @return Customer confirmation that the customer has purchased and will continue to maintain the required number
     *         of VCF software licenses to cover all physical processor cores in the Amazon EVS environment. Information
     *         about your VCF software in Amazon EVS will be shared with Broadcom to verify license compliance. Amazon
     *         EVS does not validate license keys. To validate license keys, visit the Broadcom support portal.
     */
    public final Boolean termsAccepted() {
        return termsAccepted;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseInfo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLicenseInfo() {
        return licenseInfo != null && !(licenseInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The license information that Amazon EVS requires to create an environment. Amazon EVS requires two license keys:
     * a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of 256 cores. The vSAN
     * license key must provide at least 110 TiB of vSAN capacity.
     * </p>
     * <p>
     * VCF licenses can be used for only one Amazon EVS environment. Amazon EVS does not support reuse of VCF licenses
     * for multiple environments.
     * </p>
     * <p>
     * VCF license information can be retrieved from the Broadcom portal.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseInfo} method.
     * </p>
     * 
     * @return The license information that Amazon EVS requires to create an environment. Amazon EVS requires two
     *         license keys: a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of 256
     *         cores. The vSAN license key must provide at least 110 TiB of vSAN capacity.</p>
     *         <p>
     *         VCF licenses can be used for only one Amazon EVS environment. Amazon EVS does not support reuse of VCF
     *         licenses for multiple environments.
     *         </p>
     *         <p>
     *         VCF license information can be retrieved from the Broadcom portal.
     */
    public final List<LicenseInfo> licenseInfo() {
        return licenseInfo;
    }

    /**
     * <p>
     * The initial VLAN subnets for the Amazon EVS environment.
     * </p>
     * <note>
     * <p>
     * For each Amazon EVS VLAN subnet, you must specify a non-overlapping CIDR block. Amazon EVS VLAN subnets have a
     * minimum CIDR block size of /28 and a maximum size of /24.
     * </p>
     * </note>
     * 
     * @return The initial VLAN subnets for the Amazon EVS environment.</p> <note>
     *         <p>
     *         For each Amazon EVS VLAN subnet, you must specify a non-overlapping CIDR block. Amazon EVS VLAN subnets
     *         have a minimum CIDR block size of /28 and a maximum size of /24.
     *         </p>
     */
    public final InitialVlans initialVlans() {
        return initialVlans;
    }

    /**
     * For responses, this returns true if the service returned a value for the Hosts property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasHosts() {
        return hosts != null && !(hosts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ESXi hosts to add to the environment. Amazon EVS requires that you provide details for a minimum of 4 hosts
     * during environment creation.
     * </p>
     * <p>
     * For each host, you must provide the desired hostname, EC2 SSH keypair name, and EC2 instance type. Optionally,
     * you can also provide a partition or cluster placement group to use, or use Amazon EC2 Dedicated Hosts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHosts} method.
     * </p>
     * 
     * @return The ESXi hosts to add to the environment. Amazon EVS requires that you provide details for a minimum of 4
     *         hosts during environment creation.</p>
     *         <p>
     *         For each host, you must provide the desired hostname, EC2 SSH keypair name, and EC2 instance type.
     *         Optionally, you can also provide a partition or cluster placement group to use, or use Amazon EC2
     *         Dedicated Hosts.
     */
    public final List<HostInfoForCreate> hosts() {
        return hosts;
    }

    /**
     * <p>
     * The connectivity configuration for the environment. Amazon EVS requires that you specify two route server peer
     * IDs. During environment creation, the route server endpoints peer with the NSX edges over the NSX uplink subnet,
     * providing BGP-based dynamic routing for overlay networks.
     * </p>
     * 
     * @return The connectivity configuration for the environment. Amazon EVS requires that you specify two route server
     *         peer IDs. During environment creation, the route server endpoints peer with the NSX edges over the NSX
     *         uplink subnet, providing BGP-based dynamic routing for overlay networks.
     */
    public final ConnectivityInfo connectivityInfo() {
        return connectivityInfo;
    }

    /**
     * <p>
     * The DNS hostnames for the virtual machines that host the VCF management appliances. Amazon EVS requires that you
     * provide DNS hostnames for the following appliances: vCenter, NSX Manager, SDDC Manager, and Cloud Builder.
     * </p>
     * 
     * @return The DNS hostnames for the virtual machines that host the VCF management appliances. Amazon EVS requires
     *         that you provide DNS hostnames for the following appliances: vCenter, NSX Manager, SDDC Manager, and
     *         Cloud Builder.
     */
    public final VcfHostnames vcfHostnames() {
        return vcfHostnames;
    }

    /**
     * <p>
     * The Broadcom Site ID that is allocated to you as part of your electronic software delivery. This ID allows
     * customer access to the Broadcom portal, and is provided to you by Broadcom at the close of your software contract
     * or contract renewal. Amazon EVS uses the Broadcom Site ID that you provide to meet Broadcom VCF license usage
     * reporting requirements for Amazon EVS.
     * </p>
     * 
     * @return The Broadcom Site ID that is allocated to you as part of your electronic software delivery. This ID
     *         allows customer access to the Broadcom portal, and is provided to you by Broadcom at the close of your
     *         software contract or contract renewal. Amazon EVS uses the Broadcom Site ID that you provide to meet
     *         Broadcom VCF license usage reporting requirements for Amazon EVS.
     */
    public final String siteId() {
        return siteId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vcfVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(termsAccepted());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseInfo() ? licenseInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(initialVlans());
        hashCode = 31 * hashCode + Objects.hashCode(hasHosts() ? hosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectivityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(vcfHostnames());
        hashCode = 31 * hashCode + Objects.hashCode(siteId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(serviceAccessSecurityGroups(), other.serviceAccessSecurityGroups())
                && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(serviceAccessSubnetId(), other.serviceAccessSubnetId())
                && Objects.equals(vcfVersionAsString(), other.vcfVersionAsString())
                && Objects.equals(termsAccepted(), other.termsAccepted()) && hasLicenseInfo() == other.hasLicenseInfo()
                && Objects.equals(licenseInfo(), other.licenseInfo()) && Objects.equals(initialVlans(), other.initialVlans())
                && hasHosts() == other.hasHosts() && Objects.equals(hosts(), other.hosts())
                && Objects.equals(connectivityInfo(), other.connectivityInfo())
                && Objects.equals(vcfHostnames(), other.vcfHostnames()) && Objects.equals(siteId(), other.siteId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentRequest").add("ClientToken", clientToken())
                .add("EnvironmentName", environmentName()).add("KmsKeyId", kmsKeyId()).add("Tags", hasTags() ? tags() : null)
                .add("ServiceAccessSecurityGroups", serviceAccessSecurityGroups()).add("VpcId", vpcId())
                .add("ServiceAccessSubnetId", serviceAccessSubnetId()).add("VcfVersion", vcfVersionAsString())
                .add("TermsAccepted", termsAccepted()).add("LicenseInfo", hasLicenseInfo() ? licenseInfo() : null)
                .add("InitialVlans", initialVlans()).add("Hosts", hasHosts() ? hosts() : null)
                .add("ConnectivityInfo", connectivityInfo()).add("VcfHostnames", vcfHostnames()).add("SiteId", siteId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "serviceAccessSecurityGroups":
            return Optional.ofNullable(clazz.cast(serviceAccessSecurityGroups()));
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "serviceAccessSubnetId":
            return Optional.ofNullable(clazz.cast(serviceAccessSubnetId()));
        case "vcfVersion":
            return Optional.ofNullable(clazz.cast(vcfVersionAsString()));
        case "termsAccepted":
            return Optional.ofNullable(clazz.cast(termsAccepted()));
        case "licenseInfo":
            return Optional.ofNullable(clazz.cast(licenseInfo()));
        case "initialVlans":
            return Optional.ofNullable(clazz.cast(initialVlans()));
        case "hosts":
            return Optional.ofNullable(clazz.cast(hosts()));
        case "connectivityInfo":
            return Optional.ofNullable(clazz.cast(connectivityInfo()));
        case "vcfHostnames":
            return Optional.ofNullable(clazz.cast(vcfHostnames()));
        case "siteId":
            return Optional.ofNullable(clazz.cast(siteId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("serviceAccessSecurityGroups", SERVICE_ACCESS_SECURITY_GROUPS_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        map.put("serviceAccessSubnetId", SERVICE_ACCESS_SUBNET_ID_FIELD);
        map.put("vcfVersion", VCF_VERSION_FIELD);
        map.put("termsAccepted", TERMS_ACCEPTED_FIELD);
        map.put("licenseInfo", LICENSE_INFO_FIELD);
        map.put("initialVlans", INITIAL_VLANS_FIELD);
        map.put("hosts", HOSTS_FIELD);
        map.put("connectivityInfo", CONNECTIVITY_INFO_FIELD);
        map.put("vcfHostnames", VCF_HOSTNAMES_FIELD);
        map.put("siteId", SITE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentRequest> {
        /**
         * <p>
         * <note>
         * <p>
         * This parameter is not used in Amazon EVS currently. If you supply input for this parameter, it will have no
         * effect.
         * </p>
         * </note>
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the environment creation
         * request. If you do not specify a client token, a randomly generated token is used for the request to ensure
         * idempotency.
         * </p>
         * </p>
         * 
         * @param clientToken
         *        <p>
         *        This parameter is not used in Amazon EVS currently. If you supply input for this parameter, it will
         *        have no effect.
         *        </p>
         *        </note>
         *        <p>
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the environment
         *        creation request. If you do not specify a client token, a randomly generated token is used for the
         *        request to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name to give to your environment. The name can contain only alphanumeric characters (case-sensitive),
         * hyphens, and underscores. It must start with an alphanumeric character, and can't be longer than 100
         * characters. The name must be unique within the Amazon Web Services Region and Amazon Web Services account
         * that you're creating the environment in.
         * </p>
         * 
         * @param environmentName
         *        The name to give to your environment. The name can contain only alphanumeric characters
         *        (case-sensitive), hyphens, and underscores. It must start with an alphanumeric character, and can't be
         *        longer than 100 characters. The name must be unique within the Amazon Web Services Region and Amazon
         *        Web Services account that you're creating the environment in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * A unique ID for the customer-managed KMS key that is used to encrypt the VCF credential pairs for SDDC
         * Manager, NSX Manager, and vCenter appliances. These credentials are stored in Amazon Web Services Secrets
         * Manager.
         * </p>
         * 
         * @param kmsKeyId
         *        A unique ID for the customer-managed KMS key that is used to encrypt the VCF credential pairs for SDDC
         *        Manager, NSX Manager, and vCenter appliances. These credentials are stored in Amazon Web Services
         *        Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value.
         * You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        Metadata that assists with categorization and organization. Each tag consists of a key and an optional
         *        value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The security group that controls communication between the Amazon EVS control plane and VPC. The default
         * security group is used if a custom security group isn't specified.
         * </p>
         * <p>
         * The security group should allow access to the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * TCP/UDP access to the DNS servers
         * </p>
         * </li>
         * <li>
         * <p>
         * HTTPS/SSH access to the host management VLAN subnet
         * </p>
         * </li>
         * <li>
         * <p>
         * HTTPS/SSH access to the Management VM VLAN subnet
         * </p>
         * </li>
         * </ul>
         * <p>
         * You should avoid modifying the security group rules after deployment, as this can break the persistent
         * connection between the Amazon EVS control plane and VPC. This can cause future environment actions like
         * adding or removing hosts to fail.
         * </p>
         * 
         * @param serviceAccessSecurityGroups
         *        The security group that controls communication between the Amazon EVS control plane and VPC. The
         *        default security group is used if a custom security group isn't specified.</p>
         *        <p>
         *        The security group should allow access to the following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        TCP/UDP access to the DNS servers
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HTTPS/SSH access to the host management VLAN subnet
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HTTPS/SSH access to the Management VM VLAN subnet
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You should avoid modifying the security group rules after deployment, as this can break the persistent
         *        connection between the Amazon EVS control plane and VPC. This can cause future environment actions
         *        like adding or removing hosts to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessSecurityGroups(ServiceAccessSecurityGroups serviceAccessSecurityGroups);

        /**
         * <p>
         * The security group that controls communication between the Amazon EVS control plane and VPC. The default
         * security group is used if a custom security group isn't specified.
         * </p>
         * <p>
         * The security group should allow access to the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * TCP/UDP access to the DNS servers
         * </p>
         * </li>
         * <li>
         * <p>
         * HTTPS/SSH access to the host management VLAN subnet
         * </p>
         * </li>
         * <li>
         * <p>
         * HTTPS/SSH access to the Management VM VLAN subnet
         * </p>
         * </li>
         * </ul>
         * <p>
         * You should avoid modifying the security group rules after deployment, as this can break the persistent
         * connection between the Amazon EVS control plane and VPC. This can cause future environment actions like
         * adding or removing hosts to fail.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceAccessSecurityGroups.Builder}
         * avoiding the need to create one manually via {@link ServiceAccessSecurityGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceAccessSecurityGroups.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceAccessSecurityGroups(ServiceAccessSecurityGroups)}.
         * 
         * @param serviceAccessSecurityGroups
         *        a consumer that will call methods on {@link ServiceAccessSecurityGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceAccessSecurityGroups(ServiceAccessSecurityGroups)
         */
        default Builder serviceAccessSecurityGroups(Consumer<ServiceAccessSecurityGroups.Builder> serviceAccessSecurityGroups) {
            return serviceAccessSecurityGroups(ServiceAccessSecurityGroups.builder().applyMutation(serviceAccessSecurityGroups)
                    .build());
        }

        /**
         * <p>
         * A unique ID for the VPC that the environment is deployed inside.
         * </p>
         * <p>
         * Amazon EVS requires that all VPC subnets exist in a single Availability Zone in a Region where the service is
         * available.
         * </p>
         * <p>
         * The VPC that you specify must have a valid DHCP option set with domain name, at least two DNS servers, and an
         * NTP server. These settings are used to configure your VCF appliances and hosts. The VPC cannot be used with
         * any other deployed Amazon EVS environment. Amazon EVS does not provide multi-VPC support for environments at
         * this time.
         * </p>
         * <p>
         * Amazon EVS does not support the following Amazon Web Services networking options for NSX overlay
         * connectivity: cross-Region VPC peering, Amazon S3 gateway endpoints, or Amazon Web Services Direct Connect
         * virtual private gateway associations.
         * </p>
         * <note>
         * <p>
         * Ensure that you specify a VPC that is adequately sized to accommodate the {evws} subnets.
         * </p>
         * </note>
         * 
         * @param vpcId
         *        A unique ID for the VPC that the environment is deployed inside.</p>
         *        <p>
         *        Amazon EVS requires that all VPC subnets exist in a single Availability Zone in a Region where the
         *        service is available.
         *        </p>
         *        <p>
         *        The VPC that you specify must have a valid DHCP option set with domain name, at least two DNS servers,
         *        and an NTP server. These settings are used to configure your VCF appliances and hosts. The VPC cannot
         *        be used with any other deployed Amazon EVS environment. Amazon EVS does not provide multi-VPC support
         *        for environments at this time.
         *        </p>
         *        <p>
         *        Amazon EVS does not support the following Amazon Web Services networking options for NSX overlay
         *        connectivity: cross-Region VPC peering, Amazon S3 gateway endpoints, or Amazon Web Services Direct
         *        Connect virtual private gateway associations.
         *        </p>
         *        <note>
         *        <p>
         *        Ensure that you specify a VPC that is adequately sized to accommodate the {evws} subnets.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The subnet that is used to establish connectivity between the Amazon EVS control plane and VPC. Amazon EVS
         * uses this subnet to validate mandatory DNS records for your VCF appliances and hosts and create the
         * environment.
         * </p>
         * 
         * @param serviceAccessSubnetId
         *        The subnet that is used to establish connectivity between the Amazon EVS control plane and VPC. Amazon
         *        EVS uses this subnet to validate mandatory DNS records for your VCF appliances and hosts and create
         *        the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessSubnetId(String serviceAccessSubnetId);

        /**
         * <p>
         * The VCF version to use for the environment. Amazon EVS only supports VCF version 5.2.1 at this time.
         * </p>
         * 
         * @param vcfVersion
         *        The VCF version to use for the environment. Amazon EVS only supports VCF version 5.2.1 at this time.
         * @see VcfVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VcfVersion
         */
        Builder vcfVersion(String vcfVersion);

        /**
         * <p>
         * The VCF version to use for the environment. Amazon EVS only supports VCF version 5.2.1 at this time.
         * </p>
         * 
         * @param vcfVersion
         *        The VCF version to use for the environment. Amazon EVS only supports VCF version 5.2.1 at this time.
         * @see VcfVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VcfVersion
         */
        Builder vcfVersion(VcfVersion vcfVersion);

        /**
         * <p>
         * Customer confirmation that the customer has purchased and will continue to maintain the required number of
         * VCF software licenses to cover all physical processor cores in the Amazon EVS environment. Information about
         * your VCF software in Amazon EVS will be shared with Broadcom to verify license compliance. Amazon EVS does
         * not validate license keys. To validate license keys, visit the Broadcom support portal.
         * </p>
         * 
         * @param termsAccepted
         *        Customer confirmation that the customer has purchased and will continue to maintain the required
         *        number of VCF software licenses to cover all physical processor cores in the Amazon EVS environment.
         *        Information about your VCF software in Amazon EVS will be shared with Broadcom to verify license
         *        compliance. Amazon EVS does not validate license keys. To validate license keys, visit the Broadcom
         *        support portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termsAccepted(Boolean termsAccepted);

        /**
         * <p>
         * The license information that Amazon EVS requires to create an environment. Amazon EVS requires two license
         * keys: a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of 256 cores. The
         * vSAN license key must provide at least 110 TiB of vSAN capacity.
         * </p>
         * <p>
         * VCF licenses can be used for only one Amazon EVS environment. Amazon EVS does not support reuse of VCF
         * licenses for multiple environments.
         * </p>
         * <p>
         * VCF license information can be retrieved from the Broadcom portal.
         * </p>
         * 
         * @param licenseInfo
         *        The license information that Amazon EVS requires to create an environment. Amazon EVS requires two
         *        license keys: a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of
         *        256 cores. The vSAN license key must provide at least 110 TiB of vSAN capacity.</p>
         *        <p>
         *        VCF licenses can be used for only one Amazon EVS environment. Amazon EVS does not support reuse of VCF
         *        licenses for multiple environments.
         *        </p>
         *        <p>
         *        VCF license information can be retrieved from the Broadcom portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseInfo(Collection<LicenseInfo> licenseInfo);

        /**
         * <p>
         * The license information that Amazon EVS requires to create an environment. Amazon EVS requires two license
         * keys: a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of 256 cores. The
         * vSAN license key must provide at least 110 TiB of vSAN capacity.
         * </p>
         * <p>
         * VCF licenses can be used for only one Amazon EVS environment. Amazon EVS does not support reuse of VCF
         * licenses for multiple environments.
         * </p>
         * <p>
         * VCF license information can be retrieved from the Broadcom portal.
         * </p>
         * 
         * @param licenseInfo
         *        The license information that Amazon EVS requires to create an environment. Amazon EVS requires two
         *        license keys: a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of
         *        256 cores. The vSAN license key must provide at least 110 TiB of vSAN capacity.</p>
         *        <p>
         *        VCF licenses can be used for only one Amazon EVS environment. Amazon EVS does not support reuse of VCF
         *        licenses for multiple environments.
         *        </p>
         *        <p>
         *        VCF license information can be retrieved from the Broadcom portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseInfo(LicenseInfo... licenseInfo);

        /**
         * <p>
         * The license information that Amazon EVS requires to create an environment. Amazon EVS requires two license
         * keys: a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of 256 cores. The
         * vSAN license key must provide at least 110 TiB of vSAN capacity.
         * </p>
         * <p>
         * VCF licenses can be used for only one Amazon EVS environment. Amazon EVS does not support reuse of VCF
         * licenses for multiple environments.
         * </p>
         * <p>
         * VCF license information can be retrieved from the Broadcom portal.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.evs.model.LicenseInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.evs.model.LicenseInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.evs.model.LicenseInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #licenseInfo(List<LicenseInfo>)}.
         * 
         * @param licenseInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.evs.model.LicenseInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseInfo(java.util.Collection<LicenseInfo>)
         */
        Builder licenseInfo(Consumer<LicenseInfo.Builder>... licenseInfo);

        /**
         * <p>
         * The initial VLAN subnets for the Amazon EVS environment.
         * </p>
         * <note>
         * <p>
         * For each Amazon EVS VLAN subnet, you must specify a non-overlapping CIDR block. Amazon EVS VLAN subnets have
         * a minimum CIDR block size of /28 and a maximum size of /24.
         * </p>
         * </note>
         * 
         * @param initialVlans
         *        The initial VLAN subnets for the Amazon EVS environment.</p> <note>
         *        <p>
         *        For each Amazon EVS VLAN subnet, you must specify a non-overlapping CIDR block. Amazon EVS VLAN
         *        subnets have a minimum CIDR block size of /28 and a maximum size of /24.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialVlans(InitialVlans initialVlans);

        /**
         * <p>
         * The initial VLAN subnets for the Amazon EVS environment.
         * </p>
         * <note>
         * <p>
         * For each Amazon EVS VLAN subnet, you must specify a non-overlapping CIDR block. Amazon EVS VLAN subnets have
         * a minimum CIDR block size of /28 and a maximum size of /24.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link InitialVlans.Builder} avoiding
         * the need to create one manually via {@link InitialVlans#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialVlans.Builder#build()} is called immediately and its
         * result is passed to {@link #initialVlans(InitialVlans)}.
         * 
         * @param initialVlans
         *        a consumer that will call methods on {@link InitialVlans.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialVlans(InitialVlans)
         */
        default Builder initialVlans(Consumer<InitialVlans.Builder> initialVlans) {
            return initialVlans(InitialVlans.builder().applyMutation(initialVlans).build());
        }

        /**
         * <p>
         * The ESXi hosts to add to the environment. Amazon EVS requires that you provide details for a minimum of 4
         * hosts during environment creation.
         * </p>
         * <p>
         * For each host, you must provide the desired hostname, EC2 SSH keypair name, and EC2 instance type.
         * Optionally, you can also provide a partition or cluster placement group to use, or use Amazon EC2 Dedicated
         * Hosts.
         * </p>
         * 
         * @param hosts
         *        The ESXi hosts to add to the environment. Amazon EVS requires that you provide details for a minimum
         *        of 4 hosts during environment creation.</p>
         *        <p>
         *        For each host, you must provide the desired hostname, EC2 SSH keypair name, and EC2 instance type.
         *        Optionally, you can also provide a partition or cluster placement group to use, or use Amazon EC2
         *        Dedicated Hosts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(Collection<HostInfoForCreate> hosts);

        /**
         * <p>
         * The ESXi hosts to add to the environment. Amazon EVS requires that you provide details for a minimum of 4
         * hosts during environment creation.
         * </p>
         * <p>
         * For each host, you must provide the desired hostname, EC2 SSH keypair name, and EC2 instance type.
         * Optionally, you can also provide a partition or cluster placement group to use, or use Amazon EC2 Dedicated
         * Hosts.
         * </p>
         * 
         * @param hosts
         *        The ESXi hosts to add to the environment. Amazon EVS requires that you provide details for a minimum
         *        of 4 hosts during environment creation.</p>
         *        <p>
         *        For each host, you must provide the desired hostname, EC2 SSH keypair name, and EC2 instance type.
         *        Optionally, you can also provide a partition or cluster placement group to use, or use Amazon EC2
         *        Dedicated Hosts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(HostInfoForCreate... hosts);

        /**
         * <p>
         * The ESXi hosts to add to the environment. Amazon EVS requires that you provide details for a minimum of 4
         * hosts during environment creation.
         * </p>
         * <p>
         * For each host, you must provide the desired hostname, EC2 SSH keypair name, and EC2 instance type.
         * Optionally, you can also provide a partition or cluster placement group to use, or use Amazon EC2 Dedicated
         * Hosts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.evs.model.HostInfoForCreate.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.evs.model.HostInfoForCreate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.evs.model.HostInfoForCreate.Builder#build()} is called immediately and
         * its result is passed to {@link #hosts(List<HostInfoForCreate>)}.
         * 
         * @param hosts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.evs.model.HostInfoForCreate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hosts(java.util.Collection<HostInfoForCreate>)
         */
        Builder hosts(Consumer<HostInfoForCreate.Builder>... hosts);

        /**
         * <p>
         * The connectivity configuration for the environment. Amazon EVS requires that you specify two route server
         * peer IDs. During environment creation, the route server endpoints peer with the NSX edges over the NSX uplink
         * subnet, providing BGP-based dynamic routing for overlay networks.
         * </p>
         * 
         * @param connectivityInfo
         *        The connectivity configuration for the environment. Amazon EVS requires that you specify two route
         *        server peer IDs. During environment creation, the route server endpoints peer with the NSX edges over
         *        the NSX uplink subnet, providing BGP-based dynamic routing for overlay networks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivityInfo(ConnectivityInfo connectivityInfo);

        /**
         * <p>
         * The connectivity configuration for the environment. Amazon EVS requires that you specify two route server
         * peer IDs. During environment creation, the route server endpoints peer with the NSX edges over the NSX uplink
         * subnet, providing BGP-based dynamic routing for overlay networks.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectivityInfo.Builder} avoiding the
         * need to create one manually via {@link ConnectivityInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectivityInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #connectivityInfo(ConnectivityInfo)}.
         * 
         * @param connectivityInfo
         *        a consumer that will call methods on {@link ConnectivityInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectivityInfo(ConnectivityInfo)
         */
        default Builder connectivityInfo(Consumer<ConnectivityInfo.Builder> connectivityInfo) {
            return connectivityInfo(ConnectivityInfo.builder().applyMutation(connectivityInfo).build());
        }

        /**
         * <p>
         * The DNS hostnames for the virtual machines that host the VCF management appliances. Amazon EVS requires that
         * you provide DNS hostnames for the following appliances: vCenter, NSX Manager, SDDC Manager, and Cloud
         * Builder.
         * </p>
         * 
         * @param vcfHostnames
         *        The DNS hostnames for the virtual machines that host the VCF management appliances. Amazon EVS
         *        requires that you provide DNS hostnames for the following appliances: vCenter, NSX Manager, SDDC
         *        Manager, and Cloud Builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcfHostnames(VcfHostnames vcfHostnames);

        /**
         * <p>
         * The DNS hostnames for the virtual machines that host the VCF management appliances. Amazon EVS requires that
         * you provide DNS hostnames for the following appliances: vCenter, NSX Manager, SDDC Manager, and Cloud
         * Builder.
         * </p>
         * This is a convenience method that creates an instance of the {@link VcfHostnames.Builder} avoiding the need
         * to create one manually via {@link VcfHostnames#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VcfHostnames.Builder#build()} is called immediately and its
         * result is passed to {@link #vcfHostnames(VcfHostnames)}.
         * 
         * @param vcfHostnames
         *        a consumer that will call methods on {@link VcfHostnames.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vcfHostnames(VcfHostnames)
         */
        default Builder vcfHostnames(Consumer<VcfHostnames.Builder> vcfHostnames) {
            return vcfHostnames(VcfHostnames.builder().applyMutation(vcfHostnames).build());
        }

        /**
         * <p>
         * The Broadcom Site ID that is allocated to you as part of your electronic software delivery. This ID allows
         * customer access to the Broadcom portal, and is provided to you by Broadcom at the close of your software
         * contract or contract renewal. Amazon EVS uses the Broadcom Site ID that you provide to meet Broadcom VCF
         * license usage reporting requirements for Amazon EVS.
         * </p>
         * 
         * @param siteId
         *        The Broadcom Site ID that is allocated to you as part of your electronic software delivery. This ID
         *        allows customer access to the Broadcom portal, and is provided to you by Broadcom at the close of your
         *        software contract or contract renewal. Amazon EVS uses the Broadcom Site ID that you provide to meet
         *        Broadcom VCF license usage reporting requirements for Amazon EVS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteId(String siteId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvsRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String environmentName;

        private String kmsKeyId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ServiceAccessSecurityGroups serviceAccessSecurityGroups;

        private String vpcId;

        private String serviceAccessSubnetId;

        private String vcfVersion;

        private Boolean termsAccepted;

        private List<LicenseInfo> licenseInfo = DefaultSdkAutoConstructList.getInstance();

        private InitialVlans initialVlans;

        private List<HostInfoForCreate> hosts = DefaultSdkAutoConstructList.getInstance();

        private ConnectivityInfo connectivityInfo;

        private VcfHostnames vcfHostnames;

        private String siteId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            clientToken(model.clientToken);
            environmentName(model.environmentName);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
            serviceAccessSecurityGroups(model.serviceAccessSecurityGroups);
            vpcId(model.vpcId);
            serviceAccessSubnetId(model.serviceAccessSubnetId);
            vcfVersion(model.vcfVersion);
            termsAccepted(model.termsAccepted);
            licenseInfo(model.licenseInfo);
            initialVlans(model.initialVlans);
            hosts(model.hosts);
            connectivityInfo(model.connectivityInfo);
            vcfHostnames(model.vcfHostnames);
            siteId(model.siteId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        public final ServiceAccessSecurityGroups.Builder getServiceAccessSecurityGroups() {
            return serviceAccessSecurityGroups != null ? serviceAccessSecurityGroups.toBuilder() : null;
        }

        public final void setServiceAccessSecurityGroups(ServiceAccessSecurityGroups.BuilderImpl serviceAccessSecurityGroups) {
            this.serviceAccessSecurityGroups = serviceAccessSecurityGroups != null ? serviceAccessSecurityGroups.build() : null;
        }

        @Override
        public final Builder serviceAccessSecurityGroups(ServiceAccessSecurityGroups serviceAccessSecurityGroups) {
            this.serviceAccessSecurityGroups = serviceAccessSecurityGroups;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getServiceAccessSubnetId() {
            return serviceAccessSubnetId;
        }

        public final void setServiceAccessSubnetId(String serviceAccessSubnetId) {
            this.serviceAccessSubnetId = serviceAccessSubnetId;
        }

        @Override
        public final Builder serviceAccessSubnetId(String serviceAccessSubnetId) {
            this.serviceAccessSubnetId = serviceAccessSubnetId;
            return this;
        }

        public final String getVcfVersion() {
            return vcfVersion;
        }

        public final void setVcfVersion(String vcfVersion) {
            this.vcfVersion = vcfVersion;
        }

        @Override
        public final Builder vcfVersion(String vcfVersion) {
            this.vcfVersion = vcfVersion;
            return this;
        }

        @Override
        public final Builder vcfVersion(VcfVersion vcfVersion) {
            this.vcfVersion(vcfVersion == null ? null : vcfVersion.toString());
            return this;
        }

        public final Boolean getTermsAccepted() {
            return termsAccepted;
        }

        public final void setTermsAccepted(Boolean termsAccepted) {
            this.termsAccepted = termsAccepted;
        }

        @Override
        public final Builder termsAccepted(Boolean termsAccepted) {
            this.termsAccepted = termsAccepted;
            return this;
        }

        public final List<LicenseInfo.Builder> getLicenseInfo() {
            List<LicenseInfo.Builder> result = LicenseInfoListCopier.copyToBuilder(this.licenseInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseInfo(Collection<LicenseInfo.BuilderImpl> licenseInfo) {
            this.licenseInfo = LicenseInfoListCopier.copyFromBuilder(licenseInfo);
        }

        @Override
        public final Builder licenseInfo(Collection<LicenseInfo> licenseInfo) {
            this.licenseInfo = LicenseInfoListCopier.copy(licenseInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseInfo(LicenseInfo... licenseInfo) {
            licenseInfo(Arrays.asList(licenseInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseInfo(Consumer<LicenseInfo.Builder>... licenseInfo) {
            licenseInfo(Stream.of(licenseInfo).map(c -> LicenseInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InitialVlans.Builder getInitialVlans() {
            return initialVlans != null ? initialVlans.toBuilder() : null;
        }

        public final void setInitialVlans(InitialVlans.BuilderImpl initialVlans) {
            this.initialVlans = initialVlans != null ? initialVlans.build() : null;
        }

        @Override
        public final Builder initialVlans(InitialVlans initialVlans) {
            this.initialVlans = initialVlans;
            return this;
        }

        public final List<HostInfoForCreate.Builder> getHosts() {
            List<HostInfoForCreate.Builder> result = HostInfoForCreateListCopier.copyToBuilder(this.hosts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHosts(Collection<HostInfoForCreate.BuilderImpl> hosts) {
            this.hosts = HostInfoForCreateListCopier.copyFromBuilder(hosts);
        }

        @Override
        public final Builder hosts(Collection<HostInfoForCreate> hosts) {
            this.hosts = HostInfoForCreateListCopier.copy(hosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(HostInfoForCreate... hosts) {
            hosts(Arrays.asList(hosts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(Consumer<HostInfoForCreate.Builder>... hosts) {
            hosts(Stream.of(hosts).map(c -> HostInfoForCreate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConnectivityInfo.Builder getConnectivityInfo() {
            return connectivityInfo != null ? connectivityInfo.toBuilder() : null;
        }

        public final void setConnectivityInfo(ConnectivityInfo.BuilderImpl connectivityInfo) {
            this.connectivityInfo = connectivityInfo != null ? connectivityInfo.build() : null;
        }

        @Override
        public final Builder connectivityInfo(ConnectivityInfo connectivityInfo) {
            this.connectivityInfo = connectivityInfo;
            return this;
        }

        public final VcfHostnames.Builder getVcfHostnames() {
            return vcfHostnames != null ? vcfHostnames.toBuilder() : null;
        }

        public final void setVcfHostnames(VcfHostnames.BuilderImpl vcfHostnames) {
            this.vcfHostnames = vcfHostnames != null ? vcfHostnames.build() : null;
        }

        @Override
        public final Builder vcfHostnames(VcfHostnames vcfHostnames) {
            this.vcfHostnames = vcfHostnames;
            return this;
        }

        public final String getSiteId() {
            return siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
