/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentHostRequest extends EvsRequest implements
        ToCopyableBuilder<CreateEnvironmentHostRequest.Builder, CreateEnvironmentHostRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateEnvironmentHostRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(CreateEnvironmentHostRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<HostInfoForCreate> HOST_FIELD = SdkField.<HostInfoForCreate> builder(MarshallingType.SDK_POJO)
            .memberName("host").getter(getter(CreateEnvironmentHostRequest::host)).setter(setter(Builder::host))
            .constructor(HostInfoForCreate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ENVIRONMENT_ID_FIELD, HOST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String environmentId;

    private final HostInfoForCreate host;

    private CreateEnvironmentHostRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.environmentId = builder.environmentId;
        this.host = builder.host;
    }

    /**
     * <p>
     * <note>
     * <p>
     * This parameter is not used in Amazon EVS currently. If you supply input for this parameter, it will have no
     * effect.
     * </p>
     * </note>
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the host creation request. If
     * you do not specify a client token, a randomly generated token is used for the request to ensure idempotency.
     * </p>
     * </p>
     * 
     * @return <p>
     *         This parameter is not used in Amazon EVS currently. If you supply input for this parameter, it will have
     *         no effect.
     *         </p>
     *         </note>
     *         <p>
     *         A unique, case-sensitive identifier that you provide to ensure the idempotency of the host creation
     *         request. If you do not specify a client token, a randomly generated token is used for the request to
     *         ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A unique ID for the environment that the host is added to.
     * </p>
     * 
     * @return A unique ID for the environment that the host is added to.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The host that is created and added to the environment.
     * </p>
     * 
     * @return The host that is created and added to the environment.
     */
    public final HostInfoForCreate host() {
        return host;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(host());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentHostRequest)) {
            return false;
        }
        CreateEnvironmentHostRequest other = (CreateEnvironmentHostRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(host(), other.host());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentHostRequest").add("ClientToken", clientToken())
                .add("EnvironmentId", environmentId()).add("Host", host()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "host":
            return Optional.ofNullable(clazz.cast(host()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("host", HOST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentHostRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentHostRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentHostRequest> {
        /**
         * <p>
         * <note>
         * <p>
         * This parameter is not used in Amazon EVS currently. If you supply input for this parameter, it will have no
         * effect.
         * </p>
         * </note>
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the host creation request.
         * If you do not specify a client token, a randomly generated token is used for the request to ensure
         * idempotency.
         * </p>
         * </p>
         * 
         * @param clientToken
         *        <p>
         *        This parameter is not used in Amazon EVS currently. If you supply input for this parameter, it will
         *        have no effect.
         *        </p>
         *        </note>
         *        <p>
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the host creation
         *        request. If you do not specify a client token, a randomly generated token is used for the request to
         *        ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A unique ID for the environment that the host is added to.
         * </p>
         * 
         * @param environmentId
         *        A unique ID for the environment that the host is added to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The host that is created and added to the environment.
         * </p>
         * 
         * @param host
         *        The host that is created and added to the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(HostInfoForCreate host);

        /**
         * <p>
         * The host that is created and added to the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostInfoForCreate.Builder} avoiding the
         * need to create one manually via {@link HostInfoForCreate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostInfoForCreate.Builder#build()} is called immediately and its
         * result is passed to {@link #host(HostInfoForCreate)}.
         * 
         * @param host
         *        a consumer that will call methods on {@link HostInfoForCreate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #host(HostInfoForCreate)
         */
        default Builder host(Consumer<HostInfoForCreate.Builder> host) {
            return host(HostInfoForCreate.builder().applyMutation(host).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvsRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String environmentId;

        private HostInfoForCreate host;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentHostRequest model) {
            super(model);
            clientToken(model.clientToken);
            environmentId(model.environmentId);
            host(model.host);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final HostInfoForCreate.Builder getHost() {
            return host != null ? host.toBuilder() : null;
        }

        public final void setHost(HostInfoForCreate.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        @Override
        public final Builder host(HostInfoForCreate host) {
            this.host = host;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentHostRequest build() {
            return new CreateEnvironmentHostRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
