/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A check on the environment to identify environment health and validate VMware VCF licensing compliance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Check implements SdkPojo, Serializable, ToCopyableBuilder<Check.Builder, Check> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Check::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("result")
            .getter(getter(Check::resultAsString)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<Instant> IMPAIRED_SINCE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("impairedSince").getter(getter(Check::impairedSince)).setter(setter(Builder::impairedSince))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impairedSince").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, RESULT_FIELD,
            IMPAIRED_SINCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String result;

    private final Instant impairedSince;

    private Check(BuilderImpl builder) {
        this.type = builder.type;
        this.result = builder.result;
        this.impairedSince = builder.impairedSince;
    }

    /**
     * <p>
     * The check type. Amazon EVS performs the following checks.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEY_REUSE</code>: checks that the VCF license key is not used by another Amazon EVS environment. This check
     * fails if a used license is added to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KEY_COVERAGE</code>: checks that your VCF license key allocates sufficient vCPU cores for all deployed
     * hosts. The check fails when any assigned hosts in the EVS environment are not covered by license keys, or when
     * any unassigned hosts cannot be covered by available vCPU cores in keys.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REACHABILITY</code>: checks that the Amazon EVS control plane has a persistent connection to SDDC Manager.
     * If Amazon EVS cannot reach the environment, this check fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOST_COUNT</code>: Checks that your environment has a minimum of 4 hosts, which is a requirement for VCF
     * 5.2.1.
     * </p>
     * <p>
     * If this check fails, you will need to add hosts so that your environment meets this minimum requirement. Amazon
     * EVS only supports environments with 4-16 hosts.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CheckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The check type. Amazon EVS performs the following checks.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEY_REUSE</code>: checks that the VCF license key is not used by another Amazon EVS environment.
     *         This check fails if a used license is added to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KEY_COVERAGE</code>: checks that your VCF license key allocates sufficient vCPU cores for all
     *         deployed hosts. The check fails when any assigned hosts in the EVS environment are not covered by license
     *         keys, or when any unassigned hosts cannot be covered by available vCPU cores in keys.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REACHABILITY</code>: checks that the Amazon EVS control plane has a persistent connection to SDDC
     *         Manager. If Amazon EVS cannot reach the environment, this check fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOST_COUNT</code>: Checks that your environment has a minimum of 4 hosts, which is a requirement
     *         for VCF 5.2.1.
     *         </p>
     *         <p>
     *         If this check fails, you will need to add hosts so that your environment meets this minimum requirement.
     *         Amazon EVS only supports environments with 4-16 hosts.
     *         </p>
     *         </li>
     * @see CheckType
     */
    public final CheckType type() {
        return CheckType.fromValue(type);
    }

    /**
     * <p>
     * The check type. Amazon EVS performs the following checks.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEY_REUSE</code>: checks that the VCF license key is not used by another Amazon EVS environment. This check
     * fails if a used license is added to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KEY_COVERAGE</code>: checks that your VCF license key allocates sufficient vCPU cores for all deployed
     * hosts. The check fails when any assigned hosts in the EVS environment are not covered by license keys, or when
     * any unassigned hosts cannot be covered by available vCPU cores in keys.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REACHABILITY</code>: checks that the Amazon EVS control plane has a persistent connection to SDDC Manager.
     * If Amazon EVS cannot reach the environment, this check fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOST_COUNT</code>: Checks that your environment has a minimum of 4 hosts, which is a requirement for VCF
     * 5.2.1.
     * </p>
     * <p>
     * If this check fails, you will need to add hosts so that your environment meets this minimum requirement. Amazon
     * EVS only supports environments with 4-16 hosts.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CheckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The check type. Amazon EVS performs the following checks.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEY_REUSE</code>: checks that the VCF license key is not used by another Amazon EVS environment.
     *         This check fails if a used license is added to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KEY_COVERAGE</code>: checks that your VCF license key allocates sufficient vCPU cores for all
     *         deployed hosts. The check fails when any assigned hosts in the EVS environment are not covered by license
     *         keys, or when any unassigned hosts cannot be covered by available vCPU cores in keys.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REACHABILITY</code>: checks that the Amazon EVS control plane has a persistent connection to SDDC
     *         Manager. If Amazon EVS cannot reach the environment, this check fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOST_COUNT</code>: Checks that your environment has a minimum of 4 hosts, which is a requirement
     *         for VCF 5.2.1.
     *         </p>
     *         <p>
     *         If this check fails, you will need to add hosts so that your environment meets this minimum requirement.
     *         Amazon EVS only supports environments with 4-16 hosts.
     *         </p>
     *         </li>
     * @see CheckType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The check result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link CheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The check result.
     * @see CheckResult
     */
    public final CheckResult result() {
        return CheckResult.fromValue(result);
    }

    /**
     * <p>
     * The check result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link CheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The check result.
     * @see CheckResult
     */
    public final String resultAsString() {
        return result;
    }

    /**
     * <p>
     * The time when environment health began to be impaired.
     * </p>
     * 
     * @return The time when environment health began to be impaired.
     */
    public final Instant impairedSince() {
        return impairedSince;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(impairedSince());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Check)) {
            return false;
        }
        Check other = (Check) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(resultAsString(), other.resultAsString())
                && Objects.equals(impairedSince(), other.impairedSince());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Check").add("Type", typeAsString()).add("Result", resultAsString())
                .add("ImpairedSince", impairedSince()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        case "impairedSince":
            return Optional.ofNullable(clazz.cast(impairedSince()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("impairedSince", IMPAIRED_SINCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Check, T> g) {
        return obj -> g.apply((Check) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Check> {
        /**
         * <p>
         * The check type. Amazon EVS performs the following checks.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEY_REUSE</code>: checks that the VCF license key is not used by another Amazon EVS environment. This
         * check fails if a used license is added to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KEY_COVERAGE</code>: checks that your VCF license key allocates sufficient vCPU cores for all deployed
         * hosts. The check fails when any assigned hosts in the EVS environment are not covered by license keys, or
         * when any unassigned hosts cannot be covered by available vCPU cores in keys.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REACHABILITY</code>: checks that the Amazon EVS control plane has a persistent connection to SDDC
         * Manager. If Amazon EVS cannot reach the environment, this check fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOST_COUNT</code>: Checks that your environment has a minimum of 4 hosts, which is a requirement for
         * VCF 5.2.1.
         * </p>
         * <p>
         * If this check fails, you will need to add hosts so that your environment meets this minimum requirement.
         * Amazon EVS only supports environments with 4-16 hosts.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The check type. Amazon EVS performs the following checks.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEY_REUSE</code>: checks that the VCF license key is not used by another Amazon EVS environment.
         *        This check fails if a used license is added to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KEY_COVERAGE</code>: checks that your VCF license key allocates sufficient vCPU cores for all
         *        deployed hosts. The check fails when any assigned hosts in the EVS environment are not covered by
         *        license keys, or when any unassigned hosts cannot be covered by available vCPU cores in keys.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REACHABILITY</code>: checks that the Amazon EVS control plane has a persistent connection to
         *        SDDC Manager. If Amazon EVS cannot reach the environment, this check fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOST_COUNT</code>: Checks that your environment has a minimum of 4 hosts, which is a requirement
         *        for VCF 5.2.1.
         *        </p>
         *        <p>
         *        If this check fails, you will need to add hosts so that your environment meets this minimum
         *        requirement. Amazon EVS only supports environments with 4-16 hosts.
         *        </p>
         *        </li>
         * @see CheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckType
         */
        Builder type(String type);

        /**
         * <p>
         * The check type. Amazon EVS performs the following checks.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEY_REUSE</code>: checks that the VCF license key is not used by another Amazon EVS environment. This
         * check fails if a used license is added to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KEY_COVERAGE</code>: checks that your VCF license key allocates sufficient vCPU cores for all deployed
         * hosts. The check fails when any assigned hosts in the EVS environment are not covered by license keys, or
         * when any unassigned hosts cannot be covered by available vCPU cores in keys.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REACHABILITY</code>: checks that the Amazon EVS control plane has a persistent connection to SDDC
         * Manager. If Amazon EVS cannot reach the environment, this check fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOST_COUNT</code>: Checks that your environment has a minimum of 4 hosts, which is a requirement for
         * VCF 5.2.1.
         * </p>
         * <p>
         * If this check fails, you will need to add hosts so that your environment meets this minimum requirement.
         * Amazon EVS only supports environments with 4-16 hosts.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The check type. Amazon EVS performs the following checks.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEY_REUSE</code>: checks that the VCF license key is not used by another Amazon EVS environment.
         *        This check fails if a used license is added to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KEY_COVERAGE</code>: checks that your VCF license key allocates sufficient vCPU cores for all
         *        deployed hosts. The check fails when any assigned hosts in the EVS environment are not covered by
         *        license keys, or when any unassigned hosts cannot be covered by available vCPU cores in keys.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REACHABILITY</code>: checks that the Amazon EVS control plane has a persistent connection to
         *        SDDC Manager. If Amazon EVS cannot reach the environment, this check fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOST_COUNT</code>: Checks that your environment has a minimum of 4 hosts, which is a requirement
         *        for VCF 5.2.1.
         *        </p>
         *        <p>
         *        If this check fails, you will need to add hosts so that your environment meets this minimum
         *        requirement. Amazon EVS only supports environments with 4-16 hosts.
         *        </p>
         *        </li>
         * @see CheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckType
         */
        Builder type(CheckType type);

        /**
         * <p>
         * The check result.
         * </p>
         * 
         * @param result
         *        The check result.
         * @see CheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckResult
         */
        Builder result(String result);

        /**
         * <p>
         * The check result.
         * </p>
         * 
         * @param result
         *        The check result.
         * @see CheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckResult
         */
        Builder result(CheckResult result);

        /**
         * <p>
         * The time when environment health began to be impaired.
         * </p>
         * 
         * @param impairedSince
         *        The time when environment health began to be impaired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impairedSince(Instant impairedSince);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String result;

        private Instant impairedSince;

        private BuilderImpl() {
        }

        private BuilderImpl(Check model) {
            type(model.type);
            result(model.result);
            impairedSince(model.impairedSince);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CheckType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(CheckResult result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final Instant getImpairedSince() {
            return impairedSince;
        }

        public final void setImpairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
        }

        @Override
        public final Builder impairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
            return this;
        }

        @Override
        public Check build() {
            return new Check(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
