/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.evs.EvsClient;
import software.amazon.awssdk.services.evs.internal.UserAgentUtils;
import software.amazon.awssdk.services.evs.model.Host;
import software.amazon.awssdk.services.evs.model.ListEnvironmentHostsRequest;
import software.amazon.awssdk.services.evs.model.ListEnvironmentHostsResponse;

public class ListEnvironmentHostsIterable
implements SdkIterable<ListEnvironmentHostsResponse> {
    private final EvsClient client;
    private final ListEnvironmentHostsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentHostsIterable(EvsClient client, ListEnvironmentHostsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentHostsResponseFetcher();
    }

    public Iterator<ListEnvironmentHostsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Host> environmentHosts() {
        Function<ListEnvironmentHostsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environmentHosts() != null) {
                return response.environmentHosts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentHostsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentHostsResponse> {
        private ListEnvironmentHostsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentHostsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentHostsResponse nextPage(ListEnvironmentHostsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentHostsIterable.this.client.listEnvironmentHosts(ListEnvironmentHostsIterable.this.firstRequest);
            }
            return ListEnvironmentHostsIterable.this.client.listEnvironmentHosts((ListEnvironmentHostsRequest)((Object)ListEnvironmentHostsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

