/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evidently.model.ExperimentReportName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentReport> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("content").getter(ExperimentReport.getter(ExperimentReport::content)).setter(ExperimentReport.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(ExperimentReport.getter(ExperimentReport::metricName)).setter(ExperimentReport.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<String> REPORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportName").getter(ExperimentReport.getter(ExperimentReport::reportNameAsString)).setter(ExperimentReport.setter(Builder::reportName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportName").build()}).build();
    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("treatmentName").getter(ExperimentReport.getter(ExperimentReport::treatmentName)).setter(ExperimentReport.setter(Builder::treatmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatmentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, METRIC_NAME_FIELD, REPORT_NAME_FIELD, TREATMENT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("content", CONTENT_FIELD);
            this.put("metricName", METRIC_NAME_FIELD);
            this.put("reportName", REPORT_NAME_FIELD);
            this.put("treatmentName", TREATMENT_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String content;
    private final String metricName;
    private final String reportName;
    private final String treatmentName;

    private ExperimentReport(BuilderImpl builder) {
        this.content = builder.content;
        this.metricName = builder.metricName;
        this.reportName = builder.reportName;
        this.treatmentName = builder.treatmentName;
    }

    public final String content() {
        return this.content;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final ExperimentReportName reportName() {
        return ExperimentReportName.fromValue(this.reportName);
    }

    public final String reportNameAsString() {
        return this.reportName;
    }

    public final String treatmentName() {
        return this.treatmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentReport)) {
            return false;
        }
        ExperimentReport other = (ExperimentReport)obj;
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.reportNameAsString(), other.reportNameAsString()) && Objects.equals(this.treatmentName(), other.treatmentName());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentReport").add("Content", (Object)this.content()).add("MetricName", (Object)this.metricName()).add("ReportName", (Object)this.reportNameAsString()).add("TreatmentName", (Object)this.treatmentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "reportName": {
                return Optional.ofNullable(clazz.cast(this.reportNameAsString()));
            }
            case "treatmentName": {
                return Optional.ofNullable(clazz.cast(this.treatmentName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentReport, T> g) {
        return obj -> g.apply((ExperimentReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String content;
        private String metricName;
        private String reportName;
        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentReport model) {
            this.content(model.content);
            this.metricName(model.metricName);
            this.reportName(model.reportName);
            this.treatmentName(model.treatmentName);
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getReportName() {
            return this.reportName;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        @Override
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        @Override
        public final Builder reportName(ExperimentReportName reportName) {
            this.reportName(reportName == null ? null : reportName.toString());
            return this;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public ExperimentReport build() {
            return new ExperimentReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentReport> {
        public Builder content(String var1);

        public Builder metricName(String var1);

        public Builder reportName(String var1);

        public Builder reportName(ExperimentReportName var1);

        public Builder treatmentName(String var1);
    }
}

