/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProjectDataDeliveryRequest extends EvidentlyRequest implements
        ToCopyableBuilder<UpdateProjectDataDeliveryRequest.Builder, UpdateProjectDataDeliveryRequest> {
    private static final SdkField<CloudWatchLogsDestinationConfig> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<CloudWatchLogsDestinationConfig> builder(MarshallingType.SDK_POJO).memberName("cloudWatchLogs")
            .getter(getter(UpdateProjectDataDeliveryRequest::cloudWatchLogs)).setter(setter(Builder::cloudWatchLogs))
            .constructor(CloudWatchLogsDestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()).build();

    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(UpdateProjectDataDeliveryRequest::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()).build();

    private static final SdkField<S3DestinationConfig> S3_DESTINATION_FIELD = SdkField
            .<S3DestinationConfig> builder(MarshallingType.SDK_POJO).memberName("s3Destination")
            .getter(getter(UpdateProjectDataDeliveryRequest::s3Destination)).setter(setter(Builder::s3Destination))
            .constructor(S3DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD,
            PROJECT_FIELD, S3_DESTINATION_FIELD));

    private final CloudWatchLogsDestinationConfig cloudWatchLogs;

    private final String project;

    private final S3DestinationConfig s3Destination;

    private UpdateProjectDataDeliveryRequest(BuilderImpl builder) {
        super(builder);
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.project = builder.project;
        this.s3Destination = builder.s3Destination;
    }

    /**
     * <p>
     * A structure containing the CloudWatch Logs log group where you want to store evaluation events.
     * </p>
     * 
     * @return A structure containing the CloudWatch Logs log group where you want to store evaluation events.
     */
    public final CloudWatchLogsDestinationConfig cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * <p>
     * The name or ARN of the project that you want to modify the data storage options for.
     * </p>
     * 
     * @return The name or ARN of the project that you want to modify the data storage options for.
     */
    public final String project() {
        return project;
    }

    /**
     * <p>
     * A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.
     * </p>
     * 
     * @return A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.
     */
    public final S3DestinationConfig s3Destination() {
        return s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectDataDeliveryRequest)) {
            return false;
        }
        UpdateProjectDataDeliveryRequest other = (UpdateProjectDataDeliveryRequest) obj;
        return Objects.equals(cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(project(), other.project())
                && Objects.equals(s3Destination(), other.s3Destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProjectDataDeliveryRequest").add("CloudWatchLogs", cloudWatchLogs())
                .add("Project", project()).add("S3Destination", s3Destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        case "s3Destination":
            return Optional.ofNullable(clazz.cast(s3Destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectDataDeliveryRequest, T> g) {
        return obj -> g.apply((UpdateProjectDataDeliveryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProjectDataDeliveryRequest> {
        /**
         * <p>
         * A structure containing the CloudWatch Logs log group where you want to store evaluation events.
         * </p>
         * 
         * @param cloudWatchLogs
         *        A structure containing the CloudWatch Logs log group where you want to store evaluation events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(CloudWatchLogsDestinationConfig cloudWatchLogs);

        /**
         * <p>
         * A structure containing the CloudWatch Logs log group where you want to store evaluation events.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogsDestinationConfig.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogsDestinationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogsDestinationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLogs(CloudWatchLogsDestinationConfig)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on {@link CloudWatchLogsDestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(CloudWatchLogsDestinationConfig)
         */
        default Builder cloudWatchLogs(Consumer<CloudWatchLogsDestinationConfig.Builder> cloudWatchLogs) {
            return cloudWatchLogs(CloudWatchLogsDestinationConfig.builder().applyMutation(cloudWatchLogs).build());
        }

        /**
         * <p>
         * The name or ARN of the project that you want to modify the data storage options for.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that you want to modify the data storage options for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        /**
         * <p>
         * A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.
         * </p>
         * 
         * @param s3Destination
         *        A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(S3DestinationConfig s3Destination);

        /**
         * <p>
         * A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DestinationConfig.Builder} avoiding the
         * need to create one manually via {@link S3DestinationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Destination(S3DestinationConfig)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link S3DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(S3DestinationConfig)
         */
        default Builder s3Destination(Consumer<S3DestinationConfig.Builder> s3Destination) {
            return s3Destination(S3DestinationConfig.builder().applyMutation(s3Destination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private CloudWatchLogsDestinationConfig cloudWatchLogs;

        private String project;

        private S3DestinationConfig s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectDataDeliveryRequest model) {
            super(model);
            cloudWatchLogs(model.cloudWatchLogs);
            project(model.project);
            s3Destination(model.s3Destination);
        }

        public final CloudWatchLogsDestinationConfig.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsDestinationConfig.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsDestinationConfig cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final S3DestinationConfig.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(S3DestinationConfig.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(S3DestinationConfig s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectDataDeliveryRequest build() {
            return new UpdateProjectDataDeliveryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
