/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteExperimentRequest extends EvidentlyRequest implements
        ToCopyableBuilder<DeleteExperimentRequest.Builder, DeleteExperimentRequest> {
    private static final SdkField<String> EXPERIMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("experiment").getter(getter(DeleteExperimentRequest::experiment)).setter(setter(Builder::experiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("experiment").build()).build();

    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(DeleteExperimentRequest::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_FIELD,
            PROJECT_FIELD));

    private final String experiment;

    private final String project;

    private DeleteExperimentRequest(BuilderImpl builder) {
        super(builder);
        this.experiment = builder.experiment;
        this.project = builder.project;
    }

    /**
     * <p>
     * The name of the experiment to delete.
     * </p>
     * 
     * @return The name of the experiment to delete.
     */
    public final String experiment() {
        return experiment;
    }

    /**
     * <p>
     * The name or ARN of the project that contains the experiment to delete.
     * </p>
     * 
     * @return The name or ARN of the project that contains the experiment to delete.
     */
    public final String project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(experiment());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteExperimentRequest)) {
            return false;
        }
        DeleteExperimentRequest other = (DeleteExperimentRequest) obj;
        return Objects.equals(experiment(), other.experiment()) && Objects.equals(project(), other.project());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteExperimentRequest").add("Experiment", experiment()).add("Project", project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "experiment":
            return Optional.ofNullable(clazz.cast(experiment()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteExperimentRequest, T> g) {
        return obj -> g.apply((DeleteExperimentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteExperimentRequest> {
        /**
         * <p>
         * The name of the experiment to delete.
         * </p>
         * 
         * @param experiment
         *        The name of the experiment to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experiment(String experiment);

        /**
         * <p>
         * The name or ARN of the project that contains the experiment to delete.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that contains the experiment to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private String experiment;

        private String project;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteExperimentRequest model) {
            super(model);
            experiment(model.experiment);
            project(model.project);
        }

        public final String getExperiment() {
            return experiment;
        }

        public final void setExperiment(String experiment) {
            this.experiment = experiment;
        }

        @Override
        public final Builder experiment(String experiment) {
            this.experiment = experiment;
            return this;
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteExperimentRequest build() {
            return new DeleteExperimentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
