/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eventbridge.model.EndpointEventBus;
import software.amazon.awssdk.services.eventbridge.model.EndpointEventBusListCopier;
import software.amazon.awssdk.services.eventbridge.model.EndpointState;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.services.eventbridge.model.ReplicationConfig;
import software.amazon.awssdk.services.eventbridge.model.RoutingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEndpointResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, DescribeEndpointResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::name)).setter(DescribeEndpointResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::description)).setter(DescribeEndpointResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::arn)).setter(DescribeEndpointResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<RoutingConfig> ROUTING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingConfig").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::routingConfig)).setter(DescribeEndpointResponse.setter(Builder::routingConfig)).constructor(RoutingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingConfig").build()}).build();
    private static final SdkField<ReplicationConfig> REPLICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicationConfig").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::replicationConfig)).setter(DescribeEndpointResponse.setter(Builder::replicationConfig)).constructor(ReplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfig").build()}).build();
    private static final SdkField<List<EndpointEventBus>> EVENT_BUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventBuses").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::eventBuses)).setter(DescribeEndpointResponse.setter(Builder::eventBuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointEventBus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::roleArn)).setter(DescribeEndpointResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::endpointId)).setter(DescribeEndpointResponse.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<String> ENDPOINT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointUrl").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::endpointUrl)).setter(DescribeEndpointResponse.setter(Builder::endpointUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUrl").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::stateAsString)).setter(DescribeEndpointResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::stateReason)).setter(DescribeEndpointResponse.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::creationTime)).setter(DescribeEndpointResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeEndpointResponse.getter(DescribeEndpointResponse::lastModifiedTime)).setter(DescribeEndpointResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ARN_FIELD, ROUTING_CONFIG_FIELD, REPLICATION_CONFIG_FIELD, EVENT_BUSES_FIELD, ROLE_ARN_FIELD, ENDPOINT_ID_FIELD, ENDPOINT_URL_FIELD, STATE_FIELD, STATE_REASON_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeEndpointResponse.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String arn;
    private final RoutingConfig routingConfig;
    private final ReplicationConfig replicationConfig;
    private final List<EndpointEventBus> eventBuses;
    private final String roleArn;
    private final String endpointId;
    private final String endpointUrl;
    private final String state;
    private final String stateReason;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private DescribeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.arn = builder.arn;
        this.routingConfig = builder.routingConfig;
        this.replicationConfig = builder.replicationConfig;
        this.eventBuses = builder.eventBuses;
        this.roleArn = builder.roleArn;
        this.endpointId = builder.endpointId;
        this.endpointUrl = builder.endpointUrl;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String arn() {
        return this.arn;
    }

    public final RoutingConfig routingConfig() {
        return this.routingConfig;
    }

    public final ReplicationConfig replicationConfig() {
        return this.replicationConfig;
    }

    public final boolean hasEventBuses() {
        return this.eventBuses != null && !(this.eventBuses instanceof SdkAutoConstructList);
    }

    public final List<EndpointEventBus> eventBuses() {
        return this.eventBuses;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final String endpointUrl() {
        return this.endpointUrl;
    }

    public final EndpointState state() {
        return EndpointState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventBuses() ? this.eventBuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointResponse)) {
            return false;
        }
        DescribeEndpointResponse other = (DescribeEndpointResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.routingConfig(), other.routingConfig()) && Objects.equals(this.replicationConfig(), other.replicationConfig()) && this.hasEventBuses() == other.hasEventBuses() && Objects.equals(this.eventBuses(), other.eventBuses()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.endpointUrl(), other.endpointUrl()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEndpointResponse").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Arn", (Object)this.arn()).add("RoutingConfig", (Object)this.routingConfig()).add("ReplicationConfig", (Object)this.replicationConfig()).add("EventBuses", this.hasEventBuses() ? this.eventBuses() : null).add("RoleArn", (Object)this.roleArn()).add("EndpointId", (Object)this.endpointId()).add("EndpointUrl", (Object)this.endpointUrl()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "RoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.routingConfig()));
            }
            case "ReplicationConfig": {
                return Optional.ofNullable(clazz.cast(this.replicationConfig()));
            }
            case "EventBuses": {
                return Optional.ofNullable(clazz.cast(this.eventBuses()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "EndpointUrl": {
                return Optional.ofNullable(clazz.cast(this.endpointUrl()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("RoutingConfig", ROUTING_CONFIG_FIELD);
        map.put("ReplicationConfig", REPLICATION_CONFIG_FIELD);
        map.put("EventBuses", EVENT_BUSES_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("EndpointUrl", ENDPOINT_URL_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointResponse, T> g) {
        return obj -> g.apply((DescribeEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String arn;
        private RoutingConfig routingConfig;
        private ReplicationConfig replicationConfig;
        private List<EndpointEventBus> eventBuses = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private String endpointId;
        private String endpointUrl;
        private String state;
        private String stateReason;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.arn(model.arn);
            this.routingConfig(model.routingConfig);
            this.replicationConfig(model.replicationConfig);
            this.eventBuses(model.eventBuses);
            this.roleArn(model.roleArn);
            this.endpointId(model.endpointId);
            this.endpointUrl(model.endpointUrl);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final RoutingConfig.Builder getRoutingConfig() {
            return this.routingConfig != null ? this.routingConfig.toBuilder() : null;
        }

        public final void setRoutingConfig(RoutingConfig.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        @Override
        public final Builder routingConfig(RoutingConfig routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public final ReplicationConfig.Builder getReplicationConfig() {
            return this.replicationConfig != null ? this.replicationConfig.toBuilder() : null;
        }

        public final void setReplicationConfig(ReplicationConfig.BuilderImpl replicationConfig) {
            this.replicationConfig = replicationConfig != null ? replicationConfig.build() : null;
        }

        @Override
        public final Builder replicationConfig(ReplicationConfig replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        public final List<EndpointEventBus.Builder> getEventBuses() {
            List<EndpointEventBus.Builder> result = EndpointEventBusListCopier.copyToBuilder(this.eventBuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventBuses(Collection<EndpointEventBus.BuilderImpl> eventBuses) {
            this.eventBuses = EndpointEventBusListCopier.copyFromBuilder(eventBuses);
        }

        @Override
        public final Builder eventBuses(Collection<EndpointEventBus> eventBuses) {
            this.eventBuses = EndpointEventBusListCopier.copy(eventBuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(EndpointEventBus ... eventBuses) {
            this.eventBuses(Arrays.asList(eventBuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(Consumer<EndpointEventBus.Builder> ... eventBuses) {
            this.eventBuses(Stream.of(eventBuses).map(c -> (EndpointEventBus)((EndpointEventBus.Builder)EndpointEventBus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getEndpointUrl() {
            return this.endpointUrl;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        @Override
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EndpointState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public DescribeEndpointResponse build() {
            return new DescribeEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEndpointResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder arn(String var1);

        public Builder routingConfig(RoutingConfig var1);

        default public Builder routingConfig(Consumer<RoutingConfig.Builder> routingConfig) {
            return this.routingConfig((RoutingConfig)((RoutingConfig.Builder)RoutingConfig.builder().applyMutation(routingConfig)).build());
        }

        public Builder replicationConfig(ReplicationConfig var1);

        default public Builder replicationConfig(Consumer<ReplicationConfig.Builder> replicationConfig) {
            return this.replicationConfig((ReplicationConfig)((ReplicationConfig.Builder)ReplicationConfig.builder().applyMutation(replicationConfig)).build());
        }

        public Builder eventBuses(Collection<EndpointEventBus> var1);

        public Builder eventBuses(EndpointEventBus ... var1);

        public Builder eventBuses(Consumer<EndpointEventBus.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder endpointId(String var1);

        public Builder endpointUrl(String var1);

        public Builder state(String var1);

        public Builder state(EndpointState var1);

        public Builder stateReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

