/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateArchiveRequest extends EventBridgeRequest implements
        ToCopyableBuilder<UpdateArchiveRequest.Builder, UpdateArchiveRequest> {
    private static final SdkField<String> ARCHIVE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveName").getter(getter(UpdateArchiveRequest::archiveName)).setter(setter(Builder::archiveName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateArchiveRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventPattern").getter(getter(UpdateArchiveRequest::eventPattern)).setter(setter(Builder::eventPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventPattern").build()).build();

    private static final SdkField<Integer> RETENTION_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionDays").getter(getter(UpdateArchiveRequest::retentionDays))
            .setter(setter(Builder::retentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionDays").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyIdentifier").getter(getter(UpdateArchiveRequest::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_NAME_FIELD,
            DESCRIPTION_FIELD, EVENT_PATTERN_FIELD, RETENTION_DAYS_FIELD, KMS_KEY_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String archiveName;

    private final String description;

    private final String eventPattern;

    private final Integer retentionDays;

    private final String kmsKeyIdentifier;

    private UpdateArchiveRequest(BuilderImpl builder) {
        super(builder);
        this.archiveName = builder.archiveName;
        this.description = builder.description;
        this.eventPattern = builder.eventPattern;
        this.retentionDays = builder.retentionDays;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
    }

    /**
     * <p>
     * The name of the archive to update.
     * </p>
     * 
     * @return The name of the archive to update.
     */
    public final String archiveName() {
        return archiveName;
    }

    /**
     * <p>
     * The description for the archive.
     * </p>
     * 
     * @return The description for the archive.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The event pattern to use to filter events sent to the archive.
     * </p>
     * 
     * @return The event pattern to use to filter events sent to the archive.
     */
    public final String eventPattern() {
        return eventPattern;
    }

    /**
     * <p>
     * The number of days to retain events in the archive.
     * </p>
     * 
     * @return The number of days to retain events in the archive.
     */
    public final Integer retentionDays() {
        return retentionDays;
    }

    /**
     * <p>
     * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer managed
     * key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key
     * alias ARN.
     * </p>
     * <p>
     * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to
     * encrypt the archive.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view keys</a> in the
     * <i>Key Management Service Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you have specified that EventBridge use a customer managed key for encrypting the source event bus, we
     * strongly recommend you also specify a customer managed key for any archives for the event bus as well.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html">Encrypting archives</a>
     * in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * </important>
     * 
     * @return The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
     *         managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key
     *         alias, or key alias ARN.</p>
     *         <p>
     *         If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned
     *         key to encrypt the archive.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view keys</a>
     *         in the <i>Key Management Service Developer Guide</i>.
     *         </p>
     *         <important>
     *         <p>
     *         If you have specified that EventBridge use a customer managed key for encrypting the source event bus, we
     *         strongly recommend you also specify a customer managed key for any archives for the event bus as well.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html">Encrypting
     *         archives</a> in the <i>Amazon EventBridge User Guide</i>.
     *         </p>
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(archiveName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(retentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateArchiveRequest)) {
            return false;
        }
        UpdateArchiveRequest other = (UpdateArchiveRequest) obj;
        return Objects.equals(archiveName(), other.archiveName()) && Objects.equals(description(), other.description())
                && Objects.equals(eventPattern(), other.eventPattern()) && Objects.equals(retentionDays(), other.retentionDays())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateArchiveRequest").add("ArchiveName", archiveName()).add("Description", description())
                .add("EventPattern", eventPattern()).add("RetentionDays", retentionDays())
                .add("KmsKeyIdentifier", kmsKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveName":
            return Optional.ofNullable(clazz.cast(archiveName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EventPattern":
            return Optional.ofNullable(clazz.cast(eventPattern()));
        case "RetentionDays":
            return Optional.ofNullable(clazz.cast(retentionDays()));
        case "KmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArchiveName", ARCHIVE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EventPattern", EVENT_PATTERN_FIELD);
        map.put("RetentionDays", RETENTION_DAYS_FIELD);
        map.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateArchiveRequest, T> g) {
        return obj -> g.apply((UpdateArchiveRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EventBridgeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateArchiveRequest> {
        /**
         * <p>
         * The name of the archive to update.
         * </p>
         * 
         * @param archiveName
         *        The name of the archive to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveName(String archiveName);

        /**
         * <p>
         * The description for the archive.
         * </p>
         * 
         * @param description
         *        The description for the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The event pattern to use to filter events sent to the archive.
         * </p>
         * 
         * @param eventPattern
         *        The event pattern to use to filter events sent to the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPattern(String eventPattern);

        /**
         * <p>
         * The number of days to retain events in the archive.
         * </p>
         * 
         * @param retentionDays
         *        The number of days to retain events in the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionDays(Integer retentionDays);

        /**
         * <p>
         * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
         * managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key
         * alias, or key alias ARN.
         * </p>
         * <p>
         * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to
         * encrypt the archive.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view keys</a> in
         * the <i>Key Management Service Developer Guide</i>.
         * </p>
         * <important>
         * <p>
         * If you have specified that EventBridge use a customer managed key for encrypting the source event bus, we
         * strongly recommend you also specify a customer managed key for any archives for the event bus as well.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html">Encrypting
         * archives</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * </important>
         * 
         * @param kmsKeyIdentifier
         *        The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
         *        managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId,
         *        key alias, or key alias ARN.</p>
         *        <p>
         *        If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned
         *        key to encrypt the archive.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view
         *        keys</a> in the <i>Key Management Service Developer Guide</i>.
         *        </p>
         *        <important>
         *        <p>
         *        If you have specified that EventBridge use a customer managed key for encrypting the source event bus,
         *        we strongly recommend you also specify a customer managed key for any archives for the event bus as
         *        well.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html">Encrypting
         *        archives</a> in the <i>Amazon EventBridge User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EventBridgeRequest.BuilderImpl implements Builder {
        private String archiveName;

        private String description;

        private String eventPattern;

        private Integer retentionDays;

        private String kmsKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateArchiveRequest model) {
            super(model);
            archiveName(model.archiveName);
            description(model.description);
            eventPattern(model.eventPattern);
            retentionDays(model.retentionDays);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
        }

        public final String getArchiveName() {
            return archiveName;
        }

        public final void setArchiveName(String archiveName) {
            this.archiveName = archiveName;
        }

        @Override
        public final Builder archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEventPattern() {
            return eventPattern;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final Integer getRetentionDays() {
            return retentionDays;
        }

        public final void setRetentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
        }

        @Override
        public final Builder retentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateArchiveRequest build() {
            return new UpdateArchiveRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
