/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestEventPatternRequest extends EventBridgeRequest implements
        ToCopyableBuilder<TestEventPatternRequest.Builder, TestEventPatternRequest> {
    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventPattern").getter(getter(TestEventPatternRequest::eventPattern))
            .setter(setter(Builder::eventPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventPattern").build()).build();

    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Event")
            .getter(getter(TestEventPatternRequest::event)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_PATTERN_FIELD,
            EVENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String eventPattern;

    private final String event;

    private TestEventPatternRequest(BuilderImpl builder) {
        super(builder);
        this.eventPattern = builder.eventPattern;
        this.event = builder.event;
    }

    /**
     * <p>
     * The event pattern. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and
     * Event Patterns</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
     * </p>
     * 
     * @return The event pattern. For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html"
     *         >Events and Event Patterns</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
     */
    public final String eventPattern() {
        return eventPattern;
    }

    /**
     * <p>
     * The event, in JSON format, to test against the event pattern. The JSON must follow the format specified in <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events</a>,
     * and the following fields are mandatory:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>account</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>time</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>region</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resources</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>detail-type</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The event, in JSON format, to test against the event pattern. The JSON must follow the format specified
     *         in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services
     *         Events</a>, and the following fields are mandatory:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>account</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>time</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>region</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resources</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>detail-type</code>
     *         </p>
     *         </li>
     */
    public final String event() {
        return event;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(event());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestEventPatternRequest)) {
            return false;
        }
        TestEventPatternRequest other = (TestEventPatternRequest) obj;
        return Objects.equals(eventPattern(), other.eventPattern()) && Objects.equals(event(), other.event());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestEventPatternRequest").add("EventPattern", eventPattern()).add("Event", event()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventPattern":
            return Optional.ofNullable(clazz.cast(eventPattern()));
        case "Event":
            return Optional.ofNullable(clazz.cast(event()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventPattern", EVENT_PATTERN_FIELD);
        map.put("Event", EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestEventPatternRequest, T> g) {
        return obj -> g.apply((TestEventPatternRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EventBridgeRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestEventPatternRequest> {
        /**
         * <p>
         * The event pattern. For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events
         * and Event Patterns</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
         * </p>
         * 
         * @param eventPattern
         *        The event pattern. For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html"
         *        >Events and Event Patterns</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPattern(String eventPattern);

        /**
         * <p>
         * The event, in JSON format, to test against the event pattern. The JSON must follow the format specified in <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services
         * Events</a>, and the following fields are mandatory:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>account</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>time</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resources</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>detail-type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param event
         *        The event, in JSON format, to test against the event pattern. The JSON must follow the format
         *        specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon
         *        Web Services Events</a>, and the following fields are mandatory:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>account</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>time</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>region</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resources</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>detail-type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(String event);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EventBridgeRequest.BuilderImpl implements Builder {
        private String eventPattern;

        private String event;

        private BuilderImpl() {
        }

        private BuilderImpl(TestEventPatternRequest model) {
            super(model);
            eventPattern(model.eventPattern);
            event(model.event);
        }

        public final String getEventPattern() {
            return eventPattern;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final String getEvent() {
            return event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestEventPatternRequest build() {
            return new TestEventPatternRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
