/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.auth.scheme.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eventbridge.auth.scheme.EventBridgeAuthSchemeParams;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultEventBridgeAuthSchemeParams
implements EventBridgeAuthSchemeParams {
    private final String operation;
    private final Region region;
    private final String endpointId;

    private DefaultEventBridgeAuthSchemeParams(Builder builder) {
        this.operation = (String)Validate.paramNotNull((Object)builder.operation, (String)"operation");
        this.region = builder.region;
        this.endpointId = builder.endpointId;
    }

    public static EventBridgeAuthSchemeParams.Builder builder() {
        return new Builder();
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public Region region() {
        return this.region;
    }

    @Override
    public String endpointId() {
        return this.endpointId;
    }

    @Override
    public EventBridgeAuthSchemeParams.Builder toBuilder() {
        return new Builder(this);
    }

    private static final class Builder
    implements EventBridgeAuthSchemeParams.Builder {
        private String operation;
        private Region region;
        private String endpointId;

        Builder() {
        }

        Builder(DefaultEventBridgeAuthSchemeParams params) {
            this.operation = params.operation;
            this.region = params.region;
            this.endpointId = params.endpointId;
        }

        @Override
        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        @Override
        public EventBridgeAuthSchemeParams build() {
            return new DefaultEventBridgeAuthSchemeParams(this);
        }
    }
}

