/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.services.eventbridge.model.RuleNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRuleNamesByTargetResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, ListRuleNamesByTargetResponse> {
    private static final SdkField<List<String>> RULE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleNames").getter(ListRuleNamesByTargetResponse.getter(ListRuleNamesByTargetResponse::ruleNames)).setter(ListRuleNamesByTargetResponse.setter(Builder::ruleNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRuleNamesByTargetResponse.getter(ListRuleNamesByTargetResponse::nextToken)).setter(ListRuleNamesByTargetResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAMES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> ruleNames;
    private final String nextToken;

    private ListRuleNamesByTargetResponse(BuilderImpl builder) {
        super(builder);
        this.ruleNames = builder.ruleNames;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRuleNames() {
        return this.ruleNames != null && !(this.ruleNames instanceof SdkAutoConstructList);
    }

    public final List<String> ruleNames() {
        return this.ruleNames;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleNames() ? this.ruleNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleNamesByTargetResponse)) {
            return false;
        }
        ListRuleNamesByTargetResponse other = (ListRuleNamesByTargetResponse)((Object)obj);
        return this.hasRuleNames() == other.hasRuleNames() && Objects.equals(this.ruleNames(), other.ruleNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRuleNamesByTargetResponse").add("RuleNames", this.hasRuleNames() ? this.ruleNames() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleNames": {
                return Optional.ofNullable(clazz.cast(this.ruleNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRuleNamesByTargetResponse, T> g) {
        return obj -> g.apply((ListRuleNamesByTargetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private List<String> ruleNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleNamesByTargetResponse model) {
            super(model);
            this.ruleNames(model.ruleNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getRuleNames() {
            if (this.ruleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleNames;
        }

        public final void setRuleNames(Collection<String> ruleNames) {
            this.ruleNames = RuleNameListCopier.copy(ruleNames);
        }

        @Override
        @Transient
        public final Builder ruleNames(Collection<String> ruleNames) {
            this.ruleNames = RuleNameListCopier.copy(ruleNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ruleNames(String ... ruleNames) {
            this.ruleNames(Arrays.asList(ruleNames));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRuleNamesByTargetResponse build() {
            return new ListRuleNamesByTargetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRuleNamesByTargetResponse> {
        public Builder ruleNames(Collection<String> var1);

        public Builder ruleNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

