/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.ApiDestinationHttpMethod;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApiDestinationRequest
extends EventBridgeRequest
implements ToCopyableBuilder<Builder, UpdateApiDestinationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateApiDestinationRequest.getter(UpdateApiDestinationRequest::name)).setter(UpdateApiDestinationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateApiDestinationRequest.getter(UpdateApiDestinationRequest::description)).setter(UpdateApiDestinationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionArn").getter(UpdateApiDestinationRequest.getter(UpdateApiDestinationRequest::connectionArn)).setter(UpdateApiDestinationRequest.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()}).build();
    private static final SdkField<String> INVOCATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvocationEndpoint").getter(UpdateApiDestinationRequest.getter(UpdateApiDestinationRequest::invocationEndpoint)).setter(UpdateApiDestinationRequest.setter(Builder::invocationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationEndpoint").build()}).build();
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpMethod").getter(UpdateApiDestinationRequest.getter(UpdateApiDestinationRequest::httpMethodAsString)).setter(UpdateApiDestinationRequest.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpMethod").build()}).build();
    private static final SdkField<Integer> INVOCATION_RATE_LIMIT_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InvocationRateLimitPerSecond").getter(UpdateApiDestinationRequest.getter(UpdateApiDestinationRequest::invocationRateLimitPerSecond)).setter(UpdateApiDestinationRequest.setter(Builder::invocationRateLimitPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationRateLimitPerSecond").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CONNECTION_ARN_FIELD, INVOCATION_ENDPOINT_FIELD, HTTP_METHOD_FIELD, INVOCATION_RATE_LIMIT_PER_SECOND_FIELD));
    private final String name;
    private final String description;
    private final String connectionArn;
    private final String invocationEndpoint;
    private final String httpMethod;
    private final Integer invocationRateLimitPerSecond;

    private UpdateApiDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.connectionArn = builder.connectionArn;
        this.invocationEndpoint = builder.invocationEndpoint;
        this.httpMethod = builder.httpMethod;
        this.invocationRateLimitPerSecond = builder.invocationRateLimitPerSecond;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    public final String invocationEndpoint() {
        return this.invocationEndpoint;
    }

    public final ApiDestinationHttpMethod httpMethod() {
        return ApiDestinationHttpMethod.fromValue(this.httpMethod);
    }

    public final String httpMethodAsString() {
        return this.httpMethod;
    }

    public final Integer invocationRateLimitPerSecond() {
        return this.invocationRateLimitPerSecond;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationRateLimitPerSecond());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiDestinationRequest)) {
            return false;
        }
        UpdateApiDestinationRequest other = (UpdateApiDestinationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.invocationEndpoint(), other.invocationEndpoint()) && Objects.equals(this.httpMethodAsString(), other.httpMethodAsString()) && Objects.equals(this.invocationRateLimitPerSecond(), other.invocationRateLimitPerSecond());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApiDestinationRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ConnectionArn", (Object)this.connectionArn()).add("InvocationEndpoint", (Object)this.invocationEndpoint()).add("HttpMethod", (Object)this.httpMethodAsString()).add("InvocationRateLimitPerSecond", (Object)this.invocationRateLimitPerSecond()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "InvocationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.invocationEndpoint()));
            }
            case "HttpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethodAsString()));
            }
            case "InvocationRateLimitPerSecond": {
                return Optional.ofNullable(clazz.cast(this.invocationRateLimitPerSecond()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiDestinationRequest, T> g) {
        return obj -> g.apply((UpdateApiDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String connectionArn;
        private String invocationEndpoint;
        private String httpMethod;
        private Integer invocationRateLimitPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiDestinationRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.connectionArn(model.connectionArn);
            this.invocationEndpoint(model.invocationEndpoint);
            this.httpMethod(model.httpMethod);
            this.invocationRateLimitPerSecond(model.invocationRateLimitPerSecond);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        @Transient
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getInvocationEndpoint() {
            return this.invocationEndpoint;
        }

        public final void setInvocationEndpoint(String invocationEndpoint) {
            this.invocationEndpoint = invocationEndpoint;
        }

        @Override
        @Transient
        public final Builder invocationEndpoint(String invocationEndpoint) {
            this.invocationEndpoint = invocationEndpoint;
            return this;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        @Transient
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder httpMethod(ApiDestinationHttpMethod httpMethod) {
            this.httpMethod(httpMethod == null ? null : httpMethod.toString());
            return this;
        }

        public final Integer getInvocationRateLimitPerSecond() {
            return this.invocationRateLimitPerSecond;
        }

        public final void setInvocationRateLimitPerSecond(Integer invocationRateLimitPerSecond) {
            this.invocationRateLimitPerSecond = invocationRateLimitPerSecond;
        }

        @Override
        @Transient
        public final Builder invocationRateLimitPerSecond(Integer invocationRateLimitPerSecond) {
            this.invocationRateLimitPerSecond = invocationRateLimitPerSecond;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApiDestinationRequest build() {
            return new UpdateApiDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EventBridgeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApiDestinationRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder connectionArn(String var1);

        public Builder invocationEndpoint(String var1);

        public Builder httpMethod(String var1);

        public Builder httpMethod(ApiDestinationHttpMethod var1);

        public Builder invocationRateLimitPerSecond(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

