/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisParameters> {
    private static final SdkField<String> PARTITION_KEY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartitionKeyPath").getter(KinesisParameters.getter(KinesisParameters::partitionKeyPath)).setter(KinesisParameters.setter(Builder::partitionKeyPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeyPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_KEY_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String partitionKeyPath;

    private KinesisParameters(BuilderImpl builder) {
        this.partitionKeyPath = builder.partitionKeyPath;
    }

    public String partitionKeyPath() {
        return this.partitionKeyPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKeyPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisParameters)) {
            return false;
        }
        KinesisParameters other = (KinesisParameters)obj;
        return Objects.equals(this.partitionKeyPath(), other.partitionKeyPath());
    }

    public String toString() {
        return ToString.builder((String)"KinesisParameters").add("PartitionKeyPath", (Object)this.partitionKeyPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartitionKeyPath": {
                return Optional.ofNullable(clazz.cast(this.partitionKeyPath()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisParameters, T> g) {
        return obj -> g.apply((KinesisParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String partitionKeyPath;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisParameters model) {
            this.partitionKeyPath(model.partitionKeyPath);
        }

        public final String getPartitionKeyPath() {
            return this.partitionKeyPath;
        }

        @Override
        public final Builder partitionKeyPath(String partitionKeyPath) {
            this.partitionKeyPath = partitionKeyPath;
            return this;
        }

        public final void setPartitionKeyPath(String partitionKeyPath) {
            this.partitionKeyPath = partitionKeyPath;
        }

        public KinesisParameters build() {
            return new KinesisParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisParameters> {
        public Builder partitionKeyPath(String var1);
    }
}

