/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.BatchArrayProperties;
import software.amazon.awssdk.services.eventbridge.model.BatchRetryStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchParameters> {
    private static final SdkField<String> JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchParameters.getter(BatchParameters::jobDefinition)).setter(BatchParameters.setter(Builder::jobDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinition").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchParameters.getter(BatchParameters::jobName)).setter(BatchParameters.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<BatchArrayProperties> ARRAY_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchParameters.getter(BatchParameters::arrayProperties)).setter(BatchParameters.setter(Builder::arrayProperties)).constructor(BatchArrayProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrayProperties").build()}).build();
    private static final SdkField<BatchRetryStrategy> RETRY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchParameters.getter(BatchParameters::retryStrategy)).setter(BatchParameters.setter(Builder::retryStrategy)).constructor(BatchRetryStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_FIELD, JOB_NAME_FIELD, ARRAY_PROPERTIES_FIELD, RETRY_STRATEGY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobDefinition;
    private final String jobName;
    private final BatchArrayProperties arrayProperties;
    private final BatchRetryStrategy retryStrategy;

    private BatchParameters(BuilderImpl builder) {
        this.jobDefinition = builder.jobDefinition;
        this.jobName = builder.jobName;
        this.arrayProperties = builder.arrayProperties;
        this.retryStrategy = builder.retryStrategy;
    }

    public String jobDefinition() {
        return this.jobDefinition;
    }

    public String jobName() {
        return this.jobName;
    }

    public BatchArrayProperties arrayProperties() {
        return this.arrayProperties;
    }

    public BatchRetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrayProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchParameters)) {
            return false;
        }
        BatchParameters other = (BatchParameters)obj;
        return Objects.equals(this.jobDefinition(), other.jobDefinition()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.arrayProperties(), other.arrayProperties()) && Objects.equals(this.retryStrategy(), other.retryStrategy());
    }

    public String toString() {
        return ToString.builder((String)"BatchParameters").add("JobDefinition", (Object)this.jobDefinition()).add("JobName", (Object)this.jobName()).add("ArrayProperties", (Object)this.arrayProperties()).add("RetryStrategy", (Object)this.retryStrategy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobDefinition": {
                return Optional.ofNullable(clazz.cast(this.jobDefinition()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "ArrayProperties": {
                return Optional.ofNullable(clazz.cast(this.arrayProperties()));
            }
            case "RetryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchParameters, T> g) {
        return obj -> g.apply((BatchParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobDefinition;
        private String jobName;
        private BatchArrayProperties arrayProperties;
        private BatchRetryStrategy retryStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchParameters model) {
            this.jobDefinition(model.jobDefinition);
            this.jobName(model.jobName);
            this.arrayProperties(model.arrayProperties);
            this.retryStrategy(model.retryStrategy);
        }

        public final String getJobDefinition() {
            return this.jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final BatchArrayProperties.Builder getArrayProperties() {
            return this.arrayProperties != null ? this.arrayProperties.toBuilder() : null;
        }

        @Override
        public final Builder arrayProperties(BatchArrayProperties arrayProperties) {
            this.arrayProperties = arrayProperties;
            return this;
        }

        public final void setArrayProperties(BatchArrayProperties.BuilderImpl arrayProperties) {
            this.arrayProperties = arrayProperties != null ? arrayProperties.build() : null;
        }

        public final BatchRetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(BatchRetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(BatchRetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        public BatchParameters build() {
            return new BatchParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchParameters> {
        public Builder jobDefinition(String var1);

        public Builder jobName(String var1);

        public Builder arrayProperties(BatchArrayProperties var1);

        default public Builder arrayProperties(Consumer<BatchArrayProperties.Builder> arrayProperties) {
            return this.arrayProperties((BatchArrayProperties)((BatchArrayProperties.Builder)BatchArrayProperties.builder().applyMutation(arrayProperties)).build());
        }

        public Builder retryStrategy(BatchRetryStrategy var1);

        default public Builder retryStrategy(Consumer<BatchRetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((BatchRetryStrategy)((BatchRetryStrategy.Builder)BatchRetryStrategy.builder().applyMutation(retryStrategy)).build());
        }
    }
}

