/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolutionTechniques implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolutionTechniques.Builder, ResolutionTechniques> {
    private static final SdkField<String> RESOLUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolutionType").getter(getter(ResolutionTechniques::resolutionTypeAsString))
            .setter(setter(Builder::resolutionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionType").build()).build();

    private static final SdkField<RuleBasedProperties> RULE_BASED_PROPERTIES_FIELD = SdkField
            .<RuleBasedProperties> builder(MarshallingType.SDK_POJO).memberName("ruleBasedProperties")
            .getter(getter(ResolutionTechniques::ruleBasedProperties)).setter(setter(Builder::ruleBasedProperties))
            .constructor(RuleBasedProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleBasedProperties").build())
            .build();

    private static final SdkField<RuleConditionProperties> RULE_CONDITION_PROPERTIES_FIELD = SdkField
            .<RuleConditionProperties> builder(MarshallingType.SDK_POJO).memberName("ruleConditionProperties")
            .getter(getter(ResolutionTechniques::ruleConditionProperties)).setter(setter(Builder::ruleConditionProperties))
            .constructor(RuleConditionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleConditionProperties").build())
            .build();

    private static final SdkField<ProviderProperties> PROVIDER_PROPERTIES_FIELD = SdkField
            .<ProviderProperties> builder(MarshallingType.SDK_POJO).memberName("providerProperties")
            .getter(getter(ResolutionTechniques::providerProperties)).setter(setter(Builder::providerProperties))
            .constructor(ProviderProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLUTION_TYPE_FIELD,
            RULE_BASED_PROPERTIES_FIELD, RULE_CONDITION_PROPERTIES_FIELD, PROVIDER_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resolutionType;

    private final RuleBasedProperties ruleBasedProperties;

    private final RuleConditionProperties ruleConditionProperties;

    private final ProviderProperties providerProperties;

    private ResolutionTechniques(BuilderImpl builder) {
        this.resolutionType = builder.resolutionType;
        this.ruleBasedProperties = builder.ruleBasedProperties;
        this.ruleConditionProperties = builder.ruleConditionProperties;
        this.providerProperties = builder.providerProperties;
    }

    /**
     * <p>
     * The type of matching workflow to create. Specify one of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RULE_MATCHING</code>: Match records using configurable rule-based criteria
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ML_MATCHING</code>: Match records using machine learning models
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVIDER</code>: Match records using a third-party matching provider
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolutionType}
     * will return {@link ResolutionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolutionTypeAsString}.
     * </p>
     * 
     * @return The type of matching workflow to create. Specify one of the following types: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RULE_MATCHING</code>: Match records using configurable rule-based criteria
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ML_MATCHING</code>: Match records using machine learning models
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVIDER</code>: Match records using a third-party matching provider
     *         </p>
     *         </li>
     * @see ResolutionType
     */
    public final ResolutionType resolutionType() {
        return ResolutionType.fromValue(resolutionType);
    }

    /**
     * <p>
     * The type of matching workflow to create. Specify one of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RULE_MATCHING</code>: Match records using configurable rule-based criteria
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ML_MATCHING</code>: Match records using machine learning models
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVIDER</code>: Match records using a third-party matching provider
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolutionType}
     * will return {@link ResolutionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolutionTypeAsString}.
     * </p>
     * 
     * @return The type of matching workflow to create. Specify one of the following types: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RULE_MATCHING</code>: Match records using configurable rule-based criteria
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ML_MATCHING</code>: Match records using machine learning models
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVIDER</code>: Match records using a third-party matching provider
     *         </p>
     *         </li>
     * @see ResolutionType
     */
    public final String resolutionTypeAsString() {
        return resolutionType;
    }

    /**
     * <p>
     * An object which defines the list of matching rules to run and has a field <code>rules</code>, which is a list of
     * rule objects.
     * </p>
     * 
     * @return An object which defines the list of matching rules to run and has a field <code>rules</code>, which is a
     *         list of rule objects.
     */
    public final RuleBasedProperties ruleBasedProperties() {
        return ruleBasedProperties;
    }

    /**
     * <p>
     * An object containing the <code>rules</code> for a matching workflow.
     * </p>
     * 
     * @return An object containing the <code>rules</code> for a matching workflow.
     */
    public final RuleConditionProperties ruleConditionProperties() {
        return ruleConditionProperties;
    }

    /**
     * <p>
     * The properties of the provider service.
     * </p>
     * 
     * @return The properties of the provider service.
     */
    public final ProviderProperties providerProperties() {
        return providerProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resolutionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleBasedProperties());
        hashCode = 31 * hashCode + Objects.hashCode(ruleConditionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(providerProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolutionTechniques)) {
            return false;
        }
        ResolutionTechniques other = (ResolutionTechniques) obj;
        return Objects.equals(resolutionTypeAsString(), other.resolutionTypeAsString())
                && Objects.equals(ruleBasedProperties(), other.ruleBasedProperties())
                && Objects.equals(ruleConditionProperties(), other.ruleConditionProperties())
                && Objects.equals(providerProperties(), other.providerProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolutionTechniques").add("ResolutionType", resolutionTypeAsString())
                .add("RuleBasedProperties", ruleBasedProperties()).add("RuleConditionProperties", ruleConditionProperties())
                .add("ProviderProperties", providerProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resolutionType":
            return Optional.ofNullable(clazz.cast(resolutionTypeAsString()));
        case "ruleBasedProperties":
            return Optional.ofNullable(clazz.cast(ruleBasedProperties()));
        case "ruleConditionProperties":
            return Optional.ofNullable(clazz.cast(ruleConditionProperties()));
        case "providerProperties":
            return Optional.ofNullable(clazz.cast(providerProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resolutionType", RESOLUTION_TYPE_FIELD);
        map.put("ruleBasedProperties", RULE_BASED_PROPERTIES_FIELD);
        map.put("ruleConditionProperties", RULE_CONDITION_PROPERTIES_FIELD);
        map.put("providerProperties", PROVIDER_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolutionTechniques, T> g) {
        return obj -> g.apply((ResolutionTechniques) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolutionTechniques> {
        /**
         * <p>
         * The type of matching workflow to create. Specify one of the following types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RULE_MATCHING</code>: Match records using configurable rule-based criteria
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ML_MATCHING</code>: Match records using machine learning models
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVIDER</code>: Match records using a third-party matching provider
         * </p>
         * </li>
         * </ul>
         * 
         * @param resolutionType
         *        The type of matching workflow to create. Specify one of the following types: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RULE_MATCHING</code>: Match records using configurable rule-based criteria
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ML_MATCHING</code>: Match records using machine learning models
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVIDER</code>: Match records using a third-party matching provider
         *        </p>
         *        </li>
         * @see ResolutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionType
         */
        Builder resolutionType(String resolutionType);

        /**
         * <p>
         * The type of matching workflow to create. Specify one of the following types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RULE_MATCHING</code>: Match records using configurable rule-based criteria
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ML_MATCHING</code>: Match records using machine learning models
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVIDER</code>: Match records using a third-party matching provider
         * </p>
         * </li>
         * </ul>
         * 
         * @param resolutionType
         *        The type of matching workflow to create. Specify one of the following types: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RULE_MATCHING</code>: Match records using configurable rule-based criteria
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ML_MATCHING</code>: Match records using machine learning models
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVIDER</code>: Match records using a third-party matching provider
         *        </p>
         *        </li>
         * @see ResolutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionType
         */
        Builder resolutionType(ResolutionType resolutionType);

        /**
         * <p>
         * An object which defines the list of matching rules to run and has a field <code>rules</code>, which is a list
         * of rule objects.
         * </p>
         * 
         * @param ruleBasedProperties
         *        An object which defines the list of matching rules to run and has a field <code>rules</code>, which is
         *        a list of rule objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleBasedProperties(RuleBasedProperties ruleBasedProperties);

        /**
         * <p>
         * An object which defines the list of matching rules to run and has a field <code>rules</code>, which is a list
         * of rule objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleBasedProperties.Builder} avoiding the
         * need to create one manually via {@link RuleBasedProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleBasedProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #ruleBasedProperties(RuleBasedProperties)}.
         * 
         * @param ruleBasedProperties
         *        a consumer that will call methods on {@link RuleBasedProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleBasedProperties(RuleBasedProperties)
         */
        default Builder ruleBasedProperties(Consumer<RuleBasedProperties.Builder> ruleBasedProperties) {
            return ruleBasedProperties(RuleBasedProperties.builder().applyMutation(ruleBasedProperties).build());
        }

        /**
         * <p>
         * An object containing the <code>rules</code> for a matching workflow.
         * </p>
         * 
         * @param ruleConditionProperties
         *        An object containing the <code>rules</code> for a matching workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleConditionProperties(RuleConditionProperties ruleConditionProperties);

        /**
         * <p>
         * An object containing the <code>rules</code> for a matching workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleConditionProperties.Builder} avoiding
         * the need to create one manually via {@link RuleConditionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleConditionProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #ruleConditionProperties(RuleConditionProperties)}.
         * 
         * @param ruleConditionProperties
         *        a consumer that will call methods on {@link RuleConditionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleConditionProperties(RuleConditionProperties)
         */
        default Builder ruleConditionProperties(Consumer<RuleConditionProperties.Builder> ruleConditionProperties) {
            return ruleConditionProperties(RuleConditionProperties.builder().applyMutation(ruleConditionProperties).build());
        }

        /**
         * <p>
         * The properties of the provider service.
         * </p>
         * 
         * @param providerProperties
         *        The properties of the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerProperties(ProviderProperties providerProperties);

        /**
         * <p>
         * The properties of the provider service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderProperties.Builder} avoiding the
         * need to create one manually via {@link ProviderProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #providerProperties(ProviderProperties)}.
         * 
         * @param providerProperties
         *        a consumer that will call methods on {@link ProviderProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerProperties(ProviderProperties)
         */
        default Builder providerProperties(Consumer<ProviderProperties.Builder> providerProperties) {
            return providerProperties(ProviderProperties.builder().applyMutation(providerProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resolutionType;

        private RuleBasedProperties ruleBasedProperties;

        private RuleConditionProperties ruleConditionProperties;

        private ProviderProperties providerProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolutionTechniques model) {
            resolutionType(model.resolutionType);
            ruleBasedProperties(model.ruleBasedProperties);
            ruleConditionProperties(model.ruleConditionProperties);
            providerProperties(model.providerProperties);
        }

        public final String getResolutionType() {
            return resolutionType;
        }

        public final void setResolutionType(String resolutionType) {
            this.resolutionType = resolutionType;
        }

        @Override
        public final Builder resolutionType(String resolutionType) {
            this.resolutionType = resolutionType;
            return this;
        }

        @Override
        public final Builder resolutionType(ResolutionType resolutionType) {
            this.resolutionType(resolutionType == null ? null : resolutionType.toString());
            return this;
        }

        public final RuleBasedProperties.Builder getRuleBasedProperties() {
            return ruleBasedProperties != null ? ruleBasedProperties.toBuilder() : null;
        }

        public final void setRuleBasedProperties(RuleBasedProperties.BuilderImpl ruleBasedProperties) {
            this.ruleBasedProperties = ruleBasedProperties != null ? ruleBasedProperties.build() : null;
        }

        @Override
        public final Builder ruleBasedProperties(RuleBasedProperties ruleBasedProperties) {
            this.ruleBasedProperties = ruleBasedProperties;
            return this;
        }

        public final RuleConditionProperties.Builder getRuleConditionProperties() {
            return ruleConditionProperties != null ? ruleConditionProperties.toBuilder() : null;
        }

        public final void setRuleConditionProperties(RuleConditionProperties.BuilderImpl ruleConditionProperties) {
            this.ruleConditionProperties = ruleConditionProperties != null ? ruleConditionProperties.build() : null;
        }

        @Override
        public final Builder ruleConditionProperties(RuleConditionProperties ruleConditionProperties) {
            this.ruleConditionProperties = ruleConditionProperties;
            return this;
        }

        public final ProviderProperties.Builder getProviderProperties() {
            return providerProperties != null ? providerProperties.toBuilder() : null;
        }

        public final void setProviderProperties(ProviderProperties.BuilderImpl providerProperties) {
            this.providerProperties = providerProperties != null ? providerProperties.build() : null;
        }

        @Override
        public final Builder providerProperties(ProviderProperties providerProperties) {
            this.providerProperties = providerProperties;
            return this;
        }

        @Override
        public ResolutionTechniques build() {
            return new ResolutionTechniques(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
