/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.ResolutionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchingWorkflowSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatchingWorkflowSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(MatchingWorkflowSummary.getter(MatchingWorkflowSummary::createdAt)).setter(MatchingWorkflowSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> RESOLUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolutionType").getter(MatchingWorkflowSummary.getter(MatchingWorkflowSummary::resolutionTypeAsString)).setter(MatchingWorkflowSummary.setter(Builder::resolutionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionType").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(MatchingWorkflowSummary.getter(MatchingWorkflowSummary::updatedAt)).setter(MatchingWorkflowSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowArn").getter(MatchingWorkflowSummary.getter(MatchingWorkflowSummary::workflowArn)).setter(MatchingWorkflowSummary.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowArn").build()}).build();
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowName").getter(MatchingWorkflowSummary.getter(MatchingWorkflowSummary::workflowName)).setter(MatchingWorkflowSummary.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, RESOLUTION_TYPE_FIELD, UPDATED_AT_FIELD, WORKFLOW_ARN_FIELD, WORKFLOW_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("resolutionType", RESOLUTION_TYPE_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("workflowArn", WORKFLOW_ARN_FIELD);
            this.put("workflowName", WORKFLOW_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String resolutionType;
    private final Instant updatedAt;
    private final String workflowArn;
    private final String workflowName;

    private MatchingWorkflowSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.resolutionType = builder.resolutionType;
        this.updatedAt = builder.updatedAt;
        this.workflowArn = builder.workflowArn;
        this.workflowName = builder.workflowName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ResolutionType resolutionType() {
        return ResolutionType.fromValue(this.resolutionType);
    }

    public final String resolutionTypeAsString() {
        return this.resolutionType;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final String workflowName() {
        return this.workflowName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchingWorkflowSummary)) {
            return false;
        }
        MatchingWorkflowSummary other = (MatchingWorkflowSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.resolutionTypeAsString(), other.resolutionTypeAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.workflowArn(), other.workflowArn()) && Objects.equals(this.workflowName(), other.workflowName());
    }

    public final String toString() {
        return ToString.builder((String)"MatchingWorkflowSummary").add("CreatedAt", (Object)this.createdAt()).add("ResolutionType", (Object)this.resolutionTypeAsString()).add("UpdatedAt", (Object)this.updatedAt()).add("WorkflowArn", (Object)this.workflowArn()).add("WorkflowName", (Object)this.workflowName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "resolutionType": {
                return Optional.ofNullable(clazz.cast(this.resolutionTypeAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "workflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "workflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MatchingWorkflowSummary, T> g) {
        return obj -> g.apply((MatchingWorkflowSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String resolutionType;
        private Instant updatedAt;
        private String workflowArn;
        private String workflowName;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchingWorkflowSummary model) {
            this.createdAt(model.createdAt);
            this.resolutionType(model.resolutionType);
            this.updatedAt(model.updatedAt);
            this.workflowArn(model.workflowArn);
            this.workflowName(model.workflowName);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getResolutionType() {
            return this.resolutionType;
        }

        public final void setResolutionType(String resolutionType) {
            this.resolutionType = resolutionType;
        }

        @Override
        public final Builder resolutionType(String resolutionType) {
            this.resolutionType = resolutionType;
            return this;
        }

        @Override
        public final Builder resolutionType(ResolutionType resolutionType) {
            this.resolutionType(resolutionType == null ? null : resolutionType.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public MatchingWorkflowSummary build() {
            return new MatchingWorkflowSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatchingWorkflowSummary> {
        public Builder createdAt(Instant var1);

        public Builder resolutionType(String var1);

        public Builder resolutionType(ResolutionType var1);

        public Builder updatedAt(Instant var1);

        public Builder workflowArn(String var1);

        public Builder workflowName(String var1);
    }
}

